/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculator;
import org.apache.oozie.sla.SLACalculatorMemory;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.workflow.WorkflowInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSLACalculatorMemory
extends XDataTestCase {
    private Services services;
    private JPAService jpaService;
    private Instrumentation instrumentation;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService,org.apache.oozie.sla.service.SLAService,org.apache.oozie.service.InstrumentationService");
        conf.setInt("oozie.sla.service.SLAService.check.interval", 600);
        this.services.init();
        this.jpaService = (JPAService)this.services.get(JPAService.class);
        this.instrumentation = ((InstrumentationService)this.services.get(InstrumentationService.class)).get();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void createWorkflow(List<String> idList) throws Exception {
        ArrayList<WorkflowJobBean> insertList = new ArrayList<WorkflowJobBean>();
        for (String id : idList) {
            WorkflowJobBean workflow = new WorkflowJobBean();
            workflow.setId(id);
            workflow.setStatusStr("PREP");
            workflow.setStartTime(new Date());
            insertList.add(workflow);
        }
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
    }

    @Test
    public void testLoadOnRestart() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        SLARegistrationBean slaRegBean1 = this._createSLARegistration("job-1-W", AppType.WORKFLOW_JOB);
        String jobId1 = slaRegBean1.getId();
        SLARegistrationBean slaRegBean2 = this._createSLARegistration("job-2-W", AppType.WORKFLOW_JOB);
        String jobId2 = slaRegBean2.getId();
        SLARegistrationBean slaRegBean3 = this._createSLARegistration("job-3-W", AppType.WORKFLOW_JOB);
        String jobId3 = slaRegBean3.getId();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(slaRegBean1.getId());
        idList.add(slaRegBean2.getId());
        idList.add(slaRegBean3.getId());
        this.createWorkflow(idList);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        slaRegBean1.setAppName("app-name");
        slaRegBean1.setExpectedDuration(123L);
        slaRegBean1.setExpectedEnd(sdf.parse("2012-02-07"));
        slaRegBean1.setExpectedStart(sdf.parse("2011-02-07"));
        slaRegBean1.setNominalTime(sdf.parse("2012-01-06"));
        slaRegBean1.setUser("user");
        slaRegBean1.setParentId("parentId");
        slaRegBean1.setUpstreamApps("upstreamApps");
        slaRegBean1.setNotificationMsg("notificationMsg");
        slaRegBean1.setAlertContact("a@abc.com");
        slaRegBean1.setAlertEvents("MISS");
        slaRegBean1.setJobData("jobData");
        Date startTime = new Date(System.currentTimeMillis() - 3600000L);
        Date endTime = new Date(System.currentTimeMillis() + 0x6DDD00L);
        slaRegBean3.setExpectedStart(startTime);
        slaRegBean3.setExpectedEnd(endTime);
        slaCalcMemory.addRegistration(jobId1, slaRegBean1);
        slaCalcMemory.addRegistration(jobId2, slaRegBean2);
        slaCalcMemory.addRegistration(jobId3, slaRegBean3);
        slaCalcMemory.updateAllSlaStatus();
        SLACalcStatus calc1 = slaCalcMemory.get(jobId1);
        SLACalcStatus calc2 = slaCalcMemory.get(jobId2);
        SLACalcStatus calc3 = slaCalcMemory.get(jobId3);
        calc1.setEventStatus(SLAEvent.EventStatus.END_MISS);
        calc1.setSLAStatus(SLAEvent.SLAStatus.MISS);
        calc1.setJobStatus(WorkflowJob.Status.FAILED.toString());
        Date lastModifiedTime = new Date(System.currentTimeMillis() - 432000000L);
        calc1.setLastModifiedTime(lastModifiedTime);
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        WorkflowJobBean wf1 = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId1});
        wf1.setId(jobId1);
        wf1.setStatus(WorkflowJob.Status.SUCCEEDED);
        wf1.setStartTime(sdf.parse("2011-03-09"));
        wf1.setEndTime(sdf.parse("2011-03-10"));
        wf1.setLastModifiedTime(new Date());
        WorkflowJobBean wf2 = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId2});
        wf2.setId(jobId2);
        wf2.setStatus(WorkflowJob.Status.RUNNING);
        wf2.setStartTime(sdf.parse("2011-03-09"));
        wf2.setEndTime(null);
        wf2.setLastModifiedTime(new Date());
        WorkflowJobBean wf3 = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId3});
        wf3.setId(jobId3);
        wf3.setStatus(WorkflowJob.Status.RUNNING);
        wf3.setStartTime(startTime);
        wf3.setEndTime(null);
        wf3.setLastModifiedTime(new Date());
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (JsonBean)wf1));
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (JsonBean)wf2));
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (JsonBean)wf3));
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (JsonBean)new SLASummaryBean(calc2)));
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (JsonBean)new SLASummaryBean(calc3)));
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, updateList, null);
        slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMemory.updateAllSlaStatus();
        SLACalcStatus calc = new SLACalcStatus((SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1}), (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, new Object[]{jobId1}));
        TestSLACalculatorMemory.assertEquals((String)"job-1-W", (String)calc.getId());
        TestSLACalculatorMemory.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)calc.getAppType());
        TestSLACalculatorMemory.assertEquals((String)"app-name", (String)calc.getAppName());
        TestSLACalculatorMemory.assertEquals((long)123L, (long)calc.getExpectedDuration());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-02-07"), (Object)calc.getExpectedEnd());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2011-02-07"), (Object)calc.getExpectedStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-01-06"), (Object)calc.getNominalTime());
        TestSLACalculatorMemory.assertEquals((String)"user", (String)calc.getUser());
        TestSLACalculatorMemory.assertEquals((String)"parentId", (String)calc.getParentId());
        TestSLACalculatorMemory.assertEquals((String)"upstreamApps", (String)calc.getUpstreamApps());
        TestSLACalculatorMemory.assertEquals((String)"notificationMsg", (String)calc.getNotificationMsg());
        TestSLACalculatorMemory.assertEquals((String)"a@abc.com", (String)calc.getAlertContact());
        TestSLACalculatorMemory.assertEquals((String)"MISS", (String)calc.getAlertEvents());
        TestSLACalculatorMemory.assertEquals((String)"jobData", (String)calc.getJobData());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2011-03-09"), (Object)calc.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2011-03-10"), (Object)calc.getActualEnd());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)calc1.getEventStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)calc1.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((String)WorkflowJob.Status.FAILED.toString(), (String)calc1.getJobStatus());
        TestSLACalculatorMemory.assertEquals((Object)lastModifiedTime, (Object)calc1.getLastModifiedTime());
        calc2 = new SLACalcStatus((SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId2}), (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ON_RESTART, new Object[]{jobId2}));
        TestSLACalculatorMemory.assertEquals((int)8, (int)calc.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)7, (int)calc2.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)1, (int)slaCalcMemory.size());
        WorkflowJobBean wf = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId3});
        wf.setId(jobId3);
        wf.setStatus(WorkflowJob.Status.SUCCEEDED);
        wf.setEndTime(endTime);
        wf.setStartTime(startTime);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wf);
        slaCalcMemory.addJobStatus(jobId3, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, startTime, endTime);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId3});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)startTime, (Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)endTime, (Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((String)WorkflowJob.Status.SUCCEEDED.toString(), (String)slaSummary.getJobStatus());
    }

    @Test
    public void testWorkflowJobSLAStatusOnRestart() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        SLARegistrationBean slaRegBean1 = this._createSLARegistration("job-1-W", AppType.WORKFLOW_JOB);
        final String jobId1 = slaRegBean1.getId();
        slaRegBean1.setExpectedEnd(sdf.parse("2013-03-07"));
        slaRegBean1.setExpectedStart(sdf.parse("2012-03-07"));
        slaCalcMemory.addRegistration(jobId1, slaRegBean1);
        SLACalcStatus calc1 = slaCalcMemory.get(jobId1);
        calc1.setEventProcessed(1);
        calc1.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        calc1.setJobStatus(WorkflowJob.Status.RUNNING.name());
        calc1.setLastModifiedTime(new Date());
        SLASummaryBean slaSummaryBean = new SLASummaryBean(calc1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummaryBean);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        WorkflowJobBean wjb = new WorkflowJobBean();
        wjb.setId(jobId1);
        wjb.setStatus(WorkflowJob.Status.SUCCEEDED);
        wjb.setStartTime(sdf.parse("2012-02-07"));
        wjb.setEndTime(sdf.parse("2013-02-07"));
        wjb.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().insert((JsonBean)wjb);
        slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMemory.updateAllSlaStatus();
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        TestSLACalculatorMemory.assertEquals((String)"job-1-W", (String)slaSummary.getId());
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)slaSummary.getAppType());
        TestSLACalculatorMemory.assertEquals((String)"SUCCEEDED", (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-02-07"), (Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2013-02-07"), (Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((long)(sdf.parse("2013-02-07").getTime() - sdf.parse("2012-02-07").getTime()), (long)slaSummary.getActualDuration());
        wjb.setStatus(WorkflowJob.Status.FAILED);
        wjb.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wjb);
        calc1.setEventProcessed(1);
        calc1.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        calc1.setJobStatus(WorkflowJob.Status.RUNNING.name());
        slaSummaryBean = new SLASummaryBean(calc1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummaryBean);
        slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMemory.updateAllSlaStatus();
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        TestSLACalculatorMemory.assertEquals((String)"FAILED", (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-02-07"), (Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2013-02-07"), (Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        wjb.setStatus(WorkflowJob.Status.RUNNING);
        wjb.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)wjb);
        calc1.setEventProcessed(0);
        calc1.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
        calc1.setJobStatus(null);
        slaSummaryBean = new SLASummaryBean(calc1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummaryBean);
        SLAService slaService = (SLAService)Services.get().get(SLAService.class);
        slaService.startSLAWorker();
        slaService.addStatusEvent(jobId1, "RUNNING", null, null, null);
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ((SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1})).getEventProcessed() == 7;
            }
        });
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{slaSummaryBean.getId()});
        TestSLACalculatorMemory.assertEquals((int)7, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((String)"RUNNING", (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-02-07"), (Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertNull((Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((long)-1L, (long)slaSummary.getActualDuration());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
    }

    @Test
    public void testWorkflowActionSLAStatusOnRestart() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        SLARegistrationBean slaRegBean1 = this._createSLARegistration("job-W@1", AppType.WORKFLOW_ACTION);
        String jobId1 = slaRegBean1.getId();
        slaRegBean1.setExpectedEnd(sdf.parse("2013-03-07"));
        slaRegBean1.setExpectedStart(sdf.parse("2012-03-07"));
        slaCalcMemory.addRegistration(jobId1, slaRegBean1);
        SLACalcStatus calc1 = slaCalcMemory.get(jobId1);
        calc1.setEventProcessed(1);
        calc1.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        calc1.setJobStatus(WorkflowAction.Status.RUNNING.name());
        calc1.setLastModifiedTime(new Date());
        SLASummaryBean slaSummaryBean = new SLASummaryBean(calc1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummaryBean);
        WorkflowActionBean wab = new WorkflowActionBean();
        wab.setId(jobId1);
        wab.setStatus(WorkflowAction.Status.OK);
        wab.setStartTime(sdf.parse("2012-02-07"));
        wab.setEndTime(sdf.parse("2013-02-07"));
        WorkflowActionInsertJPAExecutor wfInsertCmd = new WorkflowActionInsertJPAExecutor(wab);
        this.jpaService.execute((JPAExecutor)wfInsertCmd);
        slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMemory.updateAllSlaStatus();
        TestSLACalculatorMemory.assertEquals((int)0, (int)slaCalcMemory.size());
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        TestSLACalculatorMemory.assertEquals((String)"job-W@1", (String)slaSummary.getId());
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)AppType.WORKFLOW_ACTION, (Object)slaSummary.getAppType());
        TestSLACalculatorMemory.assertEquals((String)"OK", (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-02-07"), (Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2013-02-07"), (Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((long)(sdf.parse("2013-02-07").getTime() - sdf.parse("2012-02-07").getTime()), (long)slaSummary.getActualDuration());
    }

    @Test
    public void testCoordinatorActionSLAStatusOnRestart() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        SLARegistrationBean slaRegBean1 = this._createSLARegistration("job-C@1", AppType.COORDINATOR_ACTION);
        String jobId1 = slaRegBean1.getId();
        slaRegBean1.setExpectedEnd(sdf.parse("2013-03-07"));
        slaRegBean1.setExpectedStart(sdf.parse("2012-03-07"));
        slaCalcMemory.addRegistration(jobId1, slaRegBean1);
        SLACalcStatus calc1 = slaCalcMemory.get(jobId1);
        calc1.setEventProcessed(1);
        calc1.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        calc1.setJobStatus(WorkflowAction.Status.RUNNING.name());
        calc1.setLastModifiedTime(new Date());
        SLASummaryBean slaSummaryBean = new SLASummaryBean(calc1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummaryBean);
        CoordinatorActionBean cab = new CoordinatorActionBean();
        cab.setId(jobId1);
        cab.setStatus(CoordinatorAction.Status.FAILED);
        cab.setLastModifiedTime(sdf.parse("2013-02-07"));
        cab.setExternalId("wf_job-W");
        CoordActionInsertJPAExecutor caInsertCmd = new CoordActionInsertJPAExecutor(cab);
        this.jpaService.execute((JPAExecutor)caInsertCmd);
        WorkflowJobBean wjb = new WorkflowJobBean();
        wjb.setId("wf_job-W");
        wjb.setStartTime(sdf.parse("2012-02-07"));
        wjb.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().insert((JsonBean)wjb);
        slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMemory.updateAllSlaStatus();
        TestSLACalculatorMemory.assertEquals((int)0, (int)slaCalcMemory.size());
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        TestSLACalculatorMemory.assertEquals((String)"job-C@1", (String)slaSummary.getId());
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)slaSummary.getAppType());
        TestSLACalculatorMemory.assertEquals((String)"FAILED", (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-02-07"), (Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2013-02-07"), (Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((long)(sdf.parse("2013-02-07").getTime() - sdf.parse("2012-02-07").getTime()), (long)slaSummary.getActualDuration());
    }

    @Test
    public void testEventMissOnRestart() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        CoordinatorActionBean coordAction = new CoordinatorActionBean();
        coordAction.setId("coordActionId-C@1");
        coordAction.setStatus(CoordinatorAction.Status.RUNNING);
        coordAction.setLastModifiedTime(sdf.parse("2013-02-07"));
        CoordActionInsertJPAExecutor caInsertCmd = new CoordActionInsertJPAExecutor(coordAction);
        this.jpaService.execute((JPAExecutor)caInsertCmd);
        CoordinatorActionBean coordAction2 = new CoordinatorActionBean();
        coordAction2.setId("coordActionId-C@2");
        coordAction2.setStatus(CoordinatorAction.Status.RUNNING);
        coordAction2.setLastModifiedTime(sdf.parse("2013-02-07"));
        caInsertCmd = new CoordActionInsertJPAExecutor(coordAction2);
        this.jpaService.execute((JPAExecutor)caInsertCmd);
        SLARegistrationBean slaRegBean1 = this._createSLARegistration("coordActionId-C@1", AppType.COORDINATOR_ACTION);
        String jobId1 = slaRegBean1.getId();
        slaRegBean1.setExpectedEnd(sdf.parse("2013-03-07"));
        slaRegBean1.setExpectedStart(sdf.parse("2012-03-07"));
        slaRegBean1.setExpectedDuration(100000L);
        slaCalcMemory.addRegistration(jobId1, slaRegBean1);
        slaCalcMemory.updateAllSlaStatus();
        SLARegistrationBean slaRegBean2 = this._createSLARegistration("coordActionId-C@2", AppType.COORDINATOR_ACTION);
        String jobId2 = slaRegBean2.getId();
        slaRegBean2.setExpectedStart(new Date(System.currentTimeMillis() + 3600000L));
        slaRegBean2.setExpectedEnd(new Date(System.currentTimeMillis() + 0x6DDD00L));
        slaRegBean2.setExpectedDuration(100000L);
        slaCalcMemory.addRegistration(jobId2, slaRegBean2);
        slaCalcMemory.updateAllSlaStatus();
        TestSLACalculatorMemory.assertEquals((int)2, (int)slaCalcMemory.size());
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        SLASummaryBean slaSummary2 = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId2});
        TestSLACalculatorMemory.assertEquals((String)"coordActionId-C@1", (String)slaSummary.getId());
        TestSLACalculatorMemory.assertEquals((int)5, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((long)-1L, (long)slaSummary.getActualDuration());
        TestSLACalculatorMemory.assertEquals((String)"coordActionId-C@2", (String)slaSummary2.getId());
        TestSLACalculatorMemory.assertEquals((int)0, (int)slaSummary2.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((long)-1L, (long)slaSummary2.getActualDuration());
        coordAction.setStatusStr("FAILED");
        coordAction2.setStatusStr("FAILED");
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_START, (Object)coordAction);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_START, (Object)coordAction2);
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMemory.updateAllSlaStatus();
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId1});
        slaSummary2 = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId2});
        TestSLACalculatorMemory.assertEquals((String)"coordActionId-C@1", (String)slaSummary.getId());
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((String)"coordActionId-C@2", (String)slaSummary2.getId());
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary2.getEventProcessed());
    }

    @Test
    public void testSLAEvents1() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        slaRegBean.setExpectedStart(new Date(System.currentTimeMillis() - 3600000L));
        slaRegBean.setExpectedDuration(0x6DDD00L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(jobId, slaRegBean);
        TestSLACalculatorMemory.assertEquals((int)1, (int)slaCalcMemory.size());
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.NOT_STARTED, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((String)"PREP", (String)slaSummary.getJobStatus());
        slaCalcMemory.updateJobSla(jobId);
        TestSLACalculatorMemory.assertEquals((int)2, (int)ehs.getEventQueue().size());
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)5, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaSummary.getEventStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        job1.setStatusStr(WorkflowJob.Status.SUSPENDED.toString());
        job1.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.SUSPENDED.toString(), JobEvent.EventStatus.SUSPEND, sdf.parse("2012-01-01"), null);
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((String)WorkflowJob.Status.SUSPENDED.toString(), (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((int)5, (int)slaSummary.getEventProcessed());
        job1.setStatusStr(WorkflowJob.Status.SUCCEEDED.toString());
        job1.setLastModifiedTime(new Date());
        job1.setStartTime(sdf.parse("2012-01-01"));
        job1.setEndTime(sdf.parse("2012-01-02"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, sdf.parse("2012-01-01"), sdf.parse("2012-01-02"));
        TestSLACalculatorMemory.assertEquals((int)3, (int)ehs.getEventQueue().size());
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((String)WorkflowJob.Status.SUCCEEDED.toString(), (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.EventStatus.DURATION_MISS, (Object)slaSummary.getEventStatus());
        TestSLACalculatorMemory.assertEquals((long)sdf.parse("2012-01-01").getTime(), (long)slaSummary.getActualStart().getTime());
        TestSLACalculatorMemory.assertEquals((long)sdf.parse("2012-01-02").getTime(), (long)slaSummary.getActualEnd().getTime());
        TestSLACalculatorMemory.assertEquals((long)(sdf.parse("2012-01-02").getTime() - sdf.parse("2012-01-01").getTime()), (long)slaSummary.getActualDuration());
        TestSLACalculatorMemory.assertEquals((int)0, (int)slaCalcMemory.size());
    }

    @Test
    public void testSLAEvents2() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        slaRegBean.setExpectedStart(new Date(System.currentTimeMillis() - 3600000L));
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() + 0x6DDD00L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(jobId, slaRegBean);
        TestSLACalculatorMemory.assertEquals((int)1, (int)slaCalcMemory.size());
        slaCalcMemory.updateJobSla(jobId);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)3, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)1, (int)ehs.getEventQueue().size());
        ehs.getEventQueue().clear();
        slaSummary.setEventProcessed(1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummary);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        job1.setStatus(WorkflowJob.Status.SUCCEEDED);
        job1.setStartTime(sdf.parse("2012-01-01"));
        job1.setEndTime(sdf.parse("2012-01-02"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, sdf.parse("2012-01-01"), sdf.parse("2012-01-02"));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)1, (int)ehs.getEventQueue().size());
        ehs.getEventQueue().clear();
        slaSummary.setEventProcessed(1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummary);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        slaRegBean = this._createSLARegistration(job2.getId(), AppType.WORKFLOW_JOB);
        slaRegBean.setExpectedStart(new Date(System.currentTimeMillis() - 3600000L));
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() + 0x6DDD00L));
        jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(jobId, slaRegBean);
        TestSLACalculatorMemory.assertEquals((int)1, (int)slaCalcMemory.size());
        job2.setStatus(WorkflowJob.Status.KILLED);
        job2.setEndTime(sdf.parse("2012-01-02"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job2);
        slaCalcMemory.addJobStatus(job2.getId(), WorkflowJob.Status.KILLED.toString(), JobEvent.EventStatus.FAILURE, null, sdf.parse("2012-01-02"));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)1, (int)ehs.getEventQueue().size());
        TestSLACalculatorMemory.assertNull((Object)slaSummary.getActualStart());
        TestSLACalculatorMemory.assertEquals((Object)sdf.parse("2012-01-02"), (Object)slaSummary.getActualEnd());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaSummary.getEventStatus());
    }

    @Test
    public void testDuplicateStartMiss() throws Exception {
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        Date startTime = new Date(System.currentTimeMillis() - 3600000L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(0x6DDD00L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() + 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(slaRegBean.getId(), slaRegBean);
        slaCalcMemory.updateJobSla(jobId);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)1, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.NOT_STARTED, (Object)slaSummary.getSLAStatus());
        job1.setStatus(WorkflowJob.Status.RUNNING);
        job1.setStartTime(startTime);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.RUNNING.toString(), JobEvent.EventStatus.STARTED, new Date(System.currentTimeMillis()), null);
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)1, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((String)WorkflowJob.Status.RUNNING.toString(), (String)slaSummary.getJobStatus());
        TestSLACalculatorMemory.assertEquals((int)1, (int)ehs.getEventQueue().size());
    }

    @Test
    public void testDuplicateEndMiss() throws Exception {
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        Date startTime = new Date(System.currentTimeMillis() + 3600000L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(3600000L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(slaRegBean.getId(), slaRegBean);
        slaCalcMemory.updateJobSla(jobId);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        slaRegBean = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{jobId});
        TestSLACalculatorMemory.assertNotNull((Object)slaRegBean.getCreatedTimestamp());
        TestSLACalculatorMemory.assertEquals((Object)slaRegBean.getCreatedTimestamp(), (Object)slaSummary.getCreatedTimestamp());
        TestSLACalculatorMemory.assertEquals((int)4, (int)slaSummary.getEventProcessed());
        slaCalcMemory.updateJobSla(jobId);
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)4, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        job1.setId(job1.getId());
        job1.setStatus(WorkflowJob.Status.SUCCEEDED);
        job1.setStartTime(new Date(System.currentTimeMillis()));
        job1.setEndTime(new Date(System.currentTimeMillis() + 3600000L));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 3600000L));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertTrue((boolean)slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.RUNNING.toString(), JobEvent.EventStatus.STARTED, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 3600000L)));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLACalculatorMemory.assertEquals((int)0, (int)slaCalcMemory.size());
        TestSLACalculatorMemory.assertEquals((int)3, (int)ehs.getEventQueue().size());
    }

    public void testSLAHistorySet() throws Exception {
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        Date startTime = new Date(System.currentTimeMillis() - 3600000L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(1000L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(slaRegBean.getId(), slaRegBean);
        slaCalcMemory.updateJobSla(jobId);
        job1.setId(job1.getId());
        job1.setStatus(WorkflowJob.Status.RUNNING);
        job1.setStartTime(new Date(System.currentTimeMillis() - 3600000L));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.RUNNING.toString(), JobEvent.EventStatus.STARTED, new Date(System.currentTimeMillis() - 3600000L), null);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)7, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)0, (int)slaCalcMemory.size());
        job1.setId(job1.getId());
        job1.setStatus(WorkflowJob.Status.SUCCEEDED);
        job1.setEndTime(new Date(System.currentTimeMillis() - 3600000L));
        job1.setStartTime(new Date(System.currentTimeMillis()));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, new Date(System.currentTimeMillis() - 3600000L), new Date(System.currentTimeMillis()));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertEquals((int)3, (int)ehs.getEventQueue().size());
    }

    private SLARegistrationBean _createSLARegistration(String jobId, AppType appType) {
        SLARegistrationBean bean = new SLARegistrationBean();
        bean.setId(jobId);
        bean.setAppType(appType);
        return bean;
    }

    public void testHistoryPurge() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        Date startTime = new Date(System.currentTimeMillis() - 3600000L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(1000L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(slaRegBean.getId(), slaRegBean);
        slaCalcMemory.updateJobSla(jobId);
        job1.setStatusStr("RUNNING");
        job1.setLastModifiedTime(new Date());
        job1.setStartTime(startTime);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.RUNNING.toString(), JobEvent.EventStatus.STARTED, new Date(System.currentTimeMillis() - 3600000L), null);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((int)7, (int)slaSummary.getEventProcessed());
        TestSLACalculatorMemory.assertTrue((boolean)slaCalcMemory.isJobIdInHistorySet(job1.getId()));
        job1.setStatusStr("SUCCEEDED");
        job1.setLastModifiedTime(new Date());
        job1.setStartTime(startTime);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job1);
        new SLACalculatorMemory.HistoryPurgeWorker(slaCalcMemory).run();
        TestSLACalculatorMemory.assertFalse((boolean)slaCalcMemory.isJobIdInHistorySet(job1.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testErrorLoggingWithJobIdPrefix() throws Exception {
        SLAService slaService = (SLAService)Services.get().get(SLAService.class);
        SLACalculator slaCalculator = slaService.getSLACalculator();
        slaCalculator.addRegistration("dummy-id", this._createSLARegistration("dummy-id", AppType.WORKFLOW_JOB));
        XTestCase.TestLogAppender appender = this.getTestLogAppender();
        Logger logger = Logger.getLogger(SLACalculatorMemory.class);
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.ERROR);
        try {
            slaService.runSLAWorker();
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
        List<LoggingEvent> log = appender.getLog();
        LoggingEvent firstLogEntry = log.get(0);
        TestSLACalculatorMemory.assertEquals((Object)Level.ERROR, (Object)firstLogEntry.getLevel());
        TestSLACalculatorMemory.assertTrue((boolean)firstLogEntry.getMessage().toString().contains("JOB[dummy-id]"));
        TestSLACalculatorMemory.assertEquals((String)"org.apache.oozie.sla.SLACalculatorMemory", (String)firstLogEntry.getLoggerName());
    }

    public void testDisablingAlertsEvents() throws Exception {
        SLAService slaService = (SLAService)Services.get().get(SLAService.class);
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        SLACalculator slaCalculator = slaService.getSLACalculator();
        String id1 = this._setupSlaMap(slaCalculator, "00020-1234567-wrkf-C", 1);
        String id2 = this._setupSlaMap(slaCalculator, "00020-1234567-wrkf-C", 2);
        SLACalcStatus slaCalcObj1 = slaCalculator.get(id1);
        TestSLACalculatorMemory.assertFalse((boolean)slaCalcObj1.getSLAConfigMap().containsKey("oozie.sla.disable.alerts"));
        SLACalcStatus slaCalcObj2 = slaCalculator.get(id2);
        TestSLACalculatorMemory.assertFalse((boolean)slaCalcObj2.getSLAConfigMap().containsKey("oozie.sla.disable.alerts"));
        slaCalculator.updateAllSlaStatus();
        TestSLACalculatorMemory.assertTrue((ehs.getEventQueue().size() > 0 ? 1 : 0) != 0);
        ehs.getEventQueue().clear();
        SLASummaryBean persistentSla = new SLASummaryBean(slaCalcObj1);
        persistentSla.setEventProcessed(0);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_EVENTPROCESSED, (Object)persistentSla);
        persistentSla = new SLASummaryBean(slaCalcObj2);
        persistentSla.setEventProcessed(0);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_EVENTPROCESSED, (Object)persistentSla);
        slaService.enableChildJobAlert(Arrays.asList(id1, id2));
        slaCalculator.updateAllSlaStatus();
        TestSLACalculatorMemory.assertTrue((boolean)ehs.getEventQueue().isEmpty());
        this._setupSlaMap(slaCalculator, "00020-1234567-wrkf-C", 3);
        this._setupSlaMap(slaCalculator, "00020-1234567-wrkf-C", 4);
        slaCalculator.enableChildJobAlert(Arrays.asList("00020-1234567-wrkf-C"));
        slaCalculator.updateAllSlaStatus();
        TestSLACalculatorMemory.assertFalse((boolean)ehs.getEventQueue().isEmpty());
        final String id5 = this._setupSlaMap(slaCalculator, "00020-1234567-wrkf-C", 5);
        Date now = new Date();
        now.setTime(now.getTime() - 600000L);
        final String newParams = "sla-nominal-time=" + DateUtils.formatDateOozieTZ((Date)now) + ";" + "sla-should-end" + "=5";
        slaCalculator.changeDefinition((List)new ArrayList<Pair<String, Map<String, String>>>(){
            {
                this.add(new Pair((Object)id5, (Object)JobUtils.parseChangeValue((String)newParams)));
            }
        });
        slaCalculator.updateAllSlaStatus();
        TestSLACalculatorMemory.assertTrue((ehs.getEventQueue().size() > 0 ? 1 : 0) != 0);
    }

    private String _setupSlaMap(SLACalculator slaCalculator, String id, int actionNum) throws Exception {
        CoordinatorActionBean action = this.addRecordToCoordActionTable(id, actionNum, CoordinatorAction.Status.TIMEDOUT, "coord-action-get.xml", 0);
        action.setExternalId(null);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_FOR_START, (Object)action);
        SLARegistrationBean slaRegBean = this._createSLARegistration(action.getId(), AppType.COORDINATOR_ACTION);
        Date startTime = new Date(System.currentTimeMillis() - 0x6DDD00L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(1000L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        slaRegBean.setParentId(id);
        slaCalculator.addRegistration(slaRegBean.getId(), slaRegBean);
        return action.getId();
    }

    @Test
    public void testEventOutOfOrder() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        SLARegistrationBean slaRegBean = this._createSLARegistration(wfJob.getId(), AppType.WORKFLOW_JOB);
        Date startTime = new Date(System.currentTimeMillis() + 3600000L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(3600000L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(slaRegBean.getId(), slaRegBean);
        slaCalcMemory.updateJobSla(jobId);
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        slaRegBean = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((String)slaSummary.getJobStatus(), (String)WorkflowInstance.Status.RUNNING.toString());
        wfJob.setStatus(WorkflowJob.Status.SUCCEEDED);
        wfJob.setEndTime(new Date(System.currentTimeMillis() + 3600000L));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END, (Object)wfJob);
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 3600000L));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((String)slaSummary.getJobStatus(), (String)WorkflowInstance.Status.SUCCEEDED.toString());
        slaCalcMemory.addJobStatus(jobId, WorkflowJob.Status.RUNNING.toString(), JobEvent.EventStatus.SUCCESS, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 3600000L));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{jobId});
        TestSLACalculatorMemory.assertEquals((String)slaSummary.getJobStatus(), (String)WorkflowInstance.Status.SUCCEEDED.toString());
    }

    public void testWFEndNotCoord() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        SLARegistrationBean slaRegBean = this._createSLARegistration("job-C@1", AppType.COORDINATOR_ACTION);
        String coordActionId = slaRegBean.getId();
        slaRegBean.setExpectedEnd(sdf.parse("2013-03-07"));
        slaRegBean.setExpectedStart(sdf.parse("2012-03-07"));
        slaCalcMemory.addRegistration(coordActionId, slaRegBean);
        SLACalcStatus calc1 = slaCalcMemory.get(coordActionId);
        calc1.setEventProcessed(1);
        calc1.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        calc1.setJobStatus(WorkflowAction.Status.RUNNING.name());
        calc1.setLastModifiedTime(new Date());
        SLASummaryBean slaSummaryBean = new SLASummaryBean(calc1);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)slaSummaryBean);
        CoordinatorActionBean coordAction = new CoordinatorActionBean();
        coordAction.setId(coordActionId);
        coordAction.setStatus(CoordinatorAction.Status.RUNNING);
        coordAction.setLastModifiedTime(sdf.parse("2013-02-07"));
        coordAction.setExternalId("wf_job-W");
        CoordActionInsertJPAExecutor caInsertCmd = new CoordActionInsertJPAExecutor(coordAction);
        this.jpaService.execute((JPAExecutor)caInsertCmd);
        WorkflowJobBean wjb = new WorkflowJobBean();
        wjb.setId("wf_job-W");
        wjb.setStartTime(sdf.parse("2012-02-07"));
        wjb.setLastModifiedTime(new Date());
        wjb.setStatus(WorkflowJob.Status.SUCCEEDED);
        WorkflowJobQueryExecutor.getInstance().insert((JsonBean)wjb);
        calc1 = slaCalcMemory.get(coordActionId);
        slaCalcMemory.updateJobSla(coordActionId);
        slaSummaryBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{coordActionId});
        TestSLACalculatorMemory.assertEquals((String)slaSummaryBean.getJobStatus(), (String)WorkflowInstance.Status.RUNNING.name());
        coordAction.setStatus(CoordinatorAction.Status.SUCCEEDED);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)coordAction);
        slaCalcMemory.addJobStatus(coordActionId, WorkflowJob.Status.SUCCEEDED.toString(), JobEvent.EventStatus.SUCCESS, sdf.parse("2012-02-07"), sdf.parse("2012-03-07"));
        slaSummaryBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{coordActionId});
        TestSLACalculatorMemory.assertEquals((String)slaSummaryBean.getJobStatus(), (String)WorkflowInstance.Status.SUCCEEDED.toString());
    }

    public void testSingleAddUpdateRemoveInstrumentedCorrectly() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean slaRegBean = this._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        Date startTime = new Date(System.currentTimeMillis() - 3600000L);
        slaRegBean.setExpectedStart(startTime);
        slaRegBean.setExpectedDuration(1000L);
        slaRegBean.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        String jobId = slaRegBean.getId();
        slaCalcMemory.addRegistration(slaRegBean.getId(), slaRegBean);
        long slaMapSize = (Long)((Instrumentation.Element)((Map)this.instrumentation.getCounters().get("sla-calculator")).get("sla-map")).getValue();
        TestSLACalculatorMemory.assertEquals((String)"SLA map size after add should be 1", (long)1L, (long)slaMapSize);
        slaCalcMemory.updateJobSla(jobId);
        slaMapSize = (Long)((Instrumentation.Element)((Map)this.instrumentation.getCounters().get("sla-calculator")).get("sla-map")).getValue();
        TestSLACalculatorMemory.assertEquals((String)"SLA map size after update should be 1", (long)1L, (long)slaMapSize);
        slaCalcMemory.removeRegistration(jobId);
        slaMapSize = (Long)((Instrumentation.Element)((Map)this.instrumentation.getCounters().get("sla-calculator")).get("sla-map")).getValue();
        TestSLACalculatorMemory.assertEquals((String)"SLA map size after remove should be 0", (long)0L, (long)slaMapSize);
    }

    public void testAddMultipleRestartRemoveMultipleInstrumentedCorrectly() throws Exception {
        SLACalculatorMemory slaCalcMemory = new SLACalculatorMemory();
        slaCalcMemory.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        SLARegistrationBean slaRegBean1 = this._createSLARegistration("job-1-W", AppType.WORKFLOW_JOB);
        String jobId1 = slaRegBean1.getId();
        SLARegistrationBean slaRegBean2 = this._createSLARegistration("job-2-W", AppType.WORKFLOW_JOB);
        String jobId2 = slaRegBean2.getId();
        SLARegistrationBean slaRegBean3 = this._createSLARegistration("job-3-W", AppType.WORKFLOW_JOB);
        String jobId3 = slaRegBean3.getId();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(slaRegBean1.getId());
        idList.add(slaRegBean2.getId());
        idList.add(slaRegBean3.getId());
        this.createWorkflow(idList);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-mm-dd");
        slaRegBean1.setAppName("app-name");
        slaRegBean1.setExpectedDuration(123L);
        slaRegBean1.setExpectedEnd(sdf.parse("2012-02-07"));
        slaRegBean1.setExpectedStart(sdf.parse("2011-02-07"));
        slaRegBean1.setNominalTime(sdf.parse("2012-01-06"));
        slaRegBean1.setUser("user");
        slaRegBean1.setParentId("parentId");
        slaRegBean1.setUpstreamApps("upstreamApps");
        slaRegBean1.setNotificationMsg("notificationMsg");
        slaRegBean1.setAlertContact("a@abc.com");
        slaRegBean1.setAlertEvents("MISS");
        slaRegBean1.setJobData("jobData");
        Date startTime = new Date(System.currentTimeMillis() - 3600000L);
        Date endTime = new Date(System.currentTimeMillis() + 0x6DDD00L);
        slaRegBean3.setExpectedStart(startTime);
        slaRegBean3.setExpectedEnd(endTime);
        slaCalcMemory.addRegistration(jobId1, slaRegBean1);
        slaCalcMemory.addRegistration(jobId2, slaRegBean2);
        slaCalcMemory.addRegistration(jobId3, slaRegBean3);
        long slaMapSize = (Long)((Instrumentation.Element)((Map)this.instrumentation.getCounters().get("sla-calculator")).get("sla-map")).getValue();
        TestSLACalculatorMemory.assertEquals((String)"SLA map size after add all should be 3", (long)3L, (long)slaMapSize);
        slaCalcMemory.updateAllSlaStatus();
        slaMapSize = (Long)((Instrumentation.Element)((Map)this.instrumentation.getCounters().get("sla-calculator")).get("sla-map")).getValue();
        TestSLACalculatorMemory.assertEquals((String)"SLA map size after update all should be 2. An instance of SLACalcStatus was removed", (long)2L, (long)slaMapSize);
        slaCalcMemory.removeRegistration(jobId1);
        slaCalcMemory.removeRegistration(jobId2);
        slaCalcMemory.removeRegistration(jobId3);
        slaMapSize = (Long)((Instrumentation.Element)((Map)this.instrumentation.getCounters().get("sla-calculator")).get("sla-map")).getValue();
        TestSLACalculatorMemory.assertEquals((String)"SLA map size after remove all should be 0", (long)0L, (long)slaMapSize);
    }
}

