/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.event.listener.JobEventListener;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.listener.SLAJobEventListener;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSLAJobEventListener
extends XTestCase {
    Services services;
    static StringBuilder output = new StringBuilder();

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = this.services.getConf();
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService,org.apache.oozie.sla.service.SLAService");
        conf.setClass("oozie.service.EventHandlerService.event.listeners", SLAJobEventListener.class, JobEventListener.class);
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testListenerConfigured() throws Exception {
        EventHandlerService ehs = (EventHandlerService)this.services.get(EventHandlerService.class);
        TestSLAJobEventListener.assertNotNull((Object)ehs);
        TestSLAJobEventListener.assertTrue((boolean)SLAService.isEnabled());
        TestSLAJobEventListener.assertTrue((boolean)ehs.listEventListeners().contains(SLAJobEventListener.class.getCanonicalName()));
    }

    @Test
    public void testOnJobEvent() throws Exception {
        SLAService slas = (SLAService)this.services.get(SLAService.class);
        SLAJobEventListener listener = new SLAJobEventListener();
        listener.init(this.services.getConf());
        SLARegistrationBean job = this._createSLARegBean("wf1-W", AppType.WORKFLOW_JOB);
        job.setExpectedStart(DateUtils.parseDateUTC((String)"2012-07-22T00:00Z"));
        job.setExpectedEnd(DateUtils.parseDateUTC((String)"2012-07-23T00:00Z"));
        slas.addRegistrationEvent(job);
        TestSLAJobEventListener.assertEquals((int)1, (int)slas.getSLACalculator().size());
        Date actualStart = DateUtils.parseDateUTC((String)"2012-07-22T01:00Z");
        this.createWorkflow("wf1-W", actualStart);
        WorkflowJobEvent wfe = new WorkflowJobEvent("wf1-W", "caId1", WorkflowJob.Status.RUNNING, "user1", "wf-app-name1", actualStart, null);
        listener.onWorkflowJobEvent(wfe);
        SLACalcStatus serviceObj = slas.getSLACalculator().get("wf1-W");
        TestSLAJobEventListener.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)serviceObj.getEventStatus());
        TestSLAJobEventListener.assertEquals((int)7, (int)serviceObj.getEventProcessed());
        TestSLAJobEventListener.assertEquals((int)0, (int)slas.getSLACalculator().size());
        this.createWorkflowAction("wfId1-W@wa1", "wf1-W");
        job = this._createSLARegBean("wfId1-W@wa1", AppType.WORKFLOW_ACTION);
        job.setExpectedEnd(DateUtils.parseDateUTC((String)"2012-07-22T01:00Z"));
        slas.addRegistrationEvent(job);
        TestSLAJobEventListener.assertEquals((int)1, (int)slas.getSLACalculator().size());
        job.setExpectedStart(DateUtils.parseDateUTC((String)"2012-07-22T00:00Z"));
        WorkflowActionEvent wae = new WorkflowActionEvent("wfId1-W@wa1", "wf1-W", WorkflowAction.Status.RUNNING, "user1", "wf-app-name1", actualStart, null);
        listener.onWorkflowActionEvent(wae);
        serviceObj = slas.getSLACalculator().get("wfId1-W@wa1");
        TestSLAJobEventListener.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)serviceObj.getEventStatus());
        this.createCoord("cj1-C");
        CoordinatorActionBean coordAction = this.createCoordAction("cj1-C@ca1", "cj1-C");
        job = this._createSLARegBean("cj1-C@ca1", AppType.COORDINATOR_ACTION);
        job.setExpectedEnd(DateUtils.parseDateUTC((String)"2012-07-22T01:00Z"));
        Date actualEnd = DateUtils.parseDateUTC((String)"2012-07-22T02:00Z");
        slas.addRegistrationEvent(job);
        TestSLAJobEventListener.assertEquals((int)1, (int)slas.getSLACalculator().size());
        CoordinatorActionEvent cae = new CoordinatorActionEvent("cj1-C@ca1", "cj1-C", CoordinatorAction.Status.RUNNING, "user1", "coord-app-name1", null, actualEnd, null);
        listener.onCoordinatorActionEvent(cae);
        coordAction.setStatus(CoordinatorAction.Status.KILLED);
        coordAction.setLastModifiedTime(new Date());
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)coordAction);
        cae = new CoordinatorActionEvent("cj1-C@ca1", "cj1-C", CoordinatorAction.Status.KILLED, "user1", "coord-app-name1", null, actualEnd, null);
        listener.onCoordinatorActionEvent(cae);
        SLASummaryBean summary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{"cj1-C@ca1"});
        TestSLAJobEventListener.assertEquals((int)8, (int)summary.getEventProcessed());
        TestSLAJobEventListener.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)summary.getEventStatus());
        TestSLAJobEventListener.assertEquals((int)0, (int)slas.getSLACalculator().size());
        job = this._createSLARegBean("wf2-W", AppType.WORKFLOW_JOB);
        job.setExpectedStart(new Date(System.currentTimeMillis() - 0x6DDD00L));
        job.setExpectedEnd(new Date(System.currentTimeMillis() + 3600000L));
        slas.addRegistrationEvent(job);
        TestSLAJobEventListener.assertEquals((int)1, (int)slas.getSLACalculator().size());
        this.createWorkflow("wf2-W", new Date());
        wfe = new WorkflowJobEvent("wf2-W", "caId2", WorkflowJob.Status.RUNNING, "user1", "wf-app-name1", null, null);
        listener.onWorkflowJobEvent(wfe);
        serviceObj = slas.getSLACalculator().get("wf2-W");
        TestSLAJobEventListener.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)serviceObj.getEventStatus());
        TestSLAJobEventListener.assertEquals((int)3, (int)serviceObj.getEventProcessed());
        TestSLAJobEventListener.assertEquals((int)1, (int)slas.getSLACalculator().size());
    }

    private SLARegistrationBean _createSLARegBean(String jobId, AppType appType) {
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setId(jobId);
        reg.setAppType(appType);
        return reg;
    }

    private WorkflowJobBean createWorkflow(String id, Date actualStart) throws Exception {
        ArrayList<WorkflowJobBean> insertList = new ArrayList<WorkflowJobBean>();
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(id);
        workflow.setStatusStr("PREP");
        workflow.setStartTime(actualStart);
        workflow.setSlaXml("<sla></sla>");
        insertList.add(workflow);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        return workflow;
    }

    private WorkflowActionBean createWorkflowAction(String id, String parentId) throws Exception {
        ArrayList<WorkflowActionBean> insertList = new ArrayList<WorkflowActionBean>();
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId(id);
        action.setJobId(parentId);
        insertList.add(action);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        return action;
    }

    private CoordinatorActionBean createCoordAction(String id, String parentId) throws Exception {
        ArrayList<CoordinatorActionBean> insertList = new ArrayList<CoordinatorActionBean>();
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setId(id);
        action.setJobId(parentId);
        insertList.add(action);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        return action;
    }

    private CoordinatorJobBean createCoord(String id) throws Exception {
        ArrayList<CoordinatorJobBean> insertList = new ArrayList<CoordinatorJobBean>();
        CoordinatorJobBean job = new CoordinatorJobBean();
        job.setId(id);
        insertList.add(job);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        return job;
    }
}

