/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.AppType;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.test.XDataTestCase;

public class TestSLARegistrationGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSLARegistrationGet() throws Exception {
        Date current = new Date();
        String jobId = "0000000-" + current.getTime() + "-TestSLARegGetJPAExecutor-W";
        this._addRecordToSLARegistrationTable(jobId, AppType.WORKFLOW_JOB, current, new Date(), "END_MISS", "alert@example.com");
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLARegistrationGetJPAExecutor.assertNotNull((Object)jpaService);
        SLARegistrationBean bean = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{jobId});
        TestSLARegistrationGetJPAExecutor.assertEquals((String)jobId, (String)bean.getId());
        TestSLARegistrationGetJPAExecutor.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)bean.getAppType());
        TestSLARegistrationGetJPAExecutor.assertEquals((Object)current, (Object)bean.getExpectedStart());
        TestSLARegistrationGetJPAExecutor.assertEquals((int)2, (int)bean.getSLAConfigMap().size());
        TestSLARegistrationGetJPAExecutor.assertEquals((String)"END_MISS", (String)bean.getAlertEvents());
        TestSLARegistrationGetJPAExecutor.assertEquals((String)"alert@example.com", (String)bean.getAlertContact());
    }

    public void testSLARegistrationBulkConfigMap() throws Exception {
        Date current = new Date();
        String jobId = "0000000-" + current.getTime() + "-TestSLARegGetJPAExecutor-C@1";
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(jobId);
        this._addRecordToSLARegistrationTable(jobId, AppType.COORDINATOR_ACTION, current, new Date(), "END_MISS", "alert@example.com");
        jobId = "0000000-" + current.getTime() + "-TestSLARegGetJPAExecutor-C@2";
        jobIds.add(jobId);
        this._addRecordToSLARegistrationTable(jobId, AppType.COORDINATOR_ACTION, current, new Date(), "END_MISS", "alert@example.com");
        List bean = SLARegistrationQueryExecutor.getInstance().getList((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_CONFIGS, new Object[]{jobIds});
        TestSLARegistrationGetJPAExecutor.assertEquals((int)bean.size(), (int)2);
    }

    private void _addRecordToSLARegistrationTable(String jobId, AppType appType, Date start, Date end, String alertEvent, String alertContact) throws Exception {
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setId(jobId);
        reg.setAppType(appType);
        reg.setExpectedStart(start);
        reg.setExpectedEnd(end);
        reg.setAlertEvents(alertEvent);
        reg.setAlertContact(alertContact);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestSLARegistrationGetJPAExecutor.assertNotNull((Object)jpaService);
            ArrayList<SLARegistrationBean> insert = new ArrayList<SLARegistrationBean>();
            insert.add(reg);
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insert, null, null);
        }
        catch (JPAExecutorException je) {
            TestSLARegistrationGetJPAExecutor.fail((String)"Unable to insert the test sla registration record to table");
            throw je;
        }
    }

    public void testSlaConfigStringToMap() {
        String slaConfig = "{alert_contact=hadoopqa@oozie.com},{alert_events=START_MISS,DURATION_MISS,END_MISS},";
        SLARegistrationBean bean = new SLARegistrationBean();
        bean.setSlaConfig(slaConfig);
        TestSLARegistrationGetJPAExecutor.assertEquals((int)bean.getSLAConfigMap().size(), (int)2);
        TestSLARegistrationGetJPAExecutor.assertEquals((String)bean.getAlertEvents(), (String)"START_MISS,DURATION_MISS,END_MISS");
        TestSLARegistrationGetJPAExecutor.assertEquals((String)bean.getAlertContact(), (String)"hadoopqa@oozie.com");
    }
}

