/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.listener.SLAEventListener;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowInstance;
import org.jdom.Element;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSLAService
extends XDataTestCase {
    static StringBuilder output = new StringBuilder();

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService,org.apache.oozie.sla.service.SLAService");
        conf.setClass("oozie.service.EventHandlerService.event.listeners", DummySLAEventListener.class, SLAEventListener.class);
        conf.setLong("oozie.sla.service.SLAService.job.event.latency", 0L);
        conf.setInt("oozie.service.EventHandlerService.worker.threads", 0);
        services.init();
        output.setLength(0);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testBasicService() throws Exception {
        Services services = Services.get();
        SLAService slas = (SLAService)services.get(SLAService.class);
        TestSLAService.assertNotNull((Object)slas);
        TestSLAService.assertTrue((boolean)SLAService.isEnabled());
        services.destroy();
        services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services.ext", "");
        services.init();
        TestSLAService.assertFalse((boolean)SLAService.isEnabled());
    }

    @Test
    public void testUpdateSLA() throws Exception {
        SLAService slas = (SLAService)Services.get().get(SLAService.class);
        TestSLAService.assertNotNull((Object)slas);
        TestSLAService.assertTrue((boolean)SLAService.isEnabled());
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        SLARegistrationBean sla1 = TestSLAService._createSLARegistration(wfJob.getId(), AppType.WORKFLOW_JOB);
        sla1.setExpectedStart(new Date(System.currentTimeMillis() - 3600000L));
        sla1.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        sla1.setExpectedDuration(600000L);
        slas.addRegistrationEvent(sla1);
        TestSLAService.assertEquals((int)1, (int)slas.getSLACalculator().size());
        slas.runSLAWorker();
        new EventHandlerService.EventWorker(ehs).run();
        TestSLAService.assertEventNoDuplicates(output.toString(), "Sla START - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), "Sla END - MISS!!!");
        output.setLength(0);
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        sla1 = TestSLAService._createSLARegistration(wfJob2.getId(), AppType.WORKFLOW_JOB);
        sla1.setExpectedStart(new Date(System.currentTimeMillis() + 3600000L));
        sla1.setExpectedEnd(new Date(System.currentTimeMillis() + 0x6DDD00L));
        slas.addRegistrationEvent(sla1);
        wfJob2.setStatusStr("RUNNING");
        wfJob2.setLastModifiedTime(new Date());
        wfJob2.setStartTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wfJob2);
        slas.addStatusEvent(sla1.getId(), WorkflowJob.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), new Date());
        CoordinatorActionBean action = this.addRecordToCoordActionTable("coord_id-C", 1, CoordinatorAction.Status.TIMEDOUT, "coord-action-get.xml", 0);
        SLARegistrationBean sla2 = TestSLAService._createSLARegistration(action.getId(), AppType.COORDINATOR_ACTION);
        sla2.setExpectedStart(new Date(System.currentTimeMillis() + 3600000L));
        sla2.setExpectedEnd(new Date(System.currentTimeMillis() - 0x6DDD00L));
        sla2.setExpectedDuration(10L);
        slas.addRegistrationEvent(sla2);
        TestSLAService.assertEquals((int)3, (int)slas.getSLACalculator().size());
        Date startTime = new Date();
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        wfJob3.setStatusStr("SUCCEEDED");
        wfJob3.setLastModifiedTime(new Date());
        wfJob3.setStartTime(startTime);
        wfJob3.setEndTime(startTime);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wfJob3);
        action.setCreatedTime(startTime);
        action.setStatus(CoordinatorAction.Status.SUCCEEDED);
        action.setLastModifiedTime(new Date());
        action.setExternalId(wfJob3.getId());
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_RERUN, (Object)action);
        slas.addStatusEvent(sla1.getId(), CoordinatorAction.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), new Date());
        slas.addStatusEvent(sla2.getId(), CoordinatorAction.Status.SUCCEEDED.name(), JobEvent.EventStatus.SUCCESS, startTime, new Date());
        slas.runSLAWorker();
        new EventHandlerService.EventWorker(ehs).run();
        TestSLAService.assertTrue((boolean)output.toString().contains(sla1.getId() + " Sla START - MET!!!"));
        TestSLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla END - MISS!!!"));
        TestSLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla DURATION - MET!!!"));
        output.setLength(0);
        WorkflowJobBean job4 = this.addRecordToWfJobTable(WorkflowJob.Status.KILLED, WorkflowInstance.Status.KILLED);
        job4.setLastModifiedTime(new Date());
        job4.setEndTime(new Date());
        job4.setStartTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job4);
        sla2 = TestSLAService._createSLARegistration(job4.getId(), AppType.WORKFLOW_JOB);
        sla2.setExpectedStart(new Date(System.currentTimeMillis() - 0x6DDD00L));
        sla2.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
        slas.addRegistrationEvent(sla2);
        TestSLAService.assertEquals((int)3, (int)slas.getSLACalculator().size());
        slas.runSLAWorker();
        new EventHandlerService.EventWorker(ehs).run();
        TestSLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla START - MISS!!!"));
        TestSLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla END - MISS!!!"));
        output.setLength(0);
        TestSLAService.assertEquals((int)2, (int)slas.getSLACalculator().size());
        sla1 = this._createCoordActionSLARegistration(CoordinatorAction.Status.SUCCEEDED.name());
        sla1.setExpectedStart(new Date(System.currentTimeMillis() + 3600000L));
        sla1.setExpectedEnd(new Date(System.currentTimeMillis() + 0x6DDD00L));
        slas.addRegistrationEvent(sla1);
        TestSLAService.assertEquals((int)3, (int)slas.getSLACalculator().size());
        slas.addStatusEvent(sla1.getId(), CoordinatorAction.Status.SUCCEEDED.name(), JobEvent.EventStatus.SUCCESS, new Date(), new Date());
        slas.runSLAWorker();
        TestSLAService.assertEquals((int)2, (int)ehs.getEventQueue().size());
        new EventHandlerService.EventWorker(ehs).run();
        TestSLAService.assertTrue((boolean)output.toString().contains(sla1.getId() + " Sla START - MET!!!"));
        TestSLAService.assertTrue((boolean)output.toString().contains(sla1.getId() + " Sla END - MET!!!"));
    }

    @Test
    public void testEndMissDBConfirm() throws Exception {
        SLAService slas = (SLAService)Services.get().get(SLAService.class);
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date date = new Date();
        WorkflowJobBean job1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        SLARegistrationBean sla = TestSLAService._createSLARegistration(job1.getId(), AppType.WORKFLOW_JOB);
        sla.setExpectedEnd(new Date(date.getTime() - 1800000L));
        slas.addRegistrationEvent(sla);
        WorkflowJobBean job2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        job2.setEndTime(new Date(date.getTime() - 1800000L));
        job2.setStartTime(new Date(date.getTime() - 2000000L));
        job2.setLastModifiedTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)job2);
        sla = TestSLAService._createSLARegistration(job2.getId(), AppType.WORKFLOW_JOB);
        sla.setExpectedEnd(new Date(date.getTime() - 1500000L));
        sla.setExpectedDuration(100L);
        slas.addRegistrationEvent(sla);
        slas.runSLAWorker();
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable("coord-action-C@1", 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        action1.setExternalId(null);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_RERUN, (Object)action1);
        sla = TestSLAService._createSLARegistration(action1.getId(), AppType.COORDINATOR_ACTION);
        sla.setExpectedEnd(new Date(System.currentTimeMillis() - 2000000L));
        slas.addRegistrationEvent(sla);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable("coord-action-C@2", 1, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        WorkflowJobBean extWf = new WorkflowJobBean();
        extWf.setId(action2.getExternalId());
        extWf.setEndTime(new Date(System.currentTimeMillis() - 1800000L));
        extWf.setStartTime(new Date(System.currentTimeMillis() - 2000000L));
        jpaService.execute((JPAExecutor)new WorkflowJobInsertJPAExecutor(extWf));
        sla = TestSLAService._createSLARegistration(action2.getId(), AppType.COORDINATOR_ACTION);
        sla.setExpectedEnd(new Date(System.currentTimeMillis() - 1500000L));
        slas.addRegistrationEvent(sla);
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable("coord-action-C@3", 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        extWf = new WorkflowJobBean();
        extWf.setId(action3.getExternalId());
        extWf.setStartTime(new Date(System.currentTimeMillis() - 0x200B20L));
        extWf.setEndTime(new Date(System.currentTimeMillis() - 1800000L));
        jpaService.execute((JPAExecutor)new WorkflowJobInsertJPAExecutor(extWf));
        sla = TestSLAService._createSLARegistration(action3.getId(), AppType.COORDINATOR_ACTION);
        sla.setExpectedStart(new Date(System.currentTimeMillis() - 3600000L));
        sla.setExpectedEnd(new Date(System.currentTimeMillis() - 1500000L));
        sla.setExpectedDuration(0L);
        slas.addRegistrationEvent(sla);
        slas.runSLAWorker();
        new EventHandlerService.EventWorker(ehs).run();
        int count = 0;
        int ptr = output.indexOf("END - MISS");
        while (ptr < output.length() && ptr > 0) {
            ++count;
            ptr = output.indexOf("END - MISS", ptr + 1);
        }
        TestSLAService.assertEquals((int)3, (int)count);
        TestSLAService.assertEventNoDuplicates(output.toString(), job1.getId() + " Sla END - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), action1.getId() + " Sla END - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), action2.getId() + " Sla END - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), job2.getId() + " Sla END - MET!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), job2.getId() + " Sla DURATION - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), action3.getId() + " Sla START - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), action3.getId() + " Sla DURATION - MISS!!!");
        TestSLAService.assertEventNoDuplicates(output.toString(), action3.getId() + " Sla END - MET!!!");
        SLASummaryBean slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{job2.getId()});
        TestSLAService.assertEquals((Object)job2.getStartTime(), (Object)slaSummary.getActualStart());
        TestSLAService.assertEquals((Object)job2.getEndTime(), (Object)slaSummary.getActualEnd());
        TestSLAService.assertEquals((long)(job2.getEndTime().getTime() - job2.getStartTime().getTime()), (long)slaSummary.getActualDuration());
        TestSLAService.assertEquals((String)job2.getStatusStr(), (String)slaSummary.getJobStatus());
        TestSLAService.assertEquals((Object)SLAEvent.EventStatus.END_MET, (Object)slaSummary.getEventStatus());
        TestSLAService.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)slaSummary.getSLAStatus());
        TestSLAService.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLAService.assertNull((Object)slas.getSLACalculator().get(job2.getId()));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{action2.getId()});
        extWf = (WorkflowJobBean)jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(action2.getExternalId()));
        TestSLAService.assertEquals((Object)extWf.getStartTime(), (Object)slaSummary.getActualStart());
        TestSLAService.assertEquals((Object)extWf.getEndTime(), (Object)slaSummary.getActualEnd());
        TestSLAService.assertEquals((long)(extWf.getEndTime().getTime() - extWf.getStartTime().getTime()), (long)slaSummary.getActualDuration());
        TestSLAService.assertEquals((String)action2.getStatusStr(), (String)slaSummary.getJobStatus());
        TestSLAService.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaSummary.getEventStatus());
        TestSLAService.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLAService.assertEquals((int)8, (int)slaSummary.getEventProcessed());
        TestSLAService.assertNull((Object)slas.getSLACalculator().get(action2.getId()));
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{action1.getId()});
        TestSLAService.assertNull((Object)slaSummary.getActualStart());
        TestSLAService.assertNull((Object)slaSummary.getActualEnd());
        TestSLAService.assertEquals((String)action1.getStatusStr(), (String)slaSummary.getJobStatus());
        TestSLAService.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaSummary.getEventStatus());
        TestSLAService.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLAService.assertEquals((int)7, (int)slaSummary.getEventProcessed());
        TestSLAService.assertNotNull((Object)slas.getSLACalculator().get(action1.getId()));
        action1.setStatus(CoordinatorAction.Status.TIMEDOUT);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_RERUN, (Object)action1);
        slas.getSLACalculator().addJobStatus(action1.getId(), null, null, null, null);
        slaSummary = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{action1.getId()});
        TestSLAService.assertNull((Object)slaSummary.getActualStart());
        TestSLAService.assertNotNull((Object)slaSummary.getActualEnd());
        TestSLAService.assertEquals((String)"TIMEDOUT", (String)slaSummary.getJobStatus());
        TestSLAService.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaSummary.getEventStatus());
        TestSLAService.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)slaSummary.getSLAStatus());
        TestSLAService.assertEquals((int)8, (int)slaSummary.getEventProcessed());
    }

    public void testSLAOperations() throws Exception {
        String slaXml = " <sla:info xmlns:sla='uri:oozie:sla:0.2'> <sla:nominal-time>2009-03-06T10:00Z</sla:nominal-time> <sla:should-start>5</sla:should-start> <sla:should-end>120</sla:should-end> <sla:max-duration>100</sla:max-duration> <sla:alert-events>\"invalid_event_miss'</sla:alert-events> <sla:alert-contact>abc@example.com</sla:alert-contact></sla:info>";
        Element eSla = XmlUtils.parseXml((String)slaXml);
        SLAOperations.createSlaRegistrationEvent((Element)eSla, (String)"job-id1", (String)"parent-id1", (AppType)AppType.WORKFLOW_JOB, (String)TestSLAService.getTestUser(), (String)"test-appname", (XLog)this.log, (boolean)false);
        SLARegistrationBean reg = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{"job-id1"});
        TestSLAService.assertEquals((String)"END_MISS", (String)reg.getAlertEvents());
    }

    public static SLARegistrationBean _createSLARegistration(String jobId, AppType appType) {
        SLARegistrationBean bean = new SLARegistrationBean();
        bean.setId(jobId);
        bean.setAppType(appType);
        return bean;
    }

    public SLARegistrationBean _createCoordActionSLARegistration(String status) throws Exception {
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        wfJob.setLastModifiedTime(new Date());
        wfJob.setStartTime(new Date());
        wfJob.setEndTime(new Date());
        wfJob.setStatusStr(status);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wfJob);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(new Date().getTime() + "-C", 1, CoordinatorAction.Status.TIMEDOUT, "coord-action-get.xml", 0);
        action.setExternalId(wfJob.getId());
        action.setStatusStr(status);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_RERUN, (Object)action);
        SLARegistrationBean bean = new SLARegistrationBean();
        bean.setId(action.getId());
        bean.setAppType(AppType.COORDINATOR_ACTION);
        return bean;
    }

    public static void assertEventNoDuplicates(String outputStr, String eventMsg) {
        int index = outputStr.indexOf(eventMsg);
        TestSLAService.assertTrue((index != -1 ? 1 : 0) != 0);
        TestSLAService.assertTrue((outputStr.indexOf(eventMsg, index + 1) == -1 ? 1 : 0) != 0);
    }

    public static class DummySLAEventListener
    extends SLAEventListener {
        public void onStartMet(SLAEvent sla) {
            output.append(sla.getId() + " Sla START - MET!!!");
        }

        public void onStartMiss(SLAEvent sla) {
            output.append(sla.getId() + " Sla START - MISS!!!");
        }

        public void onEndMet(SLAEvent sla) {
            output.append(sla.getId() + " Sla END - MET!!!");
        }

        public void onEndMiss(SLAEvent sla) {
            output.append(sla.getId() + " Sla END - MISS!!!");
        }

        public void onDurationMet(SLAEvent sla) {
            output.append(sla.getId() + " Sla DURATION - MET!!!");
        }

        public void onDurationMiss(SLAEvent sla) {
            output.append(sla.getId() + " Sla DURATION - MISS!!!");
        }

        public void init(Configuration conf) {
        }

        public void destroy() {
        }
    }
}

