/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetRecordsOnRestartJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.test.XDataTestCase;

public class TestSLASummaryGetOnRestartJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSLARegistrationGet() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SLASummaryBean sla1 = new SLASummaryBean();
        sla1.setId("jobId");
        sla1.setAppName("appName");
        sla1.setUser("user");
        sla1.setParentId("parent");
        sla1.setEventProcessed(7);
        sla1.setLastModifiedTime(new Date(System.currentTimeMillis() - 432000000L));
        SLASummaryBean sla2 = new SLASummaryBean();
        sla2.setId("jobId2");
        sla2.setEventProcessed(6);
        sla2.setLastModifiedTime(sdf.parse("2009-06-03"));
        ArrayList<SLASummaryBean> insert = new ArrayList<SLASummaryBean>();
        insert.add(sla1);
        insert.add(sla2);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insert, null, null);
        SLASummaryGetRecordsOnRestartJPAExecutor slaGetOnRestart = new SLASummaryGetRecordsOnRestartJPAExecutor(7);
        List beans = (List)jpaService.execute((JPAExecutor)slaGetOnRestart);
        TestSLASummaryGetOnRestartJPAExecutor.assertEquals((int)1, (int)beans.size());
        TestSLASummaryGetOnRestartJPAExecutor.assertEquals((String)"jobId", (String)((SLASummaryBean)beans.get(0)).getId());
        TestSLASummaryGetOnRestartJPAExecutor.assertEquals((String)"appName", (String)((SLASummaryBean)beans.get(0)).getAppName());
        TestSLASummaryGetOnRestartJPAExecutor.assertEquals((String)"user", (String)((SLASummaryBean)beans.get(0)).getUser());
        TestSLASummaryGetOnRestartJPAExecutor.assertEquals((String)"parent", (String)((SLASummaryBean)beans.get(0)).getParentId());
        TestSLASummaryGetOnRestartJPAExecutor.assertEquals((int)7, (int)((SLASummaryBean)beans.get(0)).getEventProcessed());
    }
}

