/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestDBWorkflowStore
extends XTestCase {
    WorkflowLib wfLib;
    WorkflowStore store;
    WorkflowJobBean wfBean1;
    WorkflowJobBean wfBean2;
    String dbName;
    Services services;
    private String actionId;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
    }

    @Override
    protected void tearDown() throws Exception {
        this.store.closeTrx();
        this.services.destroy();
        super.tearDown();
    }

    public void testDBWorkflowStore() throws Exception {
        this._testInsertWF();
        this._testGetWF();
        this._testUpdateWF();
        this._testGetStatusCount();
        this._testGetWFIDWithExtID();
        this._testSaveAction();
        this._testLoadAction();
        this._testUpdateAction();
        this._testGetActionsForWF();
        System.out.println("after _testGetActions()");
        this._testGetActionForWFFailure();
        System.out.println("after _testGetActionForWFFailure()");
        this._testGetPendingActions();
        System.out.println("after _testPendingAction()");
        this._testGetWFInfo();
        System.out.println("after _testWFInfo()");
        System.out.println("after _testGetWFInfos()");
        this._testDeleteAction();
        this._testPurge();
    }

    private WorkflowJobBean createWorkflow(WorkflowApp app, Configuration conf, String authToken) throws Exception {
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        XConfiguration protoActionConf = wps.createProtoActionConf(conf, true);
        WorkflowLib workflowLib = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).getWorkflowLibWithNoDB();
        WorkflowInstance wfInstance = workflowLib.createInstance(app, conf);
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(wfInstance.getId());
        workflow.setAppName(app.getName());
        workflow.setAppPath(conf.get("oozie.wf.application.path"));
        workflow.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        workflow.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoActionConf).toString());
        workflow.setCreatedTime(new Date());
        workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
        workflow.setStatus(WorkflowJob.Status.PREP);
        workflow.setRun(0);
        workflow.setUser(conf.get("user.name"));
        workflow.setGroup(conf.get("group.name"));
        workflow.setWorkflowInstance(wfInstance);
        return workflow;
    }

    private void _testInsertWF() throws Exception {
        this.store.beginTrx();
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf1 = new Configuration();
        conf1.set("oozie.wf.application.path", "testPath");
        conf1.set("oozie.wf.log.token", "testToken");
        conf1.set("user.name", TestDBWorkflowStore.getTestUser());
        this.wfBean1 = this.createWorkflow((WorkflowApp)app, conf1, "auth");
        Configuration conf2 = new Configuration();
        conf2.set("oozie.wf.application.path", "testPath");
        conf2.set("oozie.wf.log.token", "testToken");
        conf2.set("user.name", TestDBWorkflowStore.getTestUser2());
        this.wfBean2 = this.createWorkflow((WorkflowApp)app, conf2, "auth");
        this.store.insertWorkflow(this.wfBean1);
        this.store.insertWorkflow(this.wfBean2);
        this.store.commitTrx();
    }

    private void _testGetWF() throws StoreException {
        this.store.beginTrx();
        WorkflowJobBean wfBean = this.store.getWorkflow(this.wfBean1.getId(), false);
        TestDBWorkflowStore.assertEquals((String)wfBean.getId(), (String)this.wfBean1.getId());
        TestDBWorkflowStore.assertEquals((Object)wfBean.getStatus(), (Object)WorkflowJob.Status.PREP);
        TestDBWorkflowStore.assertEquals((String)wfBean.getWorkflowInstance().getId(), (String)this.wfBean1.getId());
    }

    private void _testUpdateWF() throws StoreException {
        this.wfBean1.setStatus(WorkflowJob.Status.SUCCEEDED);
        WorkflowInstance wfInstance = this.wfBean1.getWorkflowInstance();
        wfInstance.setVar("test", "hello");
        this.wfBean1.setWorkflowInstance(wfInstance);
        this.wfBean1.setExternalId("testExtId");
        this.store.getWorkflow(this.wfBean1.getId(), false);
        this.store.updateWorkflow(this.wfBean1);
        WorkflowJobBean wfBean = this.store.getWorkflow(this.wfBean1.getId(), false);
        TestDBWorkflowStore.assertEquals((String)"hello", (String)wfBean.getWorkflowInstance().getVar("test"));
        TestDBWorkflowStore.assertEquals((Object)wfBean.getStatus(), (Object)WorkflowJob.Status.SUCCEEDED);
        this.store.commitTrx();
    }

    private void _testGetStatusCount() throws StoreException, InterruptedException {
        this.store.beginTrx();
        this.sleep(1000);
        long t1 = System.currentTimeMillis();
        WorkflowJobBean wfBean = this.store.getWorkflow(this.wfBean2.getId(), false);
        this.store.updateWorkflow(wfBean);
        long t2 = System.currentTimeMillis();
        int s = (int)((t2 - t1) / 1000L);
        if (s < 1) {
            s = 1;
        }
        this.store.commitTrx();
    }

    private void _testGetWFIDWithExtID() throws StoreException {
        this.store.beginTrx();
        String id = this.store.getWorkflowIdForExternalId("testExtId");
        System.out.println("id is " + id);
        TestDBWorkflowStore.assertEquals((String)this.wfBean1.getId(), (String)id);
        this.store.commitTrx();
    }

    private void _testSaveAction() throws StoreException, SQLException {
        WorkflowActionBean a11 = new WorkflowActionBean();
        this.store.beginTrx();
        StringBuilder str = new StringBuilder();
        str.append(System.currentTimeMillis());
        str.append("11");
        this.actionId = str.toString();
        a11.setId(this.actionId);
        a11.setJobId(this.wfBean1.getId());
        a11.setName("a11");
        a11.setStatus(WorkflowAction.Status.PREP);
        this.store.insertAction(a11);
        this.store.commitTrx();
    }

    private void _testLoadAction() throws StoreException {
        this.store.beginTrx();
        WorkflowActionBean a11 = this.store.getAction(this.actionId, false);
        TestDBWorkflowStore.assertEquals((String)a11.getId(), (String)this.actionId);
        TestDBWorkflowStore.assertEquals((String)a11.getJobId(), (String)this.wfBean1.getId());
        TestDBWorkflowStore.assertEquals((Object)a11.getStatus(), (Object)WorkflowAction.Status.PREP);
        this.store.commitTrx();
    }

    private void _testUpdateAction() throws StoreException {
        WorkflowActionBean a11 = this.store.getAction(this.actionId, false);
        a11.setStatus(WorkflowAction.Status.OK);
        a11.setPending();
        a11.setPendingAge(new Date(System.currentTimeMillis() - 10000L));
        this.store.beginTrx();
        this.store.updateAction(a11);
        this.store.getEntityManager().flush();
        this.store.getEntityManager().merge((Object)a11);
        this.store.commitTrx();
        WorkflowActionBean a = this.store.getAction(a11.getId(), false);
        TestDBWorkflowStore.assertEquals((String)a.getId(), (String)a11.getId());
        TestDBWorkflowStore.assertEquals((Object)a.getStatus(), (Object)WorkflowAction.Status.OK);
    }

    private void _testDeleteAction() throws StoreException {
        this.store.beginTrx();
        this.store.deleteAction(this.actionId);
        this.store.commitTrx();
        boolean actionDeleted = false;
        try {
            this.store.getAction(this.actionId, false);
            TestDBWorkflowStore.fail((String)"Should have seen StoreException.");
        }
        catch (StoreException storeException) {
            // empty catch block
        }
    }

    private void _testGetActionForWFFailure() {
        try {
            this.store.getAction("non-existing-jobid", false);
            TestDBWorkflowStore.fail((String)"Should have seen StoreException.");
        }
        catch (StoreException storeException) {
            // empty catch block
        }
    }

    private void _testGetActionsForWF() throws StoreException {
        this.store.beginTrx();
        List actions1 = this.store.getActionsForWorkflow(this.wfBean1.getId(), false);
        List actions2 = this.store.getActionsForWorkflow(this.wfBean2.getId(), false);
        this.store.commitTrx();
    }

    private void _testGetPendingActions() throws StoreException {
        this.store.beginTrx();
        List pActions = this.store.getPendingActions(5L);
        this.store.commitTrx();
    }

    private void _testGetWFInfo() throws StoreException {
        this.store.beginTrx();
        WorkflowJobBean wfBean = this.store.getWorkflowInfo(this.wfBean1.getId());
        TestDBWorkflowStore.assertEquals((String)wfBean.getId(), (String)this.wfBean1.getId());
        TestDBWorkflowStore.assertEquals((Object)wfBean.getStatus(), (Object)this.wfBean1.getStatus());
        TestDBWorkflowStore.assertEquals((int)wfBean.getActions().size(), (int)1);
        TestDBWorkflowStore.assertEquals((String)((WorkflowAction)wfBean.getActions().get(0)).getId(), (String)this.actionId);
        this.store.commitTrx();
    }

    private void _testGetWFInfos() throws StoreException {
        HashMap<String, List<String>> filter = new HashMap<String, List<String>>();
        this.store.beginTrx();
        WorkflowsInfo wfInfo = this.store.getWorkflowsInfo(filter, 1, 1);
        System.out.println("got WorkflowsInfo " + wfInfo.getLen());
        List wfBeans = wfInfo.getWorkflows();
        this.store.commitTrx();
        TestDBWorkflowStore.assertEquals((int)1, (int)wfBeans.size());
        filter = new HashMap();
        wfInfo = this.store.getWorkflowsInfo(filter, 1, 2);
        wfBeans = wfInfo.getWorkflows();
        TestDBWorkflowStore.assertEquals((int)2, (int)wfBeans.size());
        filter = new HashMap();
        filter.put("user", Arrays.asList(TestDBWorkflowStore.getTestUser()));
        wfInfo = this.store.getWorkflowsInfo(filter, 1, 2);
        wfBeans = wfInfo.getWorkflows();
        TestDBWorkflowStore.assertEquals((int)1, (int)wfBeans.size());
        filter = new HashMap();
        filter.put("user", Arrays.asList(TestDBWorkflowStore.getTestUser(), TestDBWorkflowStore.getTestUser2()));
        wfInfo = this.store.getWorkflowsInfo(filter, 1, 2);
        wfBeans = wfInfo.getWorkflows();
        TestDBWorkflowStore.assertEquals((int)2, (int)wfBeans.size());
        filter = new HashMap();
        filter.put("user", Arrays.asList(TestDBWorkflowStore.getTestUser()));
        filter.put("status", Arrays.asList("succeeded"));
        wfInfo = this.store.getWorkflowsInfo(filter, 1, 2);
        wfBeans = wfInfo.getWorkflows();
        TestDBWorkflowStore.assertEquals((int)1, (int)wfBeans.size());
        filter = new HashMap();
        filter.put("user", Arrays.asList(TestDBWorkflowStore.getTestUser(), TestDBWorkflowStore.getTestUser2()));
        filter.put("name", Arrays.asList("testApp"));
        wfInfo = this.store.getWorkflowsInfo(filter, 1, 2);
        wfBeans = wfInfo.getWorkflows();
        TestDBWorkflowStore.assertEquals((int)2, (int)wfBeans.size());
        TestDBWorkflowStore.assertEquals((int)2, (int)wfInfo.getTotal());
        TestDBWorkflowStore.assertEquals((int)1, (int)wfInfo.getStart());
        TestDBWorkflowStore.assertEquals((int)2, (int)wfInfo.getLen());
        filter = new HashMap();
        filter.put("user", Arrays.asList(TestDBWorkflowStore.getTestUser(), TestDBWorkflowStore.getTestUser2()));
        filter.put("name", Arrays.asList("testApp"));
        wfInfo = this.store.getWorkflowsInfo(filter, 1, 1);
        wfBeans = wfInfo.getWorkflows();
        TestDBWorkflowStore.assertEquals((int)1, (int)wfBeans.size());
        TestDBWorkflowStore.assertEquals((int)2, (int)wfInfo.getTotal());
        TestDBWorkflowStore.assertEquals((int)1, (int)wfInfo.getStart());
        TestDBWorkflowStore.assertEquals((int)1, (int)wfInfo.getLen());
    }

    private void _testPurge() throws Exception {
        this.store.beginTrx();
        this.wfBean1.setEndTime(new Date(System.currentTimeMillis() - 2678400000L));
        this.wfBean2.setEndTime(new Date(System.currentTimeMillis() - 2678400000L));
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf2 = new Configuration();
        conf2.set("oozie.wf.application.path", "testPath");
        conf2.set("oozie.wf.log.token", "testToken");
        conf2.set("user.name", TestDBWorkflowStore.getTestUser2());
        WorkflowJobBean wfBean3 = this.createWorkflow((WorkflowApp)app, conf2, "auth");
        this.store.insertWorkflow(wfBean3);
        this.store.updateWorkflow(this.wfBean2);
        this.store.updateWorkflow(this.wfBean1);
        this.store.commitTrx();
        WorkflowActionBean a31 = new WorkflowActionBean();
        StringBuilder str = new StringBuilder();
        str.append(System.currentTimeMillis());
        str.append("31");
        a31.setId(str.toString());
        a31.setJobId(wfBean3.getId());
        a31.setStatus(WorkflowAction.Status.PREP);
        this.store.beginTrx();
        this.store.insertAction(a31);
        this.store.commitTrx();
        this.store.beginTrx();
        this.store.purge(30L, 10000);
        this.store.commitTrx();
    }

    public class Locker
    implements Runnable {
        protected String id;
        private String nameIndex;
        private StringBuffer sb;
        protected long timeout;

        public Locker(String id, String nameIndex, StringBuffer buffer) {
            this.id = id;
            this.nameIndex = id + ":" + nameIndex;
            this.sb = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            XLog log = XLog.getLog(this.getClass());
            try {
                WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
                log.info("Get [{0}]", new Object[]{this.nameIndex});
                store.beginTrx();
                store.getWorkflow(this.id, false);
                log.info("Got [{0}]", new Object[]{this.nameIndex});
                this.sb.append(this.nameIndex + "-L ");
                Locker locker = this;
                synchronized (locker) {
                    this.wait();
                }
                this.sb.append(this.nameIndex + "-U ");
                store.commitTrx();
                store.closeTrx();
                log.info("Release [{0}]", new Object[]{this.nameIndex});
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            Locker locker = this;
            synchronized (locker) {
                this.notify();
            }
        }
    }
}

