/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.util.List;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.service.SLAStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.SLAStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.XTestCase;

public class TestSLAStore
extends XTestCase {
    Services services;
    SLAStore store;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.store = ((SLAStoreService)Services.get().get(SLAStoreService.class)).create();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSLAStore() throws StoreException {
        String slaId = "1";
        this._testInsertEvent(slaId);
    }

    private void _testGetSlaEventSeqNewerLimited(long seqId, int limitLen) {
        try {
            long[] lastSeqId = new long[1];
            List slaEvents = this.store.getSLAEventListNewerSeqLimited(seqId, limitLen, lastSeqId);
            if (slaEvents.size() == 0) {
                TestSLAStore.fail((String)("Unable to GET Get any record of sequence id greater than =" + seqId));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestSLAStore.fail((String)("Unable to GET Get record of sequence id greater than =" + seqId));
        }
    }

    private void _testInsertEvent(String slaId) {
        SLAEventBean sla = this.createSLAEvent(slaId);
        this.store.beginTrx();
        try {
            this.store.insertSLAEvent(sla);
            this.store.commitTrx();
        }
        catch (Exception ex) {
            this.store.rollbackTrx();
            ex.printStackTrace();
            TestSLAStore.fail((String)"Unable to insert a record into COORD Job ");
        }
    }

    private SLAEventBean createSLAEvent(String slaId) {
        SLAEventBean sla = new SLAEventBean();
        sla.setSlaId(slaId);
        return sla;
    }
}

