/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hive.hcatalog.api.HCatAddPartitionDesc;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.api.HCatCreateDBDesc;
import org.apache.hive.hcatalog.api.HCatCreateTableDesc;
import org.apache.hive.hcatalog.api.HCatPartition;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.oozie.util.XLog;
import org.junit.Assert;

public class MiniHCatServer {
    private static XLog LOG = XLog.getLog(MiniHCatServer.class);
    private static final Random RANDOM = new Random();
    private RUNMODE mode;
    private Configuration hadoopConf;
    private int msPort;
    private HiveConf hiveConf;
    private HCatClient hcatClient;
    private Thread serverThread;
    private Map<String, String> sysProps;

    public MiniHCatServer(RUNMODE mode, Configuration hadoopConf) throws Exception {
        this.mode = mode;
        this.hadoopConf = hadoopConf;
        this.sysProps = new HashMap<String, String>();
    }

    public void start() throws Exception {
        if (this.mode.equals((Object)RUNMODE.LOCAL)) {
            this.initLocalMetastoreConf();
        } else {
            this.msPort = RANDOM.nextInt(100) + 30000;
            this.startMetastoreServer();
            this.initMetastoreServerConf();
        }
        this.hcatClient = HCatClient.create((Configuration)this.hiveConf);
    }

    public void shutdown() throws Exception {
        this.resetSystemProperties();
        this.hcatClient.close();
        if (this.mode.equals((Object)RUNMODE.SERVER)) {
            this.serverThread.stop();
        }
    }

    private void initLocalMetastoreConf() throws IOException {
        this.hiveConf = new HiveConf(this.hadoopConf, this.getClass());
        this.hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, new File("target/warehouse").getAbsolutePath());
        this.hiveConf.set("hive.metastore.local", "true");
        this.hiveConf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:target/metastore_db;create=true");
        this.setSystemProperty("hive.metastore.local", "true");
        this.setSystemProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, new File("target/warehouse").getAbsolutePath());
        this.setSystemProperty(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:target/metastore_db;create=true");
        File derbyLogFile = new File("target/derby.log");
        derbyLogFile.createNewFile();
        this.setSystemProperty("derby.stream.error.file", derbyLogFile.getPath());
    }

    private void initMetastoreServerConf() throws Exception {
        this.hiveConf = new HiveConf(this.hadoopConf, this.getClass());
        this.hiveConf.set("hive.metastore.local", "false");
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, "thrift://localhost:" + this.msPort);
        this.hiveConf.set(HiveConf.ConfVars.PREEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POSTEXECHOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY.varname, "false");
    }

    private void startMetastoreServer() throws Exception {
        final HiveConf serverConf = new HiveConf(this.hadoopConf, this.getClass());
        serverConf.set("hive.metastore.local", "false");
        serverConf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:target/metastore_db;create=true");
        File derbyLogFile = new File("target/derby.log");
        derbyLogFile.createNewFile();
        this.setSystemProperty("derby.stream.error.file", derbyLogFile.getPath());
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HiveMetaStore.startMetaStore((int)MiniHCatServer.this.msPort, (HadoopThriftAuthBridge)ShimLoader.getHadoopThriftAuthBridge(), (HiveConf)serverConf);
                    LOG.info((Object)("Started metastore server on port " + MiniHCatServer.this.msPort));
                }
                catch (Throwable e) {
                    LOG.error((Object)"Metastore Thrift Server threw an exception...", e);
                }
            }
        });
        this.serverThread.setDaemon(true);
        this.serverThread.start();
        Thread.sleep(10000L);
    }

    public static void resetHiveConfStaticVariables() throws Exception {
        HiveConf.setHiveSiteLocation((URL)HiveConf.class.getClassLoader().getResource("hive-site.xml"));
    }

    private void setSystemProperty(String name, String value) {
        if (!this.sysProps.containsKey(name)) {
            String currentValue = System.getProperty(name);
            this.sysProps.put(name, currentValue);
        }
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.getProperties().remove(name);
        }
    }

    private void resetSystemProperties() {
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.getProperties().remove(entry.getKey());
        }
        this.sysProps.clear();
    }

    public Configuration getMetaStoreConf() {
        return this.hiveConf;
    }

    public String getMetastoreAuthority() {
        if (this.mode.equals((Object)RUNMODE.SERVER)) {
            return "localhost:" + this.msPort;
        }
        return "unittest-local";
    }

    public String getMetastoreURI() {
        return this.hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname);
    }

    public HCatClient getHCatClient() {
        return this.hcatClient;
    }

    public URI getHCatURI(String db, String table, String partitions) throws URISyntaxException {
        StringBuilder uri = new StringBuilder();
        uri.append("hcat://").append(this.getMetastoreAuthority()).append("/").append(db).append("/").append(table).append("/").append(partitions);
        return new URI(uri.toString());
    }

    public URI getHCatURI(String db, String table) throws URISyntaxException {
        StringBuilder uri = new StringBuilder();
        uri.append("hcat://").append(this.getMetastoreAuthority()).append("/").append(db).append("/").append(table);
        return new URI(uri.toString());
    }

    public void createDatabase(String db, String location) throws Exception {
        HCatCreateDBDesc dbDesc = HCatCreateDBDesc.create((String)db).ifNotExists(true).location(location).build();
        this.hcatClient.createDatabase(dbDesc);
        List dbNames = this.hcatClient.listDatabaseNamesByPattern(db);
        Assert.assertTrue((boolean)dbNames.contains(db));
    }

    public void createTable(String db, String table, String partitionCols) throws Exception {
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("userid", HCatFieldSchema.Type.INT, "userid"));
        cols.add(new HCatFieldSchema("viewtime", HCatFieldSchema.Type.BIGINT, "view time"));
        cols.add(new HCatFieldSchema("pageurl", HCatFieldSchema.Type.STRING, "page url visited"));
        cols.add(new HCatFieldSchema("ip", HCatFieldSchema.Type.STRING, "IP Address of the User"));
        ArrayList<HCatFieldSchema> ptnCols = new ArrayList<HCatFieldSchema>();
        for (String partitionCol : partitionCols.split(",")) {
            ptnCols.add(new HCatFieldSchema(partitionCol, HCatFieldSchema.Type.STRING, null));
        }
        HashMap<String, String> tblProps = new HashMap<String, String>();
        tblProps.put("hcat.msgbus.topic.name", "hcat." + db + "." + table);
        HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create((String)db, (String)table, cols).fileFormat("textfile").partCols(ptnCols).tblProps(tblProps).build();
        this.hcatClient.createTable(tableDesc);
        List tables = this.hcatClient.listTableNamesByPattern(db, "*");
        Assert.assertTrue((boolean)tables.contains(table));
    }

    public void createTable(String db, String table) throws Exception {
        ArrayList<HCatFieldSchema> cols = new ArrayList<HCatFieldSchema>();
        cols.add(new HCatFieldSchema("userid", HCatFieldSchema.Type.INT, "userid"));
        cols.add(new HCatFieldSchema("viewtime", HCatFieldSchema.Type.BIGINT, "view time"));
        cols.add(new HCatFieldSchema("pageurl", HCatFieldSchema.Type.STRING, "page url visited"));
        cols.add(new HCatFieldSchema("ip", HCatFieldSchema.Type.STRING, "IP Address of the User"));
        HashMap<String, String> tblProps = new HashMap<String, String>();
        tblProps.put("hcat.msgbus.topic.name", "hcat." + db + "." + table);
        HCatCreateTableDesc tableDesc = HCatCreateTableDesc.create((String)db, (String)table, cols).fileFormat("textfile").tblProps(tblProps).build();
        this.hcatClient.createTable(tableDesc);
        List tables = this.hcatClient.listTableNamesByPattern(db, "*");
        Assert.assertTrue((boolean)tables.contains(table));
    }

    public void dropDatabase(String db, boolean ifExists) throws Exception {
        this.hcatClient.dropDatabase(db, ifExists, HCatClient.DropDBMode.CASCADE);
        List dbNames = this.hcatClient.listDatabaseNamesByPattern(db);
        Assert.assertFalse((boolean)dbNames.contains(db));
    }

    public void dropTable(String db, String table, boolean ifExists) throws Exception {
        this.hcatClient.dropTable(db, table, ifExists);
        List tables = this.hcatClient.listTableNamesByPattern(db, "*");
        Assert.assertFalse((boolean)tables.contains(table));
    }

    public String getPartitionDir(String db, String table, String partitionSpec, String dbLocation) throws Exception {
        String dir = dbLocation + "/" + db + "/" + table + "/" + partitionSpec.replaceAll(";", "/");
        return dir;
    }

    public String createPartitionDir(String db, String table, String partitionSpec, String dbLocation) throws Exception {
        String dir = this.getPartitionDir(db, table, partitionSpec, dbLocation);
        FileSystem.get((Configuration)this.hadoopConf).mkdirs(new Path(dir));
        return dir;
    }

    public void addPartition(String db, String table, String partitionSpec, String location) throws Exception {
        String[] parts = partitionSpec.split(";");
        HashMap<String, String> partitions = new HashMap<String, String>();
        for (String part : parts) {
            String[] split = part.split("=");
            partitions.put(split[0], split[1]);
        }
        HCatAddPartitionDesc addPtn = HCatAddPartitionDesc.create((String)db, (String)table, (String)location, partitions).build();
        this.hcatClient.addPartition(addPtn);
        Assert.assertNotNull((Object)this.hcatClient.getPartition(db, table, partitions));
    }

    public void dropPartition(String db, String table, String partitionSpec) throws Exception {
        String[] parts = partitionSpec.split(";");
        HashMap<String, String> partitions = new HashMap<String, String>();
        for (String part : parts) {
            String[] split = part.split("=");
            partitions.put(split[0], split[1]);
        }
        this.hcatClient.dropPartitions(db, table, partitions, false);
    }

    public List<HCatPartition> getPartitions(String db, String table, String partitionSpec) throws Exception {
        String[] parts = partitionSpec.split(";");
        HashMap<String, String> partitions = new HashMap<String, String>();
        for (String part : parts) {
            String[] split = part.split("=");
            partitions.put(split[0], split[1]);
        }
        return this.hcatClient.getPartitions(db, table, partitions);
    }

    public static enum RUNMODE {
        LOCAL,
        SERVER;

    }
}

