/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.PingServlet;
import org.apache.oozie.test.XTestCase;

public class TestEmbeddedServletContainer
extends XTestCase {
    public void testEmbeddedServletContainer() throws Exception {
        EmbeddedServletContainer container = new EmbeddedServletContainer("blah");
        container.addServletEndpoint("/ping/*", PingServlet.class);
        container.addFilter("/ping/*", PingServlet.class);
        try {
            PingServlet.FILTER_INIT = false;
            PingServlet.DO_FILTER = false;
            container.start();
            this.assertHttpResponse(container);
        }
        finally {
            container.stop();
        }
    }

    public void testMultipleParallelStarts() throws Exception {
        ArrayList<EmbeddedServletContainer> containers = new ArrayList<EmbeddedServletContainer>();
        PingServlet.FILTER_INIT = false;
        PingServlet.DO_FILTER = false;
        for (int i = 0; i < 10; ++i) {
            EmbeddedServletContainer c = new EmbeddedServletContainer("path" + i);
            c.addServletEndpoint("/ping/*", PingServlet.class);
            c.addFilter("/ping/*", PingServlet.class);
            containers.add(c);
        }
        this.startAllContainers(containers);
        for (EmbeddedServletContainer c : containers) {
            this.assertHttpResponse(c);
        }
        this.stopAllContainers(containers);
    }

    private void stopAllContainers(List<EmbeddedServletContainer> containers) {
        for (EmbeddedServletContainer c : containers) {
            c.stop();
        }
    }

    private void startAllContainers(List<EmbeddedServletContainer> containers) throws Exception {
        for (EmbeddedServletContainer c : containers) {
            c.start();
        }
    }

    private void assertHttpResponse(EmbeddedServletContainer c) throws IOException {
        URL url = new URL(c.getServletURL("/ping/*") + "bla");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        TestEmbeddedServletContainer.assertEquals((int)200, (int)conn.getResponseCode());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        TestEmbeddedServletContainer.assertEquals((String)"ping", (String)reader.readLine());
        TestEmbeddedServletContainer.assertEquals(null, (String)reader.readLine());
        TestEmbeddedServletContainer.assertTrue((boolean)PingServlet.FILTER_INIT);
        TestEmbeddedServletContainer.assertTrue((boolean)PingServlet.DO_FILTER);
    }
}

