/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobClient;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;

public abstract class XFsTestCase
extends XTestCase {
    private static HadoopAccessorService has;
    private FileSystem fileSystem;
    private FileSystem fileSystem2;
    private Path fsTestDir;
    private Path fsTestDir2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XConfiguration conf = new XConfiguration();
        conf.setBoolean("oozie.service.HadoopAccessorService.kerberos.enabled", System.getProperty("oozie.test.hadoop.security", "simple").equals("kerberos"));
        conf.set("oozie.service.HadoopAccessorService.keytab.file", this.getKeytabFile());
        conf.set("oozie.service.HadoopAccessorService.kerberos.principal", this.getOoziePrincipal());
        conf.set("local.realm", this.getRealm());
        conf.set("oozie.service.HadoopAccessorService.hadoop.configurations", "*=hadoop-conf");
        conf.set("oozie.service.HadoopAccessorService.action.configurations", "*=action-conf");
        has = new HadoopAccessorService();
        has.init((Configuration)conf);
        Configuration jobConf = has.createConfiguration(this.getNameNodeUri());
        XConfiguration.copy((Configuration)conf, (Configuration)jobConf);
        this.fileSystem = has.createFileSystem(XFsTestCase.getTestUser(), new URI(this.getNameNodeUri()), jobConf);
        this.fsTestDir = this.initFileSystem(this.fileSystem);
        if (System.getProperty("oozie.test.hadoop.minicluster2", "false").equals("true")) {
            this.fileSystem2 = has.createFileSystem(XFsTestCase.getTestUser(), new URI(this.getNameNode2Uri()), jobConf);
            this.fsTestDir2 = this.initFileSystem(this.fileSystem2);
        }
    }

    private Path initFileSystem(FileSystem fs) throws Exception {
        Path path = new Path(fs.getWorkingDirectory(), UUID.randomUUID().toString());
        Path testDirInFs = fs.makeQualified(path);
        System.out.println(XLog.format((String)"Setting FS testcase work dir[{0}]", (Object[])new Object[]{testDirInFs}));
        if (fs.exists(testDirInFs)) {
            this.setAllPermissions(fs, testDirInFs);
        }
        fs.delete(testDirInFs, true);
        if (!fs.mkdirs(path)) {
            throw new IOException(XLog.format((String)"Could not create FS testcase dir [{0}]", (Object[])new Object[]{testDirInFs}));
        }
        fs.setOwner(testDirInFs, XFsTestCase.getTestUser(), XFsTestCase.getTestGroup());
        fs.setPermission(testDirInFs, FsPermission.valueOf((String)"-rwxrwx--x"));
        return testDirInFs;
    }

    private void setAllPermissions(FileSystem fileSystem, Path path) throws IOException {
        FsPermission fsPermission = new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE);
        try {
            fileSystem.setPermission(path, fsPermission);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileStatus fileStatus = fileSystem.getFileStatus(path);
        if (fileStatus.isDir()) {
            for (FileStatus status : fileSystem.listStatus(path)) {
                this.setAllPermissions(fileSystem, status.getPath());
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.fileSystem = null;
        this.fsTestDir = null;
        super.tearDown();
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected FileSystem getFileSystem2() {
        return this.fileSystem2;
    }

    protected Path getFsTestCaseDir() {
        return this.fsTestDir;
    }

    protected Path getFs2TestCaseDir() {
        return this.fsTestDir2;
    }

    protected JobClient createJobClient() throws HadoopAccessorException {
        Configuration conf = has.createConfiguration(this.getJobTrackerUri());
        conf.set("mapred.job.tracker", this.getJobTrackerUri());
        conf.set("fs.default.name", this.getNameNodeUri());
        return has.createJobClient(XFsTestCase.getTestUser(), conf);
    }

    protected Path getPathToWorkflowResource(String userName, WorkflowJob job, Services services, ActionXCommand.ActionExecutorContext context, String fileName) throws Exception {
        return new Path("/user/" + userName + "/" + services.getSystemId() + "/" + job.getId() + "/" + context.getActionDir().getName(), fileName);
    }
}

