/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import junit.framework.TestCase;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StoreService;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.MiniHCatServer;
import org.apache.oozie.test.hive.MiniHS2;
import org.apache.oozie.util.ClasspathUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.RollbackException;

public abstract class XTestCase
extends TestCase {
    private static EnumSet<YarnApplicationState> YARN_TERMINAL_STATES = EnumSet.of(YarnApplicationState.FAILED, YarnApplicationState.KILLED, YarnApplicationState.FINISHED);
    private Map<String, String> sysProps;
    private String testCaseDir;
    private String testCaseConfDir;
    private String hadoopVersion;
    protected XLog log = new XLog(LogFactory.getLog(((Object)((Object)this)).getClass()));
    protected static File OOZIE_SRC_DIR = null;
    private static final String OOZIE_TEST_PROPERTIES = "oozie.test.properties";
    protected static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    public static float WAITFOR_RATIO = Float.parseFloat(System.getProperty("oozie.test.waitfor.ratio", "1"));
    protected static final String localActiveMQBroker = "vm://localhost?broker.persistent=false";
    protected static final String ActiveMQConnFactory = "org.apache.activemq.jndi.ActiveMQInitialContextFactory";
    public static final String OOZIE_TEST_DIR = "oozie.test.dir";
    public static final String OOZIE_TEST_JOB_TRACKER = "oozie.test.job.tracker";
    public static final String OOZIE_TEST_NAME_NODE = "oozie.test.name.node";
    public static final String OOZIE_TEST_NAME_NODE2 = "oozie.test.name.node2";
    public static final String HADOOP_VERSION = "hadoop.version";
    public static final String TEST_OOZIE_USER_PROP = "oozie.test.user.oozie";
    public static final String TEST_USER1_PROP = "oozie.test.user.test";
    public static final String TEST_USER2_PROP = "oozie.test.user.test2";
    public static final String TEST_USER3_PROP = "oozie.test.user.test3";
    public static final String TEST_GROUP_PROP = "oozie.test.group";
    public static final String TEST_GROUP_PROP2 = "oozie.test.group2";
    public static final String TEST_MINICLUSTER_MONITOR_SHUTDOWN_WAIT = "oozie.test.minicluster.monitor.shutdown.wait";
    protected static final String SHELL_COMMAND_NAME;
    protected static final String SHELL_COMMAND_SCRIPTFILE_EXTENSION;
    protected static final String SHELL_COMMAND_SCRIPTFILE_OPTION;
    private static final String MINIMAL_SERVICES_FOR_DB_CLEANUP;
    private static MiniDFSCluster dfsCluster;
    private static MiniDFSCluster dfsCluster2;
    private static MiniMRCluster mrCluster;
    private static MiniHCatServer hcatServer;
    private static MiniHS2 hiveserver2;
    private static HiveConf hs2Config;
    private static final AtomicLong LAST_TESTCASE_FINISHED;
    private static final AtomicInteger RUNNING_TESTCASES;

    protected void setUp() throws Exception {
        this.setUp(true);
    }

    protected void setUp(boolean cleanUpDBTables) throws Exception {
        RUNNING_TESTCASES.incrementAndGet();
        super.setUp();
        this.deleteCreatedFiles();
        String baseDir = System.getProperty(OOZIE_TEST_DIR, new File("target/test-data").getAbsolutePath());
        String msg = null;
        File f = new File(baseDir);
        if (!f.isAbsolute()) {
            msg = XLog.format((String)"System property [{0}]=[{1}] must be set to an absolute path", (Object[])new Object[]{OOZIE_TEST_DIR, baseDir});
        } else if (baseDir.length() < 4) {
            msg = XLog.format((String)"System property [{0}]=[{1}] path must be at least 4 chars", (Object[])new Object[]{OOZIE_TEST_DIR, baseDir});
        }
        if (msg != null) {
            System.err.println();
            System.err.println(msg);
            System.exit(-1);
        }
        f.mkdirs();
        if (!f.exists() || !f.isDirectory()) {
            System.err.println();
            System.err.println(XLog.format((String)"Could not create test dir [{0}]", (Object[])new Object[]{baseDir}));
            System.exit(-1);
        }
        this.hadoopVersion = System.getProperty(HADOOP_VERSION, "0.20.0");
        this.testCaseDir = this.createTestCaseDir(this, true);
        this.setSystemProperty("oozie.home.dir", this.testCaseDir);
        Services.setOozieHome();
        this.testCaseConfDir = this.createTestCaseSubDir("conf");
        String oozieTestDB = System.getProperty("oozie.test.db", "hsqldb");
        String oozieSiteFileName = oozieTestDB + "-oozie-site.xml";
        String defaultOozieSite = new File(OOZIE_SRC_DIR, "core/src/test/resources/" + oozieSiteFileName).getAbsolutePath();
        String customOozieSite = System.getProperty("oozie.test.config.file", defaultOozieSite);
        File source = new File(customOozieSite);
        if (!source.isAbsolute()) {
            source = new File(OOZIE_SRC_DIR, customOozieSite);
        }
        source = source.getAbsoluteFile();
        InputStream oozieSiteSourceStream = null;
        if (source.exists()) {
            this.log.info("Reading Oozie test resource from file. [source.name={0}]", new Object[]{source.getName()});
            oozieSiteSourceStream = new FileInputStream(source);
        } else {
            String customOozieSiteFileName;
            this.log.info("Oozie test resource file doesn't exist. [source.name={0}]", new Object[]{source.getName()});
            String testResourceName = customOozieSite.lastIndexOf("/") > -1 ? ((customOozieSiteFileName = customOozieSite.substring(customOozieSite.lastIndexOf("/") + 1)).equals(oozieSiteFileName) ? oozieSiteFileName : customOozieSiteFileName) : oozieSiteFileName;
            this.log.info("Reading Oozie test resource from classpath. [testResourceName={0};source.name={1}]", new Object[]{testResourceName, source.getName()});
            URL sourceURL = ((Object)((Object)this)).getClass().getClassLoader().getResource(testResourceName);
            if (sourceURL != null) {
                oozieSiteSourceStream = sourceURL.openStream();
            } else {
                System.err.println();
                System.err.println(XLog.format((String)"Custom configuration file for testing does not exist [{0}]", (Object[])new Object[]{source.getAbsolutePath()}));
                System.err.println();
                System.exit(-1);
            }
        }
        Configuration oozieSiteConf = new Configuration(false);
        oozieSiteConf.addResource(oozieSiteSourceStream);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("oozie-default.xml");
        XConfiguration configuration = new XConfiguration(inputStream);
        String classes = configuration.get("oozie.services");
        oozieSiteConf.set("oozie.services", classes.replaceAll("org.apache.oozie.service.ShareLibService,", ""));
        oozieSiteConf.set("oozie.service.JPAService.create.db.schema", "true");
        File target = new File(this.testCaseConfDir, "oozie-site.xml");
        oozieSiteConf.writeXml((OutputStream)new FileOutputStream(target));
        File hadoopConfDir = new File(this.testCaseConfDir, "hadoop-conf");
        hadoopConfDir.mkdir();
        File actionConfDir = new File(this.testCaseConfDir, "action-conf");
        actionConfDir.mkdir();
        source = new File(OOZIE_SRC_DIR, "core/src/test/resources/hadoop-config.xml");
        InputStream hadoopConfigResourceStream = null;
        if (!source.exists()) {
            URL sourceURL = ((Object)((Object)this)).getClass().getClassLoader().getResource("hadoop-config.xml");
            if (sourceURL != null) {
                hadoopConfigResourceStream = sourceURL.openStream();
            } else {
                System.err.println();
                System.err.println(XLog.format((String)"hadoop-config.xml configuration file for testing does not exist [{0}]", (Object[])new Object[]{source.getAbsolutePath()}));
                System.err.println();
                System.exit(-1);
            }
        } else {
            hadoopConfigResourceStream = new FileInputStream(source);
        }
        target = new File(hadoopConfDir, "hadoop-site.xml");
        IOUtils.copyStream((InputStream)hadoopConfigResourceStream, (OutputStream)new FileOutputStream(target));
        if (System.getProperty("oozielocal.log") == null) {
            this.setSystemProperty("oozielocal.log", "/tmp/oozielocal.log");
        }
        if (System.getProperty("oozie.test.hadoop.security", "simple").equals("kerberos")) {
            System.setProperty("oozie.service.HadoopAccessorService.kerberos.enabled", "true");
        }
        if (System.getProperty("oozie.test.hadoop.minicluster", "true").equals("true")) {
            this.setUpEmbeddedHadoop(this.getTestCaseDir());
            if (System.getProperty("oozie.test.hadoop.minicluster2", "false").equals("true")) {
                this.setUpEmbeddedHadoop2();
            }
        }
        if (System.getProperty("oozie.test.db.host") == null) {
            System.setProperty("oozie.test.db.host", "localhost");
        }
        this.setSystemProperty("oozie.data.dir", this.testCaseDir);
        this.setSystemProperty("oozie.service.HadoopAccessorService.supported.filesystems", "*");
        if (System.getProperty("oozie.instance.id") == null) {
            System.setProperty("oozie.instance.id", "1234");
        }
        if (mrCluster != null) {
            FileOutputStream os = new FileOutputStream(new File(hadoopConfDir, "core-site.xml"));
            JobConf conf = this.createJobConfFromMRCluster();
            conf.writeXml((OutputStream)os);
            ((OutputStream)os).close();
        }
        if (System.getProperty("oozie.test.metastore.server", "false").equals("true")) {
            this.setupHCatalogServer();
        }
        if (System.getProperty("oozie.test.hive.server.2", "false").equals("true")) {
            this.setupHiveServer2();
        }
        if (cleanUpDBTables) {
            this.cleanUpDBTables();
        }
    }

    protected void tearDown() throws Exception {
        this.tearDownHiveServer2();
        this.tearDownHCatalogServer();
        this.resetSystemProperties();
        this.sysProps = null;
        this.testCaseDir = null;
        this.deleteCreatedFiles();
        super.tearDown();
        RUNNING_TESTCASES.decrementAndGet();
        LAST_TESTCASE_FINISHED.set(System.currentTimeMillis());
    }

    protected void deleteCreatedFiles() {
        for (File f : this.getFilesToDelete()) {
            if (!f.exists()) continue;
            f.delete();
        }
    }

    protected List<File> getFilesToDelete() {
        File root = new File(".");
        File[] filesToDelete = root.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".log") || name.endsWith("log4j.properties") || name.equals("propagation-conf.xml");
            }
        });
        return new ArrayList<File>(Arrays.asList(filesToDelete));
    }

    protected String getTestCaseDir() {
        return this.testCaseDir;
    }

    protected String getTestCaseFileUri(String relativeUri) {
        String uri = new File(this.testCaseDir).toURI().toString();
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri + "/" + relativeUri;
    }

    protected String getTestCaseConfDir() {
        return this.testCaseConfDir;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public static String getOozieUser() {
        return System.getProperty(TEST_OOZIE_USER_PROP, System.getProperty("user.name"));
    }

    protected static String getTestUser() {
        return System.getProperty(TEST_USER1_PROP, "test");
    }

    protected static String getTestUser2() {
        return System.getProperty(TEST_USER2_PROP, "test2");
    }

    protected static String getTestUser3() {
        return System.getProperty(TEST_USER3_PROP, "test3");
    }

    protected static String getTestGroup() {
        return System.getProperty(TEST_GROUP_PROP, "testg");
    }

    protected static String getTestGroup2() {
        return System.getProperty(TEST_GROUP_PROP, "testg2");
    }

    private String getTestCaseDirInternal(TestCase testCase) {
        ParamChecker.notNull((Object)testCase, (String)"testCase");
        File dir = new File(System.getProperty(OOZIE_TEST_DIR, "target/test-data"));
        dir = new File(dir, "oozietests").getAbsoluteFile();
        dir = new File(dir, testCase.getClass().getName());
        dir = new File(dir, testCase.getName());
        dir = new File(dir, UUID.randomUUID().toString());
        return dir.getAbsolutePath();
    }

    protected void delete(File file) throws IOException {
        ParamChecker.notNull((Object)file, (String)"file");
        if (file.getAbsolutePath().length() < 5) {
            throw new RuntimeException(XLog.format((String)"path [{0}] is too short, not deleting", (Object[])new Object[]{file.getAbsolutePath()}));
        }
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                for (File child : children) {
                    this.delete(child);
                }
            }
            if (!file.delete()) {
                throw new RuntimeException(XLog.format((String)"could not delete path [{0}]", (Object[])new Object[]{file.getAbsolutePath()}));
            }
        } else {
            file.delete();
        }
    }

    private String createTestCaseDir(TestCase testCase, boolean cleanup) throws Exception {
        File dir;
        String testCaseDir = this.getTestCaseDirInternal(testCase);
        System.out.println();
        System.out.println(XLog.format((String)"Setting testcase work dir[{0}]", (Object[])new Object[]{testCaseDir}));
        if (cleanup) {
            this.delete(new File(testCaseDir));
        }
        if (!(dir = new File(testCaseDir)).mkdirs()) {
            throw new RuntimeException(XLog.format((String)"Could not create testcase dir[{0}]", (Object[])new Object[]{testCaseDir}));
        }
        return testCaseDir;
    }

    protected String createTestCaseSubDir(String ... subDirNames) {
        ParamChecker.notNull((Object)subDirNames, (String)"subDirName");
        if (subDirNames.length == 0) {
            throw new RuntimeException(XLog.format((String)"Could not create testcase subdir ''; it already exists", (Object[])new Object[0]));
        }
        File dir = new File(this.testCaseDir);
        for (int i = 0; i < subDirNames.length; ++i) {
            ParamChecker.notNull((Object)subDirNames[i], (String)("subDirName[" + i + "]"));
            dir = new File(dir, subDirNames[i]);
        }
        if (!dir.mkdirs()) {
            throw new RuntimeException(XLog.format((String)"Could not create testcase subdir[{0}]", (Object[])new Object[]{dir}));
        }
        return dir.getAbsolutePath();
    }

    protected void setSystemProperty(String name, String value) {
        if (this.sysProps == null) {
            this.sysProps = new HashMap<String, String>();
        }
        if (!this.sysProps.containsKey(name)) {
            String currentValue = System.getProperty(name);
            this.sysProps.put(name, currentValue);
        }
        if (value != null) {
            System.setProperty(name, value);
        } else {
            System.getProperties().remove(name);
        }
    }

    private void resetSystemProperties() {
        if (this.sysProps != null) {
            for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
                if (entry.getValue() != null) {
                    System.setProperty(entry.getKey(), entry.getValue());
                    continue;
                }
                System.getProperties().remove(entry.getKey());
            }
            this.sysProps.clear();
        }
    }

    protected long waitFor(int timeout, Predicate predicate) {
        ParamChecker.notNull((Object)predicate, (String)"predicate");
        XLog log = new XLog(LogFactory.getLog(((Object)((Object)this)).getClass()));
        long started = System.currentTimeMillis();
        long mustEnd = System.currentTimeMillis() + (long)(WAITFOR_RATIO * (float)timeout);
        long lastEcho = 0L;
        try {
            boolean eval;
            long waiting = mustEnd - System.currentTimeMillis();
            log.info("Waiting up to [{0}] msec", new Object[]{waiting});
            while (!(eval = predicate.evaluate()) && System.currentTimeMillis() < mustEnd) {
                if (System.currentTimeMillis() - lastEcho > 1000L) {
                    waiting = mustEnd - System.currentTimeMillis();
                    log.info("Waiting up to [{0}] msec", new Object[]{waiting});
                    lastEcho = System.currentTimeMillis();
                }
                Thread.sleep(1000L);
            }
            if (!eval) {
                log.info("Waiting timed out after [{0}] msec", new Object[]{timeout});
            }
            return System.currentTimeMillis() - started;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void sleep(int sleepTime) {
        this.waitFor(sleepTime, new Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return false;
            }
        });
    }

    protected String getJobTrackerUri() {
        return System.getProperty(OOZIE_TEST_JOB_TRACKER, "localhost:9001");
    }

    protected String getNameNodeUri() {
        return System.getProperty(OOZIE_TEST_NAME_NODE, "hdfs://localhost:9000");
    }

    protected String getNameNode2Uri() {
        return System.getProperty(OOZIE_TEST_NAME_NODE2, "hdfs://localhost:9100");
    }

    public String getKeytabFile() {
        String defaultFile = new File(System.getProperty("user.home"), "oozie.keytab").getAbsolutePath();
        return System.getProperty("oozie.test.kerberos.keytab.file", defaultFile);
    }

    public String getRealm() {
        return System.getProperty("oozie.test.kerberos.realm", "LOCALHOST");
    }

    public String getOoziePrincipal() {
        return System.getProperty("oozie.test.kerberos.oozie.principal", XTestCase.getOozieUser() + "/localhost") + "@" + this.getRealm();
    }

    protected MiniHCatServer getHCatalogServer() {
        return hcatServer;
    }

    protected final void cleanUpDBTables() throws Exception {
        if (Services.get() != null) {
            this.cleanUpDBTablesInternal();
        } else {
            try {
                Services services = new Services();
                services.getConf().set("oozie.services", MINIMAL_SERVICES_FOR_DB_CLEANUP);
                services.init();
                this.cleanUpDBTablesInternal();
            }
            finally {
                if (Services.get() != null) {
                    Services.get().destroy();
                }
            }
        }
    }

    private void cleanUpDBTablesInternal() throws StoreException {
        EntityManager entityManager = ((JPAService)Services.get().get(JPAService.class)).getEntityManager();
        entityManager.setFlushMode(FlushModeType.COMMIT);
        entityManager.getTransaction().begin();
        int wfjSize = this.getCountAndRemoveAll(entityManager, "GET_WORKFLOWS", WorkflowJobBean.class);
        int wfaSize = this.getCountAndRemoveAll(entityManager, "GET_ACTIONS", WorkflowActionBean.class);
        int cojSize = this.getCountAndRemoveAll(entityManager, "GET_COORD_JOBS", CoordinatorJobBean.class);
        int coaSize = this.getCountAndRemoveAll(entityManager, "GET_COORD_ACTIONS", CoordinatorActionBean.class);
        int bjSize = this.getCountAndRemoveAll(entityManager, "GET_BUNDLE_JOBS", BundleJobBean.class);
        int baSize = this.getCountAndRemoveAll(entityManager, "GET_BUNDLE_ACTIONS", BundleActionBean.class);
        int slaSize = this.getCountAndRemoveAll(entityManager, "GET_SLA_EVENTS", SLAEventBean.class);
        int slaRegSize = this.getCountAndRemoveAll(entityManager, "GET_SLA_REGISTRATIONS", SLARegistrationBean.class);
        int ssSize = this.getCountAndRemoveAll(entityManager, "GET_SLA_SUMMARY_ALL", SLASummaryBean.class);
        try {
            if (entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().commit();
            }
            if (entityManager.isOpen()) {
                entityManager.close();
            }
        }
        catch (RollbackException e) {
            this.log.warn("Cannot commit current transaction. [e.message={0}]", new Object[]{e.getMessage()});
        }
        this.log.info((Object)(wfjSize + " entries in WF_JOBS removed from DB!"));
        this.log.info((Object)(wfaSize + " entries in WF_ACTIONS removed from DB!"));
        this.log.info((Object)(cojSize + " entries in COORD_JOBS removed from DB!"));
        this.log.info((Object)(coaSize + " entries in COORD_ACTIONS removed from DB!"));
        this.log.info((Object)(bjSize + " entries in BUNDLE_JOBS removed from DB!"));
        this.log.info((Object)(baSize + " entries in BUNDLE_ACTIONS removed from DB!"));
        this.log.info((Object)(slaSize + " entries in SLA_EVENTS removed from DB!"));
        this.log.info((Object)(slaRegSize + " entries in SLA_REGISTRATION removed from DB!"));
        this.log.info((Object)(ssSize + " entries in SLA_SUMMARY removed from DB!"));
    }

    private <E> int getCountAndRemoveAll(EntityManager entityManager, String queryName, Class<E> entityClass) {
        try {
            TypedQuery getAllQuery = entityManager.createNamedQuery(queryName, entityClass);
            List allEntities = getAllQuery.getResultList();
            int entitiesCount = allEntities.size();
            for (Object w : allEntities) {
                entityManager.remove(w);
            }
            return entitiesCount;
        }
        catch (RollbackException e) {
            this.log.warn("Cannot get count or remove all entities. [queryName={0};entityClass.name={1}]", new Object[]{queryName, entityClass.getName()});
            return 0;
        }
        catch (PersistenceException | ArgumentException e) {
            this.log.warn("Cannot get count or remove all entities. [queryName={0};entityClass.name={1}]", new Object[]{queryName, entityClass.getName()});
            return 0;
        }
    }

    private void setUpEmbeddedHadoop(String testCaseDir) throws Exception {
        if (dfsCluster == null && mrCluster == null) {
            if (System.getProperty("hadoop.log.dir") == null) {
                System.setProperty("hadoop.log.dir", testCaseDir);
            }
            ClasspathUtils.setUsingMiniYarnCluster((boolean)true);
            int taskTrackers = 2;
            int dataNodes = 2;
            String oozieUser = XTestCase.getOozieUser();
            JobConf conf = this.createDFSConfig();
            String[] userGroups = new String[]{XTestCase.getTestGroup(), XTestCase.getTestGroup2()};
            UserGroupInformation.createUserForTesting((String)oozieUser, (String[])userGroups);
            UserGroupInformation.createUserForTesting((String)XTestCase.getTestUser(), (String[])userGroups);
            UserGroupInformation.createUserForTesting((String)XTestCase.getTestUser2(), (String[])userGroups);
            UserGroupInformation.createUserForTesting((String)XTestCase.getTestUser3(), (String[])new String[]{"users"});
            try {
                dfsCluster = new MiniDFSCluster((Configuration)conf, dataNodes, true, null);
                DistributedFileSystem fileSystem = dfsCluster.getFileSystem();
                fileSystem.mkdirs(new Path("target/test-data"));
                fileSystem.mkdirs(new Path("target/test-data/minicluster/mapred"));
                fileSystem.mkdirs(new Path("/user"));
                fileSystem.mkdirs(new Path("/tmp"));
                fileSystem.mkdirs(new Path("/hadoop/mapred/system"));
                fileSystem.setPermission(new Path("target/test-data"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("target/test-data/minicluster"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("target/test-data/minicluster/mapred"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("/hadoop/mapred/system"), FsPermission.valueOf((String)"-rwx------"));
                String nnURI = fileSystem.getUri().toString();
                int numDirs = 1;
                String[] racks = null;
                String[] hosts = null;
                mrCluster = new MiniMRCluster(0, 0, taskTrackers, nnURI, numDirs, racks, hosts, null, conf);
                JobConf jobConf = mrCluster.createJobConf();
                System.setProperty(OOZIE_TEST_JOB_TRACKER, jobConf.get("mapred.job.tracker"));
                String rmAddress = jobConf.get("yarn.resourcemanager.address");
                if (rmAddress != null) {
                    System.setProperty(OOZIE_TEST_JOB_TRACKER, rmAddress);
                }
                System.setProperty(OOZIE_TEST_NAME_NODE, jobConf.get("fs.default.name"));
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
            }
            catch (Exception ex) {
                XTestCase.shutdownMiniCluster();
                throw ex;
            }
            new MiniClusterShutdownMonitor().start();
        }
    }

    private void setUpEmbeddedHadoop2() throws Exception {
        if (dfsCluster != null && dfsCluster2 == null) {
            String testBuildDataSaved = System.getProperty("test.build.data", "build/test/data");
            try {
                System.setProperty("test.build.data", FilenameUtils.concat((String)testBuildDataSaved, (String)"2"));
                dfsCluster2 = new MiniDFSCluster((Configuration)this.createDFSConfig(), 2, true, null);
                DistributedFileSystem fileSystem = dfsCluster2.getFileSystem();
                fileSystem.mkdirs(new Path("target/test-data"));
                fileSystem.mkdirs(new Path("/user"));
                fileSystem.mkdirs(new Path("/tmp"));
                fileSystem.setPermission(new Path("target/test-data"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("/user"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                fileSystem.setPermission(new Path("/tmp"), FsPermission.valueOf((String)"-rwxrwxrwx"));
                System.setProperty(OOZIE_TEST_NAME_NODE2, fileSystem.getConf().get("fs.default.name"));
            }
            catch (Exception ex) {
                XTestCase.shutdownMiniCluster2();
                throw ex;
            }
            finally {
                System.setProperty("test.build.data", testBuildDataSaved);
            }
        }
    }

    private JobConf createDFSConfig() throws UnknownHostException {
        JobConf conf = new JobConf();
        conf.set("dfs.block.access.token.enable", "false");
        conf.set("dfs.permissions", "true");
        conf.set("hadoop.security.authentication", "simple");
        StringBuilder sb = new StringBuilder();
        sb.append("127.0.0.1,localhost");
        for (InetAddress i : InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())) {
            sb.append(",").append(i.getCanonicalHostName());
        }
        conf.set("hadoop.proxyuser." + XTestCase.getOozieUser() + ".hosts", sb.toString());
        conf.set("hadoop.proxyuser." + XTestCase.getOozieUser() + ".groups", XTestCase.getTestGroup());
        conf.set("mapred.tasktracker.map.tasks.maximum", "4");
        conf.set("mapred.tasktracker.reduce.tasks.maximum", "4");
        conf.set("hadoop.tmp.dir", "target/test-data/minicluster");
        conf.set("yarn.nodemanager.disk-health-checker.max-disk-utilization-per-disk-percentage", "99");
        this.configureYarnACL(conf);
        return conf;
    }

    private void configureYarnACL(JobConf conf) {
        conf.set("yarn.acl.enable", "true");
        conf.set("yarn.admin.acl", XTestCase.getOozieUser());
        String schedClass = conf.get("yarn.resourcemanager.scheduler.class");
        if (schedClass.contains(FairScheduler.class.getName())) {
            conf.set("yarn.scheduler.fair.allocation.file", "fair-scheduler-alloc.xml");
        } else {
            conf.set("yarn.scheduler.capacity.root.acl_administer_queue", XTestCase.getOozieUser());
            conf.set("yarn.scheduler.capacity.root.default.acl_administer_queue", XTestCase.getOozieUser());
            conf.set("yarn.scheduler.capacity.root.queues", "default,default1");
            conf.set("yarn.scheduler.capacity.root.default.capacity", "50");
            conf.set("yarn.scheduler.capacity.root.default1.capacity", "50");
            conf.set("yarn.scheduler.capacity.maximum-am-resource-percent", "0.5");
        }
    }

    protected void setupHCatalogServer() throws Exception {
        if (hcatServer == null) {
            hcatServer = new MiniHCatServer(MiniHCatServer.RUNMODE.SERVER, (Configuration)this.createJobConf());
            hcatServer.start();
            this.log.info((Object)("Metastore server started at " + hcatServer.getMetastoreURI()));
        }
    }

    protected void tearDownHCatalogServer() throws Exception {
    }

    protected void setupHiveServer2() throws Exception {
        if (hiveserver2 == null) {
            this.setSystemProperty("test.tmp.dir", this.getTestCaseDir());
            if (hs2Config == null) {
                hs2Config = new HiveConf();
                JobConf jobConf = this.createJobConf();
                for (Map.Entry pair : jobConf) {
                    hs2Config.set((String)pair.getKey(), (String)pair.getValue());
                }
            }
            hiveserver2 = new MiniHS2(hs2Config, (FileSystem)dfsCluster.getFileSystem());
            hiveserver2.start(new HashMap<String, String>());
            this.log.info((Object)("Hive Server 2 started at " + hiveserver2.getJdbcURL()));
        }
    }

    protected void tearDownHiveServer2() {
        if (hiveserver2 != null && hiveserver2.isStarted()) {
            hiveserver2.stop();
            hiveserver2 = null;
            this.log.info((Object)"Hive Server 2 shutdown");
        }
    }

    protected String getHiveServer2JdbcURL() {
        return hiveserver2.getJdbcURL();
    }

    protected String getHiveServer2JdbcURL(String dbName) {
        return hiveserver2.getJdbcURL(dbName);
    }

    private static void shutdownMiniCluster() {
        try {
            if (mrCluster != null) {
                mrCluster.shutdown();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        try {
            if (dfsCluster != null) {
                dfsCluster.shutdown();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        hs2Config = null;
    }

    private static void shutdownMiniCluster2() {
        try {
            if (dfsCluster2 != null) {
                dfsCluster2.shutdown();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private JobConf createJobConfFromMRCluster() {
        JobConf jobConf = new JobConf();
        JobConf jobConfMR = mrCluster.createJobConf();
        for (Map.Entry entry : jobConfMR) {
            if (((String)entry.getKey()).equals("mapreduce.job.jar") || ((String)entry.getKey()).equals("mapred.jar")) continue;
            jobConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return jobConf;
    }

    protected JobConf createJobConf() throws IOException {
        JobConf jobConf;
        if (mrCluster != null) {
            jobConf = this.createJobConfFromMRCluster();
        } else {
            jobConf = new JobConf();
            jobConf.set("mapred.job.tracker", this.getJobTrackerUri());
            jobConf.set("fs.default.name", this.getNameNodeUri());
        }
        return jobConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeWhileJobTrackerIsShutdown(ShutdownJobTrackerExecutable executable) {
        mrCluster.stopJobTracker();
        Exception ex = null;
        try {
            executable.execute();
        }
        catch (Exception e) {
            ex = e;
        }
        finally {
            mrCluster.startJobTracker();
        }
        if (ex != null) {
            throw new RuntimeException(ex);
        }
    }

    protected Services setupServicesForHCatalog() throws ServiceException {
        Services services = new Services();
        this.setupServicesForHCataLogImpl(services);
        return services;
    }

    private void setupServicesForHCataLogImpl(Services services) {
        Configuration conf = services.getConf();
        conf.set("oozie.services.ext", JMSAccessorService.class.getName() + "," + PartitionDependencyManagerService.class.getName() + "," + HCatAccessorService.class.getName());
        conf.set("oozie.service.HCatAccessorService.jmsconnections", "default=java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=falseconnectionFactoryNames#ConnectionFactory");
        conf.set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        this.setSystemProperty("java.naming.factory.initial", ActiveMQConnFactory);
        this.setSystemProperty("java.naming.provider.url", localActiveMQBroker);
    }

    protected Services setupServicesForHCatalog(Services services) throws ServiceException {
        this.setupServicesForHCataLogImpl(services);
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected YarnApplicationState waitUntilYarnAppState(String externalId, final EnumSet<YarnApplicationState> acceptedStates) throws HadoopAccessorException, IOException, YarnException {
        final ApplicationId appId = ConverterUtils.toApplicationId((String)externalId);
        final MutableObject finalState = new MutableObject();
        Configuration conf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createConfiguration(this.getJobTrackerUri());
        try (final YarnClient yarnClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createYarnClient(XTestCase.getTestUser(), conf);){
            this.waitFor(60000, new Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    YarnApplicationState state = yarnClient.getApplicationReport(appId).getYarnApplicationState();
                    finalState.setValue((Object)state);
                    return acceptedStates.contains(state);
                }
            });
        }
        this.log.info("Final state is: {0}", new Object[]{finalState.getValue()});
        return (YarnApplicationState)finalState.getValue();
    }

    protected void waitUntilYarnAppDoneAndAssertSuccess(String externalId) throws HadoopAccessorException, IOException, YarnException {
        YarnApplicationState state = this.waitUntilYarnAppState(externalId, YARN_TERMINAL_STATES);
        XTestCase.assertEquals((String)("YARN App state for app " + externalId), (Object)YarnApplicationState.FINISHED, (Object)state);
    }

    protected void waitUntilYarnAppKilledAndAssertSuccess(String externalId) throws HadoopAccessorException, IOException, YarnException {
        YarnApplicationState state = this.waitUntilYarnAppState(externalId, YARN_TERMINAL_STATES);
        XTestCase.assertEquals((String)("YARN App state for app " + externalId), (Object)YarnApplicationState.KILLED, (Object)state);
    }

    public TestLogAppender getTestLogAppender() {
        return new TestLogAppender();
    }

    static {
        try {
            File file;
            OOZIE_SRC_DIR = new File("core").getAbsoluteFile();
            if (!OOZIE_SRC_DIR.exists()) {
                OOZIE_SRC_DIR = OOZIE_SRC_DIR.getParentFile().getParentFile();
                OOZIE_SRC_DIR = new File(OOZIE_SRC_DIR, "core");
            }
            if (!OOZIE_SRC_DIR.exists()) {
                OOZIE_SRC_DIR = OOZIE_SRC_DIR.getParentFile().getParentFile();
                OOZIE_SRC_DIR = new File(OOZIE_SRC_DIR, "core");
            }
            OOZIE_SRC_DIR = !OOZIE_SRC_DIR.exists() ? new File(".") : OOZIE_SRC_DIR.getParentFile();
            String testPropsFile = System.getProperty(OOZIE_TEST_PROPERTIES, "test.properties");
            File file2 = file = new File(testPropsFile).isAbsolute() ? new File(testPropsFile) : new File(OOZIE_SRC_DIR, testPropsFile);
            if (file.exists()) {
                System.out.println();
                System.out.println("*********************************************************************************");
                System.out.println("Loading test system properties from: " + file.getAbsolutePath());
                System.out.println();
                Properties props = new Properties();
                props.load(new FileReader(file));
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    if (!System.getProperties().containsKey(entry.getKey())) {
                        System.setProperty((String)entry.getKey(), (String)entry.getValue());
                        System.out.println(entry.getKey() + " = " + entry.getValue());
                        continue;
                    }
                    System.out.println(entry.getKey() + " IGNORED, using command line value = " + System.getProperty((String)entry.getKey()));
                }
                System.out.println("*********************************************************************************");
                System.out.println();
            } else if (System.getProperty(OOZIE_TEST_PROPERTIES) != null) {
                System.err.println();
                System.err.println("ERROR: Specified test file does not exist: " + System.getProperty(OOZIE_TEST_PROPERTIES));
                System.err.println();
                System.exit(-1);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        SHELL_COMMAND_NAME = Shell.WINDOWS ? "cmd" : "bash";
        SHELL_COMMAND_SCRIPTFILE_EXTENSION = Shell.WINDOWS ? "cmd" : "sh";
        SHELL_COMMAND_SCRIPTFILE_OPTION = Shell.WINDOWS ? "/c" : "-c";
        MINIMAL_SERVICES_FOR_DB_CLEANUP = JPAService.class.getName() + "," + StoreService.class.getName();
        dfsCluster = null;
        dfsCluster2 = null;
        mrCluster = null;
        hcatServer = null;
        hiveserver2 = null;
        hs2Config = null;
        LAST_TESTCASE_FINISHED = new AtomicLong();
        RUNNING_TESTCASES = new AtomicInteger();
    }

    protected class TestLogAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

        protected TestLogAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent loggingEvent) {
            this.log.add(loggingEvent);
        }

        public void close() {
        }

        public List<LoggingEvent> getLog() {
            return new ArrayList<LoggingEvent>(this.log);
        }
    }

    public static interface ShutdownJobTrackerExecutable {
        public void execute() throws Exception;
    }

    private static class MiniClusterShutdownMonitor
    extends Thread {
        public MiniClusterShutdownMonitor() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long shutdownWait = Long.parseLong(System.getProperty(XTestCase.TEST_MINICLUSTER_MONITOR_SHUTDOWN_WAIT, "10")) * 1000L;
            LAST_TESTCASE_FINISHED.set(System.currentTimeMillis());
            while (RUNNING_TESTCASES.get() != 0 || System.currentTimeMillis() - LAST_TESTCASE_FINISHED.get() <= shutdownWait) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            XTestCase.shutdownMiniCluster();
            XTestCase.shutdownMiniCluster2();
        }
    }

    public static interface Predicate {
        public boolean evaluate() throws Exception;
    }
}

