/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test.hive;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;

public abstract class AbstractHiveService {
    private HiveConf hiveConf = null;
    private String hostname;
    private int binaryPort;
    private int httpPort;
    private boolean startedHiveService = false;
    private List<String> addedProperties = new ArrayList<String>();

    public AbstractHiveService(HiveConf hiveConf, String hostname, int binaryPort, int httpPort) {
        this.hiveConf = hiveConf;
        this.hostname = hostname;
        this.binaryPort = binaryPort;
        this.httpPort = httpPort;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public String getConfProperty(String propertyKey) {
        return this.hiveConf.get(propertyKey);
    }

    public void setConfProperty(String propertyKey, String propertyValue) {
        System.setProperty(propertyKey, propertyValue);
        this.hiveConf.set(propertyKey, propertyValue);
        this.addedProperties.add(propertyKey);
    }

    public void clearProperties() {
        for (String propKey : this.addedProperties) {
            System.clearProperty(propKey);
        }
    }

    public Path getWareHouseDir() {
        return new Path(this.hiveConf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE));
    }

    public void setWareHouseDir(String wareHouseURI) {
        this.verifyNotStarted();
        System.setProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, wareHouseURI);
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, wareHouseURI);
    }

    public void setHost(String hostName) {
        this.hostname = hostName;
    }

    protected String getHost() {
        return this.hostname;
    }

    public void setBinaryPort(int portNum) {
        this.binaryPort = portNum;
    }

    public void setHttpPort(int portNum) {
        this.httpPort = portNum;
    }

    protected int getBinaryPort() {
        return this.binaryPort;
    }

    protected int getHttpPort() {
        return this.httpPort;
    }

    public boolean isStarted() {
        return this.startedHiveService;
    }

    protected void setStarted(boolean hiveServiceStatus) {
        this.startedHiveService = hiveServiceStatus;
    }

    protected void verifyStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("HiveServer2 is not running");
        }
    }

    protected void verifyNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("HiveServer2 already running");
        }
    }
}

