/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.ClasspathUtils;

public class TestClasspathUtils
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ClasspathUtils.setUsingMiniYarnCluster((boolean)false);
    }

    @Override
    protected void tearDown() throws Exception {
        ClasspathUtils.setUsingMiniYarnCluster((boolean)true);
        super.tearDown();
    }

    public void testSetupClasspath() throws Exception {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        Path p1 = new Path(this.getFsTestCaseDir(), "foo.xml");
        this.getFileSystem().createNewFile(p1);
        DistributedCache.addFileToClassPath((Path)p1, (Configuration)conf);
        Path p2 = new Path(this.getFsTestCaseDir(), "foo.txt");
        this.getFileSystem().createNewFile(p2);
        DistributedCache.addFileToClassPath((Path)p2, (Configuration)conf);
        Path p3 = new Path(this.getFsTestCaseDir(), "foo.zip");
        this.getFileSystem().createNewFile(p3);
        DistributedCache.addArchiveToClassPath((Path)p3, (Configuration)conf);
        ClasspathUtils.setupClasspath(env, (Configuration)conf);
        TestClasspathUtils.assertEquals((int)2, (int)env.size());
        TestClasspathUtils.assertTrue((boolean)env.containsKey("CLASSPATH"));
        Object[] paths = ((String)env.get("CLASSPATH")).split(":");
        TestClasspathUtils.assertEquals((int)9, (int)paths.length);
        Arrays.sort(paths);
        TestClasspathUtils.assertEquals((String)"$HADOOP_COMMON_HOME/share/hadoop/common/*", (String)paths[0]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_COMMON_HOME/share/hadoop/common/lib/*", (String)paths[1]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_CONF_DIR", (String)paths[2]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_HDFS_HOME/share/hadoop/hdfs/*", (String)paths[3]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_HDFS_HOME/share/hadoop/hdfs/lib/*", (String)paths[4]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_YARN_HOME/share/hadoop/yarn/*", (String)paths[5]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_YARN_HOME/share/hadoop/yarn/lib/*", (String)paths[6]);
        TestClasspathUtils.assertEquals((String)"$PWD", (String)paths[7]);
        TestClasspathUtils.assertEquals((String)"$PWD/*", (String)paths[8]);
        TestClasspathUtils.assertTrue((boolean)env.containsKey("$PWD"));
        paths = ((String)env.get("$PWD")).split(":");
        TestClasspathUtils.assertEquals((int)3, (int)paths.length);
        Arrays.sort(paths);
        TestClasspathUtils.assertEquals((String)"$PWD/foo.txt", (String)paths[0]);
        TestClasspathUtils.assertEquals((String)"$PWD/foo.xml", (String)paths[1]);
        TestClasspathUtils.assertEquals((String)"$PWD/foo.zip", (String)paths[2]);
    }

    public void testAddMapReduceToClasspath() throws Exception {
        Configuration conf = new Configuration(false);
        HashMap env = new HashMap();
        ClasspathUtils.addMapReduceToClasspath(env, (Configuration)conf);
        TestClasspathUtils.assertEquals((int)1, (int)env.size());
        TestClasspathUtils.assertTrue((boolean)env.containsKey("CLASSPATH"));
        Object[] paths = ((String)env.get("CLASSPATH")).split(":");
        TestClasspathUtils.assertEquals((int)2, (int)paths.length);
        Arrays.sort(paths);
        TestClasspathUtils.assertEquals((String)"$HADOOP_MAPRED_HOME/share/hadoop/mapreduce/*", (String)paths[0]);
        TestClasspathUtils.assertEquals((String)"$HADOOP_MAPRED_HOME/share/hadoop/mapreduce/lib/*", (String)paths[1]);
    }
}

