/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtils {
    @After
    public void resetToUTC() {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "UTC");
        DateUtils.setConf((Configuration)conf);
    }

    @Test
    public void testOozieInUTC() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "UTC");
        DateUtils.setConf((Configuration)conf);
        String s1 = "2012-08-08T12:42Z";
        Date d = DateUtils.parseDateOozieTZ((String)s1);
        Assert.assertNotNull((Object)d);
        String s2 = DateUtils.formatDateOozieTZ((Date)d);
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test
    public void testOozieInOtherTZ() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "GMT-0300");
        DateUtils.setConf((Configuration)conf);
        String s1 = "2012-08-08T12:42-0300";
        Date d = DateUtils.parseDateOozieTZ((String)s1);
        Assert.assertNotNull((Object)d);
        String s2 = DateUtils.formatDateOozieTZ((Date)d);
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    @Test(expected=ParseException.class)
    public void testOozieInOtherTZIncorrectOffset() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "GMT-0300");
        DateUtils.setConf((Configuration)conf);
        String s1 = "2012-08-08T12:42-0400";
        DateUtils.parseDateOozieTZ((String)s1);
    }

    @Test(expected=ParseException.class)
    public void testOozieInOtherTZInvalidOffset() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "GMT-0300");
        DateUtils.setConf((Configuration)conf);
        String s1 = "2012-08-08T12:42-0300x";
        DateUtils.parseDateOozieTZ((String)s1);
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidOozieTimeZone() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "US/Los Angeles");
        DateUtils.setConf((Configuration)conf);
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidOozieTimeZoneGMTPrefix() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "xGMT-0300");
        DateUtils.setConf((Configuration)conf);
    }

    @Test(expected=RuntimeException.class)
    public void testInvalidOozieTimeZoneGMTPostfix() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.processing.timezone", "GMT-0300x");
        DateUtils.setConf((Configuration)conf);
    }

    @Test
    public void testGetTimeZoneValidFormats() throws Exception {
        Assert.assertEquals((Object)TimeZone.getTimeZone("America/Los_Angeles"), (Object)DateUtils.getTimeZone((String)"America/Los_Angeles"));
        Assert.assertEquals((Object)TimeZone.getTimeZone("PST"), (Object)DateUtils.getTimeZone((String)"PST"));
        Assert.assertEquals((Object)TimeZone.getTimeZone("GMT"), (Object)DateUtils.getTimeZone((String)"GMT"));
        TimeZone GMTOffsetColon = TimeZone.getTimeZone("GMT-07:00");
        TimeZone GMTOffsetNoColon = TimeZone.getTimeZone("GMT-0700");
        TimeZone oozieGMTOffsetColon = DateUtils.getTimeZone((String)"GMT-07:00");
        TimeZone oozieGMTOffsetNoColon = DateUtils.getTimeZone((String)"GMT-0700");
        Assert.assertEquals((Object)GMTOffsetColon, (Object)GMTOffsetNoColon);
        Assert.assertEquals((Object)GMTOffsetNoColon, (Object)oozieGMTOffsetColon);
        Assert.assertEquals((Object)oozieGMTOffsetColon, (Object)oozieGMTOffsetNoColon);
        Assert.assertFalse((boolean)TimeZone.getTimeZone("GMT").equals(oozieGMTOffsetNoColon));
        GMTOffsetColon = TimeZone.getTimeZone("GMT+05:30");
        GMTOffsetNoColon = TimeZone.getTimeZone("GMT+0530");
        oozieGMTOffsetColon = DateUtils.getTimeZone((String)"GMT+05:30");
        oozieGMTOffsetNoColon = DateUtils.getTimeZone((String)"GMT+0530");
        Assert.assertEquals((Object)GMTOffsetColon, (Object)GMTOffsetNoColon);
        Assert.assertEquals((Object)GMTOffsetNoColon, (Object)oozieGMTOffsetColon);
        Assert.assertEquals((Object)oozieGMTOffsetColon, (Object)oozieGMTOffsetNoColon);
        Assert.assertFalse((boolean)TimeZone.getTimeZone("GMT").equals(oozieGMTOffsetNoColon));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTimeZoneInvalidFormat() throws Exception {
        DateUtils.getTimeZone((String)"This_is_not_a_TimeZone_id");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTimeZoneInvalidFormatNull() throws Exception {
        DateUtils.getTimeZone(null);
    }
}

