/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ELConstantsFunctions;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class TestELConstantsFunctions
extends XTestCase {
    public void testTrim() {
        TestELConstantsFunctions.assertEquals((String)"", (String)ELConstantsFunctions.trim(null));
        TestELConstantsFunctions.assertEquals((String)"a", (String)ELConstantsFunctions.trim((String)" a "));
    }

    public void testConcat() {
        TestELConstantsFunctions.assertEquals((String)"a", (String)ELConstantsFunctions.concat((String)"a", null));
        TestELConstantsFunctions.assertEquals((String)"b", (String)ELConstantsFunctions.concat(null, (String)"b"));
        TestELConstantsFunctions.assertEquals((String)"ab", (String)ELConstantsFunctions.concat((String)"a", (String)"b"));
        TestELConstantsFunctions.assertEquals((String)"", (String)ELConstantsFunctions.concat(null, null));
    }

    public void testReplaceAll() {
        TestELConstantsFunctions.assertEquals((String)"aefefd", (String)ELConstantsFunctions.replaceAll((String)"abcbcd", (String)"bc", (String)"ef"));
        TestELConstantsFunctions.assertEquals((String)"d1 d2 d3", (String)ELConstantsFunctions.replaceAll((String)"d1,d2,d3", (String)",", (String)" "));
        TestELConstantsFunctions.assertEquals((String)"ayyycd", (String)ELConstantsFunctions.replaceAll((String)"abcbcd", (String)"bcb", (String)"yyy"));
        TestELConstantsFunctions.assertEquals((String)"acd", (String)ELConstantsFunctions.replaceAll((String)"abcbcd", (String)"bcb", (String)""));
        TestELConstantsFunctions.assertEquals(null, (String)ELConstantsFunctions.replaceAll(null, (String)"bcb", (String)"yyy"));
        TestELConstantsFunctions.assertEquals((String)"abcbcd", (String)ELConstantsFunctions.replaceAll((String)"abcbcd", null, (String)"XYZ"));
        TestELConstantsFunctions.assertEquals((String)"acd", (String)ELConstantsFunctions.replaceAll((String)"abcbcd", (String)"bcb", null));
    }

    public void testAppendAll() {
        TestELConstantsFunctions.assertEquals((String)"/a/b/ADD,/c/b/ADD,/c/d/ADD", (String)ELConstantsFunctions.appendAll((String)"/a/b/,/c/b/,/c/d/", (String)"ADD", (String)","));
        TestELConstantsFunctions.assertEquals((String)"/a/b/ADD", (String)ELConstantsFunctions.appendAll((String)"/a/b/", (String)"ADD", (String)","));
        TestELConstantsFunctions.assertEquals((String)" /a/b/  ADD,/c/b/ ADD, /c/d/ ADD", (String)ELConstantsFunctions.appendAll((String)" /a/b/  ,/c/b/ , /c/d/ ", (String)"ADD", (String)","));
        TestELConstantsFunctions.assertEquals((String)"/a/b/ADD", (String)ELConstantsFunctions.appendAll((String)"/a/b/", (String)"ADD", (String)","));
        TestELConstantsFunctions.assertEquals(null, (String)ELConstantsFunctions.appendAll(null, (String)"ADD", (String)","));
        TestELConstantsFunctions.assertEquals((String)"/a/b/,/c/b/,/c/d/", (String)ELConstantsFunctions.appendAll((String)"/a/b/,/c/b/,/c/d/", null, (String)","));
        TestELConstantsFunctions.assertEquals((String)"/a/b/,/c/b/,/c/d/", (String)ELConstantsFunctions.appendAll((String)"/a/b/,/c/b/,/c/d/", (String)"ADD", null));
        TestELConstantsFunctions.assertEquals((String)"ADDaADDbADD", (String)ELConstantsFunctions.appendAll((String)"ab", (String)"ADD", (String)""));
        TestELConstantsFunctions.assertEquals((String)"/a/b/ADD,/c/b/ADD,/c/d/ADD", (String)ELConstantsFunctions.appendAll((String)"/a/b/,/c/b/,/c/d/", (String)"ADD", (String)","));
    }

    public void testTimestamp() throws Exception {
        String s = ELConstantsFunctions.timestamp();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        TestELConstantsFunctions.assertNotNull((Object)sdf.parse(s));
    }

    public void testUrlEncode() {
        TestELConstantsFunctions.assertEquals((String)"+", (String)ELConstantsFunctions.urlEncode((String)" "));
        TestELConstantsFunctions.assertEquals((String)"%25", (String)ELConstantsFunctions.urlEncode((String)"%"));
    }

    public void testToJsonStr() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "A");
        map.put("b", "&");
        String str = ELConstantsFunctions.toJsonStr(map);
        Element e = XmlUtils.parseXml((String)("<x>" + str + "</x>"));
        JSONObject json = (JSONObject)new JSONParser().parse(e.getText());
        HashMap map2 = new HashMap(json);
        TestELConstantsFunctions.assertEquals(map, map2);
    }

    public void testToPropertiesStr() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "A");
        map.put("b", "&");
        String str = ELConstantsFunctions.toPropertiesStr(map);
        Element e = XmlUtils.parseXml((String)("<x>" + str + "</x>"));
        Properties map2 = PropertiesUtils.stringToProperties((String)e.getText());
        TestELConstantsFunctions.assertEquals(map, (Object)map2);
    }

    public void testToConfigurationStr() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("a", "A");
        map.put("b", "&");
        String str = ELConstantsFunctions.toConfigurationStr(map);
        Element e = XmlUtils.parseXml((String)("<x>" + str + "</x>"));
        XConfiguration conf = new XConfiguration((Reader)new StringReader(e.getText()));
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry entry : conf) {
            map2.put((String)entry.getKey(), (String)entry.getValue());
        }
        TestELConstantsFunctions.assertEquals(map, map2);
    }
}

