/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.net.URI;
import java.util.regex.Pattern;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.HCatURIParser;

public class TestHCatURIParser
extends XTestCase {
    private Services services;
    private Pattern HCAT_URI_PATTERN;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        String HCAT_URI_REGEX_CONFIG = ConfigurationService.get((String)"oozie.hcat.uri.regex.pattern");
        this.HCAT_URI_PATTERN = Pattern.compile(HCAT_URI_REGEX_CONFIG);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.services.destroy();
    }

    public void testWhenMultipleHCatURIsAreSplitPartsAreExtractedCorrectly1() {
        String uri = "hcat://hostname1:1000,hcat://hostname2:2000/mydb/clicks/datastamp=12;region=us,scheme://hostname3:3000,scheme://hostname4:4000,scheme://hostname5:5000/db/table/p1=12;p2=us,scheme://hostname4:4000/d/t/p=1";
        String[] uris = HCatURIParser.splitHCatUris((String)uri, (Pattern)this.HCAT_URI_PATTERN);
        TestHCatURIParser.assertEquals((int)3, (int)uris.length);
        TestHCatURIParser.assertEquals((String)"hcat://hostname1:1000,hcat://hostname2:2000/mydb/clicks/datastamp=12;region=us", (String)uris[0]);
        TestHCatURIParser.assertEquals((String)"scheme://hostname3:3000,scheme://hostname4:4000,scheme://hostname5:5000/db/table/p1=12;p2=us", (String)uris[1]);
        TestHCatURIParser.assertEquals((String)"scheme://hostname4:4000/d/t/p=1", (String)uris[2]);
    }

    public void testWhenMultipleHCatURIsAreSplitPartsAreExtractedCorrectly2() {
        String uri = "thrift://host.name1:1000/mydb/clicks/datastamp=12;region=u_s";
        String[] uris = HCatURIParser.splitHCatUris((String)uri, (Pattern)this.HCAT_URI_PATTERN);
        TestHCatURIParser.assertEquals((int)1, (int)uris.length);
        TestHCatURIParser.assertEquals((String)"thrift://host.name1:1000/mydb/clicks/datastamp=12;region=u_s", (String)uris[0]);
    }

    public void testWhenMultipleHCatURIsAreSplitPartsAreExtractedCorrectly3() {
        String uri = "hcat://10.10.10.10:9083/default/invites/ds=2010-01-01;region=usa";
        String[] uris = HCatURIParser.splitHCatUris((String)uri, (Pattern)this.HCAT_URI_PATTERN);
        TestHCatURIParser.assertEquals((int)1, (int)uris.length);
        TestHCatURIParser.assertEquals((String)"hcat://10.10.10.10:9083/default/invites/ds=2010-01-01;region=usa", (String)uris[0]);
    }

    public void testParsingMultipleHCatServerURI() throws Exception {
        String uriStr = "hcat://hcat.server.com:5080,hcat://hcat.server1.com:5080/mydb/clicks/datastamp=12;region=us";
        String[] uris = HCatURIParser.splitHCatUris((String)uriStr, (Pattern)this.HCAT_URI_PATTERN);
        URI uri = HCatURIParser.parseURI((URI)new URI(uris[0]));
        TestHCatURIParser.assertEquals((String)"hcat", (String)uri.getScheme());
        TestHCatURIParser.assertEquals((String)"hcat.server.com:5080,hcat.server1.com:5080", (String)uri.getAuthority());
    }

    public void testParsingSingleServerURI() throws Exception {
        String uriStr = "hdfs://namenode.example.com:8020/path/to/directory/file";
        URI uri = HCatURIParser.parseURI((URI)new URI(uriStr));
        TestHCatURIParser.assertEquals((String)"hdfs", (String)uri.getScheme());
        TestHCatURIParser.assertEquals((String)"namenode.example.com:8020", (String)uri.getAuthority());
        TestHCatURIParser.assertEquals((String)"/path/to/directory/file", (String)uri.getPath());
    }
}

