/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import org.apache.oozie.util.IOUtils;
import org.junit.Test;

public class TestIOUtils {
    @Test
    public void testGetReaderAsString() throws IOException {
        try {
            IOUtils.getReaderAsString((Reader)new StringReader("1234"), (int)2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"1234", (String)IOUtils.getReaderAsString((Reader)new StringReader("1234"), (int)4));
    }

    @Test
    public void testGetResourceAsString() throws IOException {
        try {
            IOUtils.getResourceAsString((String)"invalid-resource.txt", (int)2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String s = IOUtils.getResourceAsString((String)"test-ioutils.txt", (int)10);
        Assert.assertEquals((String)"abcde", (String)s);
        try {
            IOUtils.getResourceAsString((String)"test-ioutils.txt", (int)2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetResourceAsReader() throws IOException {
        IOUtils.getResourceAsReader((String)"test-ioutils.txt", (int)10);
    }

    @Test
    public void testCopyStream() throws IOException {
        byte[] original = new byte[]{0, 1, 2};
        ByteArrayInputStream is = new ByteArrayInputStream(original);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        byte[] copy = os.toByteArray();
        Assert.assertEquals((int)3, (int)copy.length);
        Assert.assertEquals((int)original.length, (int)copy.length);
        for (int i = 0; i < original.length; ++i) {
            Assert.assertEquals((byte)original[i], (byte)copy[i]);
        }
    }
}

