/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.Instrumentation;

public class TestInstrumentation
extends XTestCase {
    private static final long INTERVAL = 300L;
    private static final long TOLERANCE = 30L;

    public void testCron() throws Exception {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        long start = System.currentTimeMillis();
        TestInstrumentation.assertEquals((String)"", (float)0.0f, (float)cron.getStart(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)0.0f, (float)cron.getEnd(), (float)30.0f);
        TestInstrumentation.assertEquals((long)cron.getStart(), (long)cron.getEnd());
        TestInstrumentation.assertEquals((long)0L, (long)cron.getOwn());
        TestInstrumentation.assertEquals((long)0L, (long)cron.getTotal());
        cron.start();
        long s = System.currentTimeMillis();
        Thread.sleep(300L);
        cron.stop();
        long realOwnDelay = System.currentTimeMillis() - s;
        long now = System.currentTimeMillis();
        TestInstrumentation.assertEquals((String)"", (float)start, (float)cron.getStart(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)now, (float)cron.getEnd(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)300.0f, (float)cron.getTotal(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)300.0f, (float)cron.getOwn(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)cron.getTotal(), (float)cron.getOwn(), (float)30.0f);
        long realTotalDelay = System.currentTimeMillis() - s;
        s = System.currentTimeMillis();
        Thread.sleep(300L);
        cron.start();
        realTotalDelay += System.currentTimeMillis() - s;
        s = System.currentTimeMillis();
        Thread.sleep(300L);
        cron.stop();
        now = System.currentTimeMillis();
        TestInstrumentation.assertEquals((String)"", (float)start, (float)cron.getStart(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)now, (float)cron.getEnd(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)(realTotalDelay += System.currentTimeMillis() - s), (float)cron.getTotal(), (float)30.0f);
        TestInstrumentation.assertEquals((String)"", (float)(realOwnDelay += System.currentTimeMillis() - s), (float)cron.getOwn(), (float)30.0f);
    }

    public void testTimer() throws Exception {
        Instrumentation.Timer timer = new Instrumentation.Timer();
        TestInstrumentation.assertEquals((long)0L, (long)timer.getTicks());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getTotal());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getOwn());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getOwnAvg());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getTotalAvg());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getOwnSquareSum());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getTotalSquareSum());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getOwnMin());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getOwnMax());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getTotalMin());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getTotalMax());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getTicks());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getTotal());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getOwn());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getOwnAvg());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getTotalAvg());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getOwnSquareSum());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getTotalSquareSum());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getOwnMin());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getOwnMax());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getTotalMin());
        TestInstrumentation.assertEquals((long)0L, (long)timer.getValue().getTotalMax());
        Instrumentation.Cron cron1 = new Instrumentation.Cron();
        cron1.start();
        Thread.sleep(300L);
        cron1.stop();
        timer.addCron(cron1);
        TestInstrumentation.assertEquals((long)1L, (long)timer.getTicks());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getTotal());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getOwn());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getOwnAvg());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getTotalAvg());
        TestInstrumentation.assertEquals((long)(cron1.getOwn() * cron1.getOwn()), (long)timer.getOwnSquareSum());
        TestInstrumentation.assertEquals((long)(cron1.getTotal() * cron1.getTotal()), (long)timer.getTotalSquareSum());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getOwnMin());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getOwnMax());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getTotalMin());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getTotalMax());
        TestInstrumentation.assertEquals((long)1L, (long)timer.getValue().getTicks());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getValue().getTotal());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getValue().getOwn());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getValue().getOwnAvg());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getValue().getTotalAvg());
        TestInstrumentation.assertEquals((long)(cron1.getOwn() * cron1.getOwn()), (long)timer.getValue().getOwnSquareSum());
        TestInstrumentation.assertEquals((long)(cron1.getTotal() * cron1.getTotal()), (long)timer.getValue().getTotalSquareSum());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getValue().getOwnMin());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getValue().getOwnMax());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getValue().getTotalMin());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getValue().getTotalMax());
        Instrumentation.Cron cron2 = new Instrumentation.Cron();
        cron2.start();
        Thread.sleep(600L);
        cron2.stop();
        timer.addCron(cron2);
        TestInstrumentation.assertEquals((long)2L, (long)timer.getTicks());
        TestInstrumentation.assertEquals((long)(cron1.getTotal() + cron2.getTotal()), (long)timer.getTotal());
        TestInstrumentation.assertEquals((long)(cron1.getOwn() + cron2.getOwn()), (long)timer.getOwn());
        TestInstrumentation.assertEquals((long)((cron1.getOwn() + cron2.getOwn()) / 2L), (long)timer.getOwnAvg());
        TestInstrumentation.assertEquals((long)((cron1.getTotal() + cron2.getTotal()) / 2L), (long)timer.getTotalAvg());
        TestInstrumentation.assertEquals((long)(cron1.getOwn() * cron1.getOwn() + cron2.getOwn() * cron2.getOwn()), (long)timer.getOwnSquareSum());
        TestInstrumentation.assertEquals((long)(cron1.getTotal() * cron1.getTotal() + cron2.getTotal() * cron2.getTotal()), (long)timer.getTotalSquareSum());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)timer.getOwnMin());
        TestInstrumentation.assertEquals((long)cron2.getOwn(), (long)timer.getOwnMax());
        TestInstrumentation.assertEquals((long)cron1.getTotal(), (long)timer.getTotalMin());
        TestInstrumentation.assertEquals((long)cron2.getTotal(), (long)timer.getTotalMax());
    }

    public void testInstrumentationCounter() throws Exception {
        Instrumentation inst = new Instrumentation();
        TestInstrumentation.assertEquals((int)0, (int)inst.getCounters().size());
        inst.incr("a", "1", 1L);
        TestInstrumentation.assertEquals((int)1, (int)inst.getCounters().size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getCounters().get("a")).size());
        inst.incr("a", "2", 2L);
        TestInstrumentation.assertEquals((int)1, (int)inst.getCounters().size());
        TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getCounters().get("a")).size());
        inst.incr("b", "1", 3L);
        TestInstrumentation.assertEquals((int)2, (int)inst.getCounters().size());
        TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getCounters().get("a")).size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getCounters().get("b")).size());
        TestInstrumentation.assertEquals((Object)new Long(1L), (Object)((Instrumentation.Element)((Map)inst.getCounters().get("a")).get("1")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(2L), (Object)((Instrumentation.Element)((Map)inst.getCounters().get("a")).get("2")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(3L), (Object)((Instrumentation.Element)((Map)inst.getCounters().get("b")).get("1")).getValue());
    }

    public void testInstrumentationTimer() throws Exception {
        Instrumentation inst = new Instrumentation();
        TestInstrumentation.assertEquals((int)0, (int)inst.getTimers().size());
        Instrumentation.Cron cron1 = new Instrumentation.Cron();
        inst.addCron("a", "1", cron1);
        TestInstrumentation.assertEquals((int)1, (int)inst.getTimers().size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getTimers().get("a")).size());
        Instrumentation.Cron cron2 = new Instrumentation.Cron();
        cron2.start();
        Thread.sleep(300L);
        cron2.stop();
        inst.addCron("a", "2", cron2);
        TestInstrumentation.assertEquals((int)1, (int)inst.getTimers().size());
        TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getTimers().get("a")).size());
        Instrumentation.Cron cron3 = new Instrumentation.Cron();
        cron3.start();
        Thread.sleep(600L);
        cron3.stop();
        inst.addCron("b", "1", cron3);
        TestInstrumentation.assertEquals((int)2, (int)inst.getTimers().size());
        TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getTimers().get("a")).size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getTimers().get("b")).size());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)((Instrumentation.Timer)((Instrumentation.Element)((Map)inst.getTimers().get("a")).get("1")).getValue()).getOwn());
        TestInstrumentation.assertEquals((long)cron2.getOwn(), (long)((Instrumentation.Timer)((Instrumentation.Element)((Map)inst.getTimers().get("a")).get("2")).getValue()).getOwn());
        TestInstrumentation.assertEquals((long)cron3.getOwn(), (long)((Instrumentation.Timer)((Instrumentation.Element)((Map)inst.getTimers().get("b")).get("1")).getValue()).getOwn());
    }

    public void testVariables() throws Exception {
        Instrumentation inst = new Instrumentation();
        inst.addVariable("a", "1", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 0L;

            public Long getValue() {
                return this.counter++;
            }
        });
        TestInstrumentation.assertEquals((int)1, (int)inst.getVariables().size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getVariables().get("a")).size());
        inst.addVariable("a", "2", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 1L;

            public Long getValue() {
                return this.counter++;
            }
        });
        TestInstrumentation.assertEquals((int)1, (int)inst.getVariables().size());
        TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getVariables().get("a")).size());
        inst.addVariable("b", "1", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 2L;

            public Long getValue() {
                return this.counter++;
            }
        });
        TestInstrumentation.assertEquals((int)2, (int)inst.getVariables().size());
        TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getVariables().get("a")).size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getVariables().get("b")).size());
        TestInstrumentation.assertEquals((Object)new Long(0L), (Object)((Instrumentation.Variable)((Map)inst.getVariables().get("a")).get("1")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(1L), (Object)((Instrumentation.Variable)((Map)inst.getVariables().get("a")).get("2")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(2L), (Object)((Instrumentation.Variable)((Map)inst.getVariables().get("b")).get("1")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(1L), (Object)((Instrumentation.Variable)((Map)inst.getVariables().get("a")).get("1")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(2L), (Object)((Instrumentation.Variable)((Map)inst.getVariables().get("a")).get("2")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(3L), (Object)((Instrumentation.Variable)((Map)inst.getVariables().get("b")).get("1")).getValue());
    }

    public void testSamplers() throws Exception {
        Instrumentation inst = new Instrumentation();
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
        try {
            inst.setScheduler((ScheduledExecutorService)scheduledExecutorService);
            inst.addSampler("a", "1", 10, 1, (Instrumentation.Variable)new Instrumentation.Variable<Long>(){

                public Long getValue() {
                    return 1L;
                }
            });
            TestInstrumentation.assertEquals((int)1, (int)inst.getSamplers().size());
            TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getSamplers().get("a")).size());
            inst.addSampler("a", "2", 10, 1, (Instrumentation.Variable)new Instrumentation.Variable<Long>(){

                public Long getValue() {
                    return 2L;
                }
            });
            TestInstrumentation.assertEquals((int)1, (int)inst.getSamplers().size());
            TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getSamplers().get("a")).size());
            inst.addSampler("b", "1", 10, 1, (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
                private long counter = 0L;

                public Long getValue() {
                    return this.counter++ % 10L;
                }
            });
            TestInstrumentation.assertEquals((int)2, (int)inst.getSamplers().size());
            TestInstrumentation.assertEquals((int)2, (int)((Map)inst.getSamplers().get("a")).size());
            TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getSamplers().get("b")).size());
            this.waitFor(20000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return false;
                }
            });
            TestInstrumentation.assertEquals((String)"", (double)1.0, (double)((Double)((Instrumentation.Element)((Map)inst.getSamplers().get("a")).get("1")).getValue()), (double)0.01);
            TestInstrumentation.assertEquals((String)"", (double)2.0, (double)((Double)((Instrumentation.Element)((Map)inst.getSamplers().get("a")).get("2")).getValue()), (double)0.02);
            TestInstrumentation.assertEquals((String)"", (double)4.0, (double)((Double)((Instrumentation.Element)((Map)inst.getSamplers().get("b")).get("1")).getValue()), (double)0.5);
        }
        finally {
            scheduledExecutorService.shutdownNow();
        }
    }

    public void testAll() throws Exception {
        Instrumentation inst = new Instrumentation();
        inst.addVariable("a", "1", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 0L;

            public Long getValue() {
                return this.counter++;
            }
        });
        inst.incr("a", "1", 1L);
        Instrumentation.Cron cron1 = new Instrumentation.Cron();
        inst.addCron("a", "1", cron1);
        TestInstrumentation.assertEquals((int)4, (int)inst.getAll().size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getAll().get("variables")).size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getAll().get("counters")).size());
        TestInstrumentation.assertEquals((int)1, (int)((Map)inst.getAll().get("timers")).size());
        TestInstrumentation.assertEquals((int)0, (int)((Map)inst.getAll().get("samplers")).size());
        TestInstrumentation.assertEquals((Object)new Long(0L), (Object)((Instrumentation.Element)((Map)((Map)inst.getAll().get("variables")).get("a")).get("1")).getValue());
        TestInstrumentation.assertEquals((Object)new Long(1L), (Object)((Instrumentation.Element)((Map)((Map)inst.getAll().get("counters")).get("a")).get("1")).getValue());
        TestInstrumentation.assertEquals((long)cron1.getOwn(), (long)((Instrumentation.Timer)((Instrumentation.Element)((Map)((Map)inst.getAll().get("timers")).get("a")).get("1")).getValue()).getOwn());
    }
}

