/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.JaasConfiguration;

public class TestJaasConfiguration
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test() throws Exception {
        String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        JaasConfiguration.clearEntries();
        TestJaasConfiguration.assertTrue((boolean)JaasConfiguration.getEntries().isEmpty());
        JaasConfiguration.addEntry((String)"foo", (String)"foo/localhost", (String)"/some/location/foo");
        TestJaasConfiguration.assertEquals((int)1, (int)JaasConfiguration.getEntries().size());
        JaasConfiguration.addEntry((String)"bar", (String)"bar/localhost", (String)"/some/location/bar");
        TestJaasConfiguration.assertEquals((int)2, (int)JaasConfiguration.getEntries().size());
        JaasConfiguration.addEntry((String)"zoo", (String)"zoo/localhost", (String)"/some/location/zoo");
        TestJaasConfiguration.assertEquals((int)3, (int)JaasConfiguration.getEntries().size());
        this.checkEntry(krb5LoginModuleName, "foo", "foo/localhost", "/some/location/foo");
        this.checkEntry(krb5LoginModuleName, "bar", "bar/localhost", "/some/location/bar");
        this.checkEntry(krb5LoginModuleName, "zoo", "zoo/localhost", "/some/location/zoo");
        JaasConfiguration.removeEntry((String)"bar");
        TestJaasConfiguration.assertEquals((int)2, (int)JaasConfiguration.getEntries().size());
        this.checkEntry(krb5LoginModuleName, "foo", "foo/localhost", "/some/location/foo");
        this.checkEntry(krb5LoginModuleName, "zoo", "zoo/localhost", "/some/location/zoo");
        JaasConfiguration.clearEntries();
        TestJaasConfiguration.assertTrue((boolean)JaasConfiguration.getEntries().isEmpty());
    }

    private void checkEntry(String loginModuleName, String name, String principal, String keytab) {
        AppConfigurationEntry entry = (AppConfigurationEntry)JaasConfiguration.getEntries().get(name);
        TestJaasConfiguration.assertEquals((String)loginModuleName, (String)entry.getLoginModuleName());
        TestJaasConfiguration.assertEquals((Object)AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Object)entry.getControlFlag());
        Map<String, ?> options = entry.getOptions();
        TestJaasConfiguration.assertEquals((Object)principal, options.get("principal"));
        if (loginModuleName.equals("com.ibm.security.auth.module.Krb5LoginModule")) {
            TestJaasConfiguration.assertEquals((Object)(keytab.startsWith("file://") ? keytab : "file://" + keytab), options.get("useKeytab"));
            TestJaasConfiguration.assertEquals((Object)"both", options.get("credsType"));
            TestJaasConfiguration.assertEquals((int)3, (int)options.size());
        } else {
            TestJaasConfiguration.assertEquals((Object)"true", options.get("useKeyTab"));
            TestJaasConfiguration.assertEquals((Object)keytab, options.get("keyTab"));
            TestJaasConfiguration.assertEquals((Object)"true", options.get("storeKey"));
            TestJaasConfiguration.assertEquals((Object)"false", options.get("useTicketCache"));
            TestJaasConfiguration.assertEquals((int)5, (int)options.size());
        }
    }
}

