/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XLogAuditStreamer;
import org.apache.oozie.util.XLogErrorStreamer;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;

public class TestLogStreamer
extends XTestCase {
    static String logStatement = " USER[oozie] GROUP[-] TOKEN[-] APP[-] JOB[14-200904160239--example-forkjoinwf] ACTION[-] ";
    String defaultLog4jFile;
    private static final SimpleDateFormat filenameDateFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");

    @Override
    protected void tearDown() throws Exception {
        if (null != this.defaultLog4jFile) {
            this.setSystemProperty("oozie.log4j.file", this.defaultLog4jFile);
        }
        super.tearDown();
    }

    public void testStreamLog() throws IOException, CommandException, ServiceException, ParseException {
        this.setupLog4j();
        new Services().init();
        long currTime = System.currentTimeMillis();
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        xf.setLogLevel("DEBUG|INFO");
        FileWriter fw1 = new FileWriter(this.getTestCaseDir() + "/oozie.log");
        StringBuilder sb1 = new StringBuilder();
        sb1.append("2009-06-24 02:43:13,958 DEBUG _L1_:323 -" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,961 INFO _L2_:317 -" + logStatement + "[org.apache.oozie.core.command.WorkflowRunnerCallable] released lock\n");
        fw1.write(sb1.toString());
        fw1.close();
        File f1 = new File(this.getTestCaseDir() + "/oozie.log");
        f1.setLastModified(currTime - 32400000L);
        FileWriter fw2 = new FileWriter(this.getTestCaseDir() + "/oozie.log.1");
        StringBuilder sb2 = new StringBuilder();
        sb2.append("2009-06-24 02:43:13,986 WARN _L3_:539 -" + logStatement + "Use GenericOptionsParser for parsing the arguments. \n_L3A_Applications should implement Tool for the same. \n_L3B_Multi line test\n");
        sb2.append("2009-06-24 02:43:14,431 INFO _L4_:661 -" + logStatement + "No job jar file set. User classes may not be found. See JobConf(Class) or JobConf#setJar(String).\n");
        fw2.write(sb2.toString());
        fw2.close();
        File f2 = new File(this.getTestCaseDir() + "/oozie.log.1");
        f2.setLastModified(currTime - 28800000L);
        FileWriter fw3 = new FileWriter(this.getTestCaseDir() + "/oozie.log.2");
        StringBuilder sb3 = new StringBuilder();
        sb3.append("2009-06-24 02:43:14,505 INFO _L5_:317 - USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock\n");
        sb3.append("2009-06-24 02:43:19,344 DEBUG _L6_:323 - USER[oozie] GROUP[oozie] TOKEN[MYtoken] APP[-] JOB[-] ACTION[-] Number of pending signals to check [0]\n");
        sb3.append("2009-06-24 02:43:29,151 DEBUG _L7_:323 -" + logStatement + "Number of pending actions [0] \n");
        fw3.write(sb3.toString());
        fw3.close();
        File f3 = new File(this.getTestCaseDir() + "/oozie.log.2");
        f3.setLastModified(currTime);
        FileWriter fwerr = new FileWriter(this.getTestCaseDir() + "/testerr.log");
        StringBuilder sberr = new StringBuilder();
        sberr.append("2009-06-24 02:43:13,958 WARN _L1_:323 -" + logStatement + "End workflow state change\n");
        sberr.append("2009-06-24 02:43:13,961 INFO _L2_:317 -" + logStatement + "[org.apache.oozie.core.command.WorkflowRunnerCallable] released lock\n");
        fwerr.write(sberr.toString());
        fwerr.close();
        File ferr = new File(this.getTestCaseDir() + "/testerr.log");
        ferr.setLastModified(currTime - 28800000L);
        String outFilename = "oozie.log-" + filenameDateFormatter.format(new Date(currTime - 21600000L)) + ".gz";
        File f = new File(this.getTestCaseDir() + "/" + outFilename);
        StringBuilder sb = new StringBuilder();
        sb.append("2009-06-24 02:43:13,958 DEBUG _L8_:323 -" + logStatement + "End workflow state change\n");
        sb.append("2009-06-24 02:43:13,961 INFO _L9_:317 -" + logStatement + "[org.apache.oozie.core.command.WorkflowRunnerCallable] released lock\n");
        TestLogStreamer.writeToGZFile(f, sb);
        outFilename = "oozie.log.gz";
        f = new File(this.getTestCaseDir() + "/" + outFilename);
        sb = new StringBuilder();
        sb.append("2009-06-24 02:43:13,958 DEBUG _L10_:323 -" + logStatement + "End workflow state change\n");
        sb.append("2009-06-24 02:43:13,961 INFO _L11_:317 -" + logStatement + "[org.apache.oozie.core.command.WorkflowRunnerCallable] released lock\n");
        TestLogStreamer.writeToGZFile(f, sb);
        outFilename = "oozie.log-2011-12-03-15.bz2.gz";
        f = new File(this.getTestCaseDir() + "/" + outFilename);
        sb = new StringBuilder();
        sb.append("2009-06-24 02:43:13,958 DEBUG _L12_:323 -" + logStatement + "End workflow state change\n");
        sb.append("2009-06-24 02:43:13,961 INFO _L13_:317 -" + logStatement + "[org.apache.oozie.core.command.WorkflowRunnerCallable] released lock\n");
        TestLogStreamer.writeToGZFile(f, sb);
        StringWriter sw = new StringWriter();
        xf = new XLogFilter();
        xf.setLogLevel("DEBUG|INFO");
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        XLogStreamer str = new XLogStreamer(xf, this.getTestCaseDir(), "oozie.log", 1L);
        Calendar cal = Calendar.getInstance();
        cal.set(2009, 5, 24, 2, 43, 0);
        str.streamLog((Writer)sw, cal.getTime(), new Date(currTime - 18000000L));
        String[] out = sw.toString().split("\n");
        TestLogStreamer.assertEquals((int)7, (int)out.length);
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[0].contains("_L10_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[1].contains("_L11_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[2].contains("_L1_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[3].contains("_L2_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[4].contains("_L4_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[5].contains("_L8_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[6].contains("_L9_"));
        StringWriter sw1 = new StringWriter();
        xf = new XLogFilter();
        xf.setLogLevel("DEBUG|INFO");
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        XLogStreamer str1 = new XLogStreamer(xf, this.getTestCaseDir(), "oozie.log", 1L);
        str1.streamLog((Writer)sw1, null, null);
        out = sw1.toString().split("\n");
        TestLogStreamer.assertEquals((int)8, (int)out.length);
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[0].contains("_L10"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[1].contains("_L11_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[2].contains("_L1_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[3].contains("_L2_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[4].contains("_L4_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[5].contains("_L8_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[6].contains("_L9_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[7].contains("_L7_"));
    }

    public void testStreamLogMultipleHours() throws IOException, CommandException, ServiceException {
        this.setupLog4j();
        new Services().init();
        long currTime = System.currentTimeMillis();
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        xf.setLogLevel("DEBUG|INFO");
        String outFilename = "oozie.log-2012-04-24-19.gz";
        File f = new File(this.getTestCaseDir() + "/" + outFilename);
        StringBuilder logLines = new StringBuilder();
        logLines.append("\n2012-04-24 19:43:13,958 DEBUG _L19_:323 -" + logStatement);
        TestLogStreamer.writeToGZFile(f, logLines);
        outFilename = "oozie.log-2012-04-24-20.gz";
        f = new File(this.getTestCaseDir() + "/" + outFilename);
        logLines = new StringBuilder();
        logLines.append("\n2012-04-24 20:43:13,958 DEBUG _L20_:323 -" + logStatement);
        TestLogStreamer.writeToGZFile(f, logLines);
        outFilename = "oozie.log-2012-04-24-21.gz";
        f = new File(this.getTestCaseDir() + "/" + outFilename);
        logLines = new StringBuilder();
        logLines.append("\n2012-04-24 21:43:13,958 DEBUG _L21_:323 -" + logStatement);
        TestLogStreamer.writeToGZFile(f, logLines);
        FileWriter fw1 = new FileWriter(this.getTestCaseDir() + "/oozie.log");
        StringBuilder sb1 = new StringBuilder();
        sb1.append("\n2012-04-24 22:43:13,958 DEBUG _L22_:323 -" + logStatement);
        sb1.append("\n2012-04-24 22:43:13,961 INFO _L23_:317 -" + logStatement + "[org.apache.oozie.core.command.WorkflowRunnerCallable] released lock");
        fw1.write(sb1.toString());
        fw1.close();
        File f1 = new File(this.getTestCaseDir() + "/oozie.log");
        f1.setLastModified(currTime - 5000L);
        StringWriter sw2 = new StringWriter();
        xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        xf.setLogLevel("DEBUG|INFO");
        XLogStreamer str2 = new XLogStreamer(xf, this.getTestCaseDir(), "oozie.log", 1L);
        Calendar calendarEntry = Calendar.getInstance();
        calendarEntry.set(2012, 3, 24, 19, 0);
        str2.streamLog((Writer)sw2, calendarEntry.getTime(), new Date(System.currentTimeMillis()));
        String[] out = sw2.toString().split("\n");
        TestLogStreamer.assertEquals((int)5, (int)out.length);
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[0].contains("_L19_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[1].contains("_L20_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[2].contains("_L21_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[3].contains("_L22_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[4].contains("_L23_"));
    }

    public void testStreamLogNoDash() throws IOException, CommandException, ServiceException {
        this.setupLog4j();
        new Services().init();
        long currTime = System.currentTimeMillis();
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        xf.setLogLevel("DEBUG|INFO");
        FileWriter fw1 = new FileWriter(this.getTestCaseDir() + "/oozie.log");
        StringBuilder sb1 = new StringBuilder();
        sb1.append("2009-06-24 02:43:13,958 DEBUG _L1_:323 -" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 DEBUG _L2_:323 +" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 DEBUG _L3_:323" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 DEBUG _L4_:323 ABC" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 DEBUG _L5_:323 !@#$%^&*() blah blah" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 WARN _L6_:323 -" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 WARN _L7_:323 +" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 WARN _L8_:323" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 WARN _L9_:323 ABC" + logStatement + "End workflow state change\n");
        sb1.append("2009-06-24 02:43:13,958 WARN _L10_:323 !@#$%^&*() blah blah" + logStatement + "End workflow state change\n");
        fw1.write(sb1.toString());
        fw1.close();
        File f1 = new File(this.getTestCaseDir() + "/oozie.log");
        f1.setLastModified(currTime);
        StringWriter sw = new StringWriter();
        xf = new XLogFilter();
        xf.setParameter("JOB", "14-200904160239--example-forkjoinwf");
        xf.setLogLevel("DEBUG|INFO");
        XLogStreamer str = new XLogStreamer(xf, this.getTestCaseDir(), "oozie.log", 1L);
        str.streamLog((Writer)sw, null, null);
        String[] out = sw.toString().split("\n");
        TestLogStreamer.assertEquals((int)5, (int)out.length);
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[0].contains("_L1_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[1].contains("_L2_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[2].contains("_L3_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[3].contains("_L4_"));
        TestLogStreamer.assertEquals((boolean)true, (boolean)out[4].contains("_L5_"));
    }

    public void testBufferLen() throws IOException, CommandException, ServiceException {
        new Services().init();
        XLogStreamer str = new XLogStreamer(null, this.getTestCaseDir(), "oozie.log", 1L);
        TestLogStreamer.assertEquals((int)4096, (int)str.getBufferLen());
        str = new XLogErrorStreamer(null);
        TestLogStreamer.assertEquals((int)2048, (int)str.getBufferLen());
        str = new XLogAuditStreamer(null);
        TestLogStreamer.assertEquals((int)3, (int)str.getBufferLen());
    }

    static void writeToGZFile(File f, StringBuilder sbr) throws IOException {
        GZIPOutputStream gzout = new GZIPOutputStream(new FileOutputStream(f));
        String strg = sbr.toString();
        byte[] buf = strg.getBytes();
        gzout.write(buf, 0, buf.length);
        gzout.close();
    }

    private void setupLog4j() throws IOException {
        this.defaultLog4jFile = System.getProperty("oozie.log4j.file");
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
    }
}

