/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.MetricsInstrumentation;

public class TestMetricsInstrumentation
extends XTestCase {
    private static final long INTERVAL = 300L;
    private final MetricFilter noJvm = new MetricFilter(){

        public boolean matches(String name, Metric metric) {
            return !name.startsWith("jvm.memory");
        }
    };

    @Override
    protected void setUp() throws Exception {
        this.setSystemProperty("oozie.jmx_monitoring.enable", "true");
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != Services.get()) {
            Services.get().destroy();
        }
        super.tearDown();
    }

    public void testInstrumentationCounter() throws Exception {
        MetricsInstrumentation inst = new MetricsInstrumentation();
        TestMetricsInstrumentation.assertEquals((int)0, (int)inst.getMetricRegistry().getCounters().size());
        inst.incr("a", "1", 1L);
        TestMetricsInstrumentation.assertEquals((int)1, (int)inst.getMetricRegistry().getCounters().size());
        inst.incr("a", "2", 2L);
        TestMetricsInstrumentation.assertEquals((int)2, (int)inst.getMetricRegistry().getCounters().size());
        inst.incr("b", "1", 3L);
        TestMetricsInstrumentation.assertEquals((int)3, (int)inst.getMetricRegistry().getCounters().size());
        TestMetricsInstrumentation.assertEquals((long)1L, (long)((Counter)inst.getMetricRegistry().getCounters().get("a.1")).getCount());
        TestMetricsInstrumentation.assertEquals((long)2L, (long)((Counter)inst.getMetricRegistry().getCounters().get("a.2")).getCount());
        TestMetricsInstrumentation.assertEquals((long)3L, (long)((Counter)inst.getMetricRegistry().getCounters().get("b.1")).getCount());
        TestMetricsInstrumentation.assertEquals((long)1L, (long)((Long)((Instrumentation.Element)((Map)inst.getCounters().get("a")).get("1")).getValue()));
        TestMetricsInstrumentation.assertEquals((long)2L, (long)((Long)((Instrumentation.Element)((Map)inst.getCounters().get("a")).get("2")).getValue()));
        TestMetricsInstrumentation.assertEquals((long)3L, (long)((Long)((Instrumentation.Element)((Map)inst.getCounters().get("b")).get("1")).getValue()));
    }

    private long getTimerValue(Timer timer) {
        long[] values = timer.getSnapshot().getValues();
        return TimeUnit.NANOSECONDS.toMillis(values[0]);
    }

    public void testInstrumentationTimer() throws Exception {
        MetricsInstrumentation inst = new MetricsInstrumentation();
        TestMetricsInstrumentation.assertEquals((int)0, (int)inst.getMetricRegistry().getTimers().size());
        Instrumentation.Cron cron1 = new Instrumentation.Cron();
        inst.addCron("a", "1", cron1);
        TestMetricsInstrumentation.assertEquals((int)1, (int)inst.getMetricRegistry().getTimers().size());
        Instrumentation.Cron cron2 = new Instrumentation.Cron();
        cron2.start();
        Thread.sleep(300L);
        cron2.stop();
        inst.addCron("a", "2", cron2);
        TestMetricsInstrumentation.assertEquals((int)2, (int)inst.getMetricRegistry().getTimers().size());
        Instrumentation.Cron cron3 = new Instrumentation.Cron();
        cron3.start();
        Thread.sleep(600L);
        cron3.stop();
        inst.addCron("b", "1", cron3);
        TestMetricsInstrumentation.assertEquals((int)3, (int)inst.getMetricRegistry().getTimers().size());
        TestMetricsInstrumentation.assertEquals((long)cron1.getOwn(), (long)this.getTimerValue((Timer)inst.getMetricRegistry().getTimers().get("a.1.timer")));
        TestMetricsInstrumentation.assertEquals((long)cron2.getOwn(), (long)this.getTimerValue((Timer)inst.getMetricRegistry().getTimers().get("a.2.timer")));
        TestMetricsInstrumentation.assertEquals((long)cron3.getOwn(), (long)this.getTimerValue((Timer)inst.getMetricRegistry().getTimers().get("b.1.timer")));
    }

    public void testVariables() throws Exception {
        MetricsInstrumentation inst = new MetricsInstrumentation();
        inst.addVariable("a", "1", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 0L;

            public Long getValue() {
                return this.counter++;
            }
        });
        TestMetricsInstrumentation.assertEquals((int)1, (int)inst.getMetricRegistry().getGauges(this.noJvm).size());
        inst.addVariable("a", "2", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 1L;

            public Long getValue() {
                return this.counter++;
            }
        });
        TestMetricsInstrumentation.assertEquals((int)2, (int)inst.getMetricRegistry().getGauges(this.noJvm).size());
        inst.addVariable("b", "1", (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
            private long counter = 2L;

            public Long getValue() {
                return this.counter++;
            }
        });
        TestMetricsInstrumentation.assertEquals((int)3, (int)inst.getMetricRegistry().getGauges(this.noJvm).size());
        TestMetricsInstrumentation.assertEquals((Object)0L, (Object)((Gauge)inst.getMetricRegistry().getGauges(this.noJvm).get("a.1")).getValue());
        TestMetricsInstrumentation.assertEquals((Object)1L, (Object)((Gauge)inst.getMetricRegistry().getGauges(this.noJvm).get("a.2")).getValue());
        TestMetricsInstrumentation.assertEquals((Object)2L, (Object)((Gauge)inst.getMetricRegistry().getGauges(this.noJvm).get("b.1")).getValue());
        TestMetricsInstrumentation.assertEquals((Object)1L, (Object)((Gauge)inst.getMetricRegistry().getGauges(this.noJvm).get("a.1")).getValue());
        TestMetricsInstrumentation.assertEquals((Object)2L, (Object)((Gauge)inst.getMetricRegistry().getGauges(this.noJvm).get("a.2")).getValue());
        TestMetricsInstrumentation.assertEquals((Object)3L, (Object)((Gauge)inst.getMetricRegistry().getGauges(this.noJvm).get("b.1")).getValue());
    }

    public void testSamplers() throws Exception {
        MetricsInstrumentation inst = new MetricsInstrumentation();
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1);
        try {
            inst.setScheduler((ScheduledExecutorService)scheduledExecutorService);
            inst.addSampler("a", "1", 10, 1, (Instrumentation.Variable)new Instrumentation.Variable<Long>(){

                public Long getValue() {
                    return 1L;
                }
            });
            TestMetricsInstrumentation.assertEquals((int)1, (int)inst.getMetricRegistry().getHistograms().size());
            inst.addSampler("a", "2", 10, 1, (Instrumentation.Variable)new Instrumentation.Variable<Long>(){

                public Long getValue() {
                    return 2L;
                }
            });
            TestMetricsInstrumentation.assertEquals((int)2, (int)inst.getMetricRegistry().getHistograms().size());
            inst.addSampler("b", "1", 10, 1, (Instrumentation.Variable)new Instrumentation.Variable<Long>(){
                private long counter = 0L;

                public Long getValue() {
                    return this.counter++ % 10L;
                }
            });
            TestMetricsInstrumentation.assertEquals((int)3, (int)inst.getMetricRegistry().getHistograms().size());
            this.waitFor(20000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return false;
                }
            });
            TestMetricsInstrumentation.assertEquals((double)1.0, (double)((Histogram)inst.getMetricRegistry().getHistograms().get("a.1.histogram")).getSnapshot().getMean(), (double)0.01);
            TestMetricsInstrumentation.assertEquals((double)2.0, (double)((Histogram)inst.getMetricRegistry().getHistograms().get("a.2.histogram")).getSnapshot().getMean(), (double)0.02);
            TestMetricsInstrumentation.assertEquals((double)4.5, (double)((Histogram)inst.getMetricRegistry().getHistograms().get("b.1.histogram")).getSnapshot().getMean(), (double)0.5);
        }
        finally {
            scheduledExecutorService.shutdownNow();
        }
    }

    public void testUnsupportedOpertation() {
        MetricsInstrumentation instr = new MetricsInstrumentation();
        try {
            instr.getAll();
            TestMetricsInstrumentation.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            instr.getSamplers();
            TestMetricsInstrumentation.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            instr.getTimers();
            TestMetricsInstrumentation.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            instr.getVariables();
            TestMetricsInstrumentation.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testJMXInstrumentation() throws Exception {
        AttachProvider attachProvider = AttachProvider.providers().get(0);
        VirtualMachineDescriptor descriptor = null;
        String uniqueId = UUID.randomUUID().toString();
        System.setProperty("processSettings.unique.id", uniqueId);
        for (VirtualMachineDescriptor d : VirtualMachine.list()) {
            String remoteUniqueId = VirtualMachine.attach(d).getSystemProperties().getProperty("processSettings.unique.id");
            if (remoteUniqueId == null || !remoteUniqueId.equals(uniqueId)) continue;
            descriptor = d;
            break;
        }
        TestMetricsInstrumentation.assertNotNull((String)"Could not find own virtual machine", descriptor);
        VirtualMachine virtualMachine = attachProvider.attachVirtualMachine(descriptor);
        String agent = virtualMachine.getSystemProperties().getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
        virtualMachine.loadAgent(agent);
        Object portObject = virtualMachine.getAgentProperties().get("com.sun.management.jmxremote.localConnectorAddress");
        JMXServiceURL target = new JMXServiceURL(portObject + "");
        JMXConnector jmxc = JMXConnectorFactory.connect(target);
        MBeanServerConnection conn = jmxc.getMBeanServerConnection();
        Object value = null;
        try {
            value = conn.getAttribute(new ObjectName("metrics:name=jvm.memory.heap.committed"), "Value");
        }
        catch (Exception e) {
            TestMetricsInstrumentation.fail((String)"Could not fetch metric");
        }
        TestMetricsInstrumentation.assertNotNull((String)"JMX service error", value);
    }
}

