/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.OozieRollingPolicy;

public class TestOozieRollingPolicy
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogFactory.getFactory().release();
        LogManager.resetConfiguration();
    }

    @Override
    protected void tearDown() throws Exception {
        LogFactory.getFactory().release();
        LogManager.resetConfiguration();
        super.tearDown();
    }

    public void testDeletingOldFiles() throws Exception {
        this._testDeletingOldFiles("oozie.log");
    }

    public void testDeletingErrorOldFiles() throws Exception {
        this._testDeletingOldFiles("oozie-error.log");
    }

    public void testDeletingAuditOldFiles() throws Exception {
        this._testDeletingOldFiles("oozie-audit.log", 5);
    }

    private void _testDeletingOldFiles(String oozieLogName) throws IOException {
        this._testDeletingOldFiles(oozieLogName, 11);
    }

    private void _testDeletingOldFiles(String oozieLogName, int calendarUnit) throws IOException {
        String oozieLogPath = this.getTestCaseDir();
        OozieRollingPolicy orp = new OozieRollingPolicy();
        if (calendarUnit == 5) {
            orp.setFileNamePattern(oozieLogPath + "/" + oozieLogName + "-%d{yyyy-MM-dd}");
        } else {
            orp.setFileNamePattern(oozieLogPath + "/" + oozieLogName + "-%d{yyyy-MM-dd-HH}");
        }
        orp.setMaxHistory(3);
        GregorianCalendar cal = new GregorianCalendar();
        final File f0 = new File(oozieLogPath, oozieLogName);
        f0.createNewFile();
        f0.setLastModified(cal.getTimeInMillis());
        ((Calendar)cal).add(calendarUnit, 1);
        final File f1 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit) + ".gz");
        f1.createNewFile();
        ((Calendar)cal).add(calendarUnit, 1);
        final File f2 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit) + ".gz");
        f2.createNewFile();
        ((Calendar)cal).add(calendarUnit, 1);
        final File f3 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit) + ".gz");
        f3.createNewFile();
        ((Calendar)cal).add(calendarUnit, 1);
        final File f4 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit) + ".gz");
        f4.createNewFile();
        orp.isTriggeringEvent(null, null, null, 0L);
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return f0.exists() && !f1.exists() && f2.exists() && f3.exists() && f4.exists();
            }
        });
        TestOozieRollingPolicy.assertTrue((f0.exists() && !f1.exists() && f2.exists() && f3.exists() && f4.exists() ? 1 : 0) != 0);
        ((Calendar)cal).add(calendarUnit, 1);
        final File f5 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit));
        f5.createNewFile();
        f5.setLastModified(cal.getTimeInMillis());
        ((Calendar)cal).add(calendarUnit, -15);
        final File f6 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit));
        f6.createNewFile();
        f6.setLastModified(cal.getTimeInMillis());
        orp.isTriggeringEvent(null, null, null, 0L);
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return f0.exists() && !f1.exists() && !f2.exists() && f3.exists() && f4.exists() && f5.exists() && !f6.exists();
            }
        });
        TestOozieRollingPolicy.assertTrue((f0.exists() && !f1.exists() && !f2.exists() && f3.exists() && f4.exists() && f5.exists() && !f6.exists() ? 1 : 0) != 0);
        final File f7 = new File(oozieLogPath, "blah.txt");
        f7.createNewFile();
        f7.setLastModified(cal.getTimeInMillis());
        ((Calendar)cal).add(calendarUnit, 1);
        final File f8 = new File(oozieLogPath, oozieLogName + this.formatDateForFilename(cal, calendarUnit));
        ((Calendar)cal).add(calendarUnit, 15);
        f8.createNewFile();
        f8.setLastModified(cal.getTimeInMillis());
        orp.isTriggeringEvent(null, null, null, 0L);
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return f0.exists() && !f1.exists() && !f2.exists() && !f3.exists() && f4.exists() && f5.exists() && !f6.exists() && f7.exists() && f8.exists();
            }
        });
        TestOozieRollingPolicy.assertTrue((f0.exists() && !f1.exists() && !f2.exists() && !f3.exists() && f4.exists() && f5.exists() && !f6.exists() && f7.exists() && f8.exists() ? 1 : 0) != 0);
    }

    private String formatDateForFilename(Calendar cal, int calendarUnit) {
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int date = cal.get(5);
        int hour = cal.get(11);
        StringBuilder sb = new StringBuilder("-");
        if (year < 10) {
            sb.append("000");
        } else if (year < 100) {
            sb.append("00");
        } else if (year < 1000) {
            sb.append("0");
        }
        sb.append(year);
        sb.append("-");
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        sb.append("-");
        if (date < 10) {
            sb.append("0");
        }
        sb.append(date);
        if (calendarUnit == 11) {
            sb.append("-");
            if (hour < 10) {
                sb.append("0");
            }
            sb.append(hour);
        }
        return sb.toString();
    }
}

