/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ParamChecker;

public class TestParamChecker
extends XTestCase {
    public void testNotNull() {
        ParamChecker.notNull((Object)"value", (String)"name");
        try {
            ParamChecker.notNull(null, (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNotNullElements() {
        ParamChecker.notEmptyElements(new ArrayList(), (String)"name");
        ParamChecker.notEmptyElements(Arrays.asList("a"), (String)"name");
        try {
            ParamChecker.notEmptyElements(null, (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ParamChecker.notEmptyElements(Arrays.asList("a", null), (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNotEmpty() {
        ParamChecker.notEmpty((String)"value", (String)"name");
        try {
            ParamChecker.notEmpty(null, (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ParamChecker.notEmpty((String)"", (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNotEmptyElements() {
        ParamChecker.notEmptyElements(new ArrayList(), (String)"name");
        ParamChecker.notEmptyElements(Arrays.asList("a"), (String)"name");
        try {
            ParamChecker.notEmptyElements(null, (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ParamChecker.notEmptyElements(Arrays.asList("a", null), (String)"name");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidToken() {
        ParamChecker.validateActionName((String)"azAZ09_-");
        try {
            ParamChecker.validateActionName(null);
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ParamChecker.validateActionName((String)"");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ParamChecker.validateActionName((String)"@");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidIdentifier() {
        TestParamChecker.assertTrue((boolean)ParamChecker.isValidIdentifier((String)"a"));
        TestParamChecker.assertTrue((boolean)ParamChecker.isValidIdentifier((String)"a1"));
        TestParamChecker.assertTrue((boolean)ParamChecker.isValidIdentifier((String)"a_"));
        TestParamChecker.assertTrue((boolean)ParamChecker.isValidIdentifier((String)"_"));
        TestParamChecker.assertFalse((boolean)ParamChecker.isValidIdentifier((String)"!"));
        TestParamChecker.assertFalse((boolean)ParamChecker.isValidIdentifier((String)"1"));
    }

    public void testCheckGTZero() {
        TestParamChecker.assertEquals((int)120, (int)ParamChecker.checkGTZero((int)120, (String)"test"));
        try {
            ParamChecker.checkGTZero((int)0, (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ParamChecker.checkGTZero((int)-1, (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCheckGEZero() {
        TestParamChecker.assertEquals((int)120, (int)ParamChecker.checkGEZero((int)120, (String)"test"));
        TestParamChecker.assertEquals((int)0, (int)ParamChecker.checkGEZero((int)0, (String)"test"));
        try {
            ParamChecker.checkGEZero((int)-1, (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCheckInteger() {
        TestParamChecker.assertEquals((int)120, (int)ParamChecker.checkInteger((String)"120", (String)"test"));
        TestParamChecker.assertEquals((int)-12, (int)ParamChecker.checkInteger((String)"-12", (String)"test"));
        try {
            ParamChecker.checkInteger((String)"ABCD", (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ParamChecker.checkInteger((String)"1.5", (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCheckUTC() {
        ParamChecker.checkDateOozieTZ((String)"2009-02-01T01:00Z", (String)"test");
        try {
            ParamChecker.checkDateOozieTZ((String)"2009-02-01T01:00", (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ParamChecker.checkDateOozieTZ((String)"2009-02-01U01:00Z", (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCheckTimeZone() {
        ParamChecker.checkTimeZone((String)"UTC", (String)"test");
        try {
            ParamChecker.checkTimeZone((String)"UTZ", (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ParamChecker.checkTimeZone((String)"America/Los_Angeles", (String)"test");
        try {
            ParamChecker.checkTimeZone((String)"America/Los_Angles", (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testIsMember() {
        String[] members = new String[]{"LIFO", "FIFO", "ONLYLAST"};
        ParamChecker.isMember((String)"FIFO", (String[])members, (String)"test");
        try {
            ParamChecker.isMember((String)"FIF", (String[])members, (String)"test");
            TestParamChecker.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCheckFrequency() {
        ParamChecker.checkFrequency((String)"10");
        String cron = "20,30 * * 10 *";
        ParamChecker.checkFrequency((String)cron);
        cron = "0/10 10-12 3 5 MON,FRI";
        ParamChecker.checkFrequency((String)cron);
        try {
            ParamChecker.checkFrequency((String)"frequency");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ParamChecker.checkFrequency((String)"10 * w e 1-4");
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateActionName() {
        String actionName = "actionName";
        ParamChecker.validateActionName((String)actionName);
        actionName = "actionName01";
        ParamChecker.validateActionName((String)actionName);
        actionName = "actionName01_02";
        ParamChecker.validateActionName((String)actionName);
        actionName = "actionName01_02-test";
        ParamChecker.validateActionName((String)actionName);
        StringBuilder sb = new StringBuilder();
        sb.append("a");
        for (int i = 0; i < 127; ++i) {
            sb.append(i % 10);
        }
        ParamChecker.validateActionName((String)sb.toString());
        try {
            actionName = "1actionName";
            ParamChecker.validateActionName((String)actionName);
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        try {
            actionName = "-actionName";
            ParamChecker.validateActionName((String)actionName);
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException i) {
            // empty catch block
        }
        try {
            sb.setLength(0);
            sb.append("ab");
            for (int i = 0; i < 128; ++i) {
                sb.append(i);
            }
            ParamChecker.validateActionName((String)sb.toString());
            TestParamChecker.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

