/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XLog;

public class TestXLog
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XLog.Info.reset();
        XLog.Info.remove();
    }

    @Override
    protected void tearDown() throws Exception {
        XLog.Info.reset();
        XLog.Info.remove();
        super.tearDown();
    }

    public void testInfoReset() {
        XLog.Info logInfo = new XLog.Info();
        XLog.Info.defineParameter((String)"A");
        TestXLog.assertEquals((String)"A[-]", (String)logInfo.createPrefix());
        XLog.Info.reset();
        TestXLog.assertEquals((String)"", (String)logInfo.createPrefix());
    }

    public void testInfoParameters() {
        XLog.Info logInfo = new XLog.Info();
        TestXLog.assertEquals((String)"", (String)logInfo.createPrefix());
        XLog.Info.defineParameter((String)"A");
        TestXLog.assertEquals((String)"A[-]", (String)logInfo.createPrefix());
        XLog.Info.defineParameter((String)"B");
        TestXLog.assertEquals((String)"A[-] B[-]", (String)logInfo.createPrefix());
        logInfo.setParameter("A", "a");
        TestXLog.assertEquals((String)"A[a] B[-]", (String)logInfo.createPrefix());
        logInfo.setParameter("B", "b");
        TestXLog.assertEquals((String)"A[a] B[b]", (String)logInfo.createPrefix());
    }

    public void testInfoConstructorPropagation() {
        XLog.Info.defineParameter((String)"A");
        XLog.Info logInfo = new XLog.Info();
        logInfo.setParameter("A", "a");
        TestXLog.assertEquals((String)"A[a]", (String)logInfo.createPrefix());
        logInfo = new XLog.Info(logInfo);
        TestXLog.assertEquals((String)"A[a]", (String)logInfo.createPrefix());
    }

    public void testInfoThreadLocal() throws Exception {
        XLog.Info.defineParameter((String)"A");
        TestXLog.assertEquals((String)"A[-]", (String)XLog.Info.get().createPrefix());
        XLog.Info.get().setParameter("A", "a");
        TestXLog.assertEquals((String)"A[a]", (String)XLog.Info.get().createPrefix());
        Thread t = new Thread(){

            @Override
            public void run() {
                TestCase.assertEquals((String)"A[-]", (String)XLog.Info.get().createPrefix());
                XLog.Info.get().setParameter("A", "aa");
            }
        };
        t.start();
        t.join();
        TestXLog.assertEquals((String)"A[a]", (String)XLog.Info.get().createPrefix());
    }

    public void testInfoThreadLocalPrefix() throws Exception {
        XLog.Info.defineParameter((String)"JOB");
        XLog.Info.defineParameter((String)"ACTION");
        TestXLog.assertEquals((String)"JOB[-] ACTION[-]", (String)XLog.Info.get().createPrefix());
        String jobId = "XXX-W";
        LogUtils.setLogInfo((String)(jobId + "@start"));
        TestXLog.assertEquals((String)"JOB[XXX-W] ACTION[XXX-W@start]", (String)XLog.Info.get().createPrefix());
        final StringBuilder sb1 = new StringBuilder();
        final StringBuilder sb2 = new StringBuilder();
        final LogPrinter printer = new LogPrinter();
        Thread t = new Thread(){

            @Override
            public void run() {
                LogUtils.setLogInfo((String)"XXX-W@hive");
                sb1.append(printer.getLogMsgPrefix());
                sb2.append(printer.getThreadLocalPrefix());
            }
        };
        t.start();
        t.join();
        TestXLog.assertNull((Object)printer.getLogMsgPrefix());
        TestXLog.assertEquals((String)"JOB[XXX-W] ACTION[XXX-W@start]", (String)printer.getThreadLocalPrefix());
        TestXLog.assertEquals((String)"JOB[XXX-W] ACTION[XXX-W@start]", (String)printer.getLogPrefix());
        TestXLog.assertEquals((String)"null", (String)sb1.toString());
        TestXLog.assertEquals((String)"JOB[XXX-W] ACTION[XXX-W@hive]", (String)sb2.toString());
    }

    public void testLogMsg() throws Exception {
        XLog.Info.defineParameter((String)"JOB");
        XLog.Info.defineParameter((String)"ACTION");
        LogPrinter printer = new LogPrinter();
        TestXLog.assertNull((Object)printer.getLogMsgPrefix());
        String jobId = "XXX-W";
        LogUtils.setLogInfo((String)(jobId + "@start"));
        TestXLog.assertEquals((String)"JOB[XXX-W] ACTION[XXX-W@start]", (String)printer.getThreadLocalPrefix());
        TestXLog.assertEquals((String)"JOB[XXX-W] ACTION[XXX-W@start]", (String)printer.getLogPrefix());
        printer.setMsgPrefix("prefix");
        TestXLog.assertEquals((String)"prefix", (String)printer.getLogPrefix());
    }

    public void testFactory() {
        XLog log = XLog.getLog(((Object)((Object)this)).getClass());
        TestXLog.assertNotNull((Object)log);
        TestXLog.assertEquals(XLog.class, log.getClass());
    }

    public void testFactoryLogInfoPrefix() {
        XLog.Info.defineParameter((String)"A");
        XLog.Info.get().setParameter("A", "a");
        XLog log = XLog.getLog(((Object)((Object)this)).getClass());
        log.setMsgPrefix(XLog.Info.get().createPrefix());
        TestXLog.assertEquals((String)"A[a]", (String)log.getMsgPrefix());
    }

    public void testXLogFunctionality() {
        TestLog log = new TestLog();
        TestLog ops = new TestLog();
        XLog xLog = new XLog((Log)log);
        TestXLog.assertNull((Object)xLog.getMsgPrefix());
        xLog.setMsgPrefix("prefix");
        TestXLog.assertEquals((String)"prefix", (String)xLog.getMsgPrefix());
        xLog.setMsgPrefix(null);
        xLog.loggers[1] = ops;
        log.setLevel(7);
        ops.setLevel(7);
        TestXLog.assertFalse((boolean)xLog.isDebugEnabled());
        TestXLog.assertFalse((boolean)xLog.isErrorEnabled());
        TestXLog.assertFalse((boolean)xLog.isFatalEnabled());
        TestXLog.assertFalse((boolean)xLog.isInfoEnabled());
        TestXLog.assertFalse((boolean)xLog.isWarnEnabled());
        TestXLog.assertFalse((boolean)xLog.isTraceEnabled());
        log.setLevel(0);
        ops.setLevel(7);
        TestXLog.assertTrue((boolean)xLog.isDebugEnabled());
        TestXLog.assertTrue((boolean)xLog.isErrorEnabled());
        TestXLog.assertTrue((boolean)xLog.isFatalEnabled());
        TestXLog.assertTrue((boolean)xLog.isInfoEnabled());
        TestXLog.assertTrue((boolean)xLog.isWarnEnabled());
        TestXLog.assertTrue((boolean)xLog.isTraceEnabled());
        log.setLevel(7);
        ops.setLevel(0);
        TestXLog.assertTrue((boolean)xLog.isDebugEnabled());
        TestXLog.assertTrue((boolean)xLog.isErrorEnabled());
        TestXLog.assertTrue((boolean)xLog.isFatalEnabled());
        TestXLog.assertTrue((boolean)xLog.isInfoEnabled());
        TestXLog.assertTrue((boolean)xLog.isWarnEnabled());
        TestXLog.assertTrue((boolean)xLog.isTraceEnabled());
        log.setLevel(0);
        ops.setLevel(0);
        TestXLog.assertTrue((boolean)xLog.isDebugEnabled());
        TestXLog.assertTrue((boolean)xLog.isErrorEnabled());
        TestXLog.assertTrue((boolean)xLog.isFatalEnabled());
        TestXLog.assertTrue((boolean)xLog.isInfoEnabled());
        TestXLog.assertTrue((boolean)xLog.isWarnEnabled());
        TestXLog.assertTrue((boolean)xLog.isTraceEnabled());
        log.setLevel(7);
        ops.setLevel(7);
        log.resetMessage();
        xLog.debug((Object)"");
        TestXLog.assertNull((Object)log.getMessage());
        xLog.error((Object)"");
        TestXLog.assertNull((Object)log.getMessage());
        xLog.fatal((Object)"");
        TestXLog.assertNull((Object)log.getMessage());
        xLog.info((Object)"");
        TestXLog.assertNull((Object)log.getMessage());
        xLog.warn((Object)"");
        TestXLog.assertNull((Object)log.getMessage());
        xLog.trace((Object)"");
        TestXLog.assertNull((Object)log.getMessage());
        log.setLevel(0);
        ops.setLevel(7);
        log.resetMessage();
        ops.resetMessage();
        xLog.debug((Object)"debug");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("debug"));
        TestXLog.assertNull((Object)ops.getMessage());
        xLog.error((Object)"error");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("error"));
        TestXLog.assertNull((Object)ops.getMessage());
        xLog.fatal((Object)"fatal");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("fatal"));
        TestXLog.assertNull((Object)ops.getMessage());
        xLog.info((Object)"info");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("info"));
        TestXLog.assertNull((Object)ops.getMessage());
        xLog.warn((Object)"warn");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("warn"));
        TestXLog.assertNull((Object)ops.getMessage());
        xLog.trace((Object)"trace");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("trace"));
        TestXLog.assertNull((Object)ops.getMessage());
        log.setLevel(0);
        ops.setLevel(0);
        log.resetMessage();
        ops.resetMessage();
        xLog.debug((Object)"debug");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("debug"));
        TestXLog.assertNull((Object)ops.getMessage());
        log.setLevel(0);
        ops.setLevel(0);
        log.resetMessage();
        ops.resetMessage();
        xLog.debug((Object)"debug");
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("debug"));
        TestXLog.assertNull((Object)ops.getMessage());
        log.setLevel(0);
        ops.setLevel(0);
        log.resetMessage();
        ops.resetMessage();
        xLog.debug(4, "debug", new Object[0]);
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("debug"));
        TestXLog.assertTrue((boolean)ops.getMessage().endsWith("debug"));
        log.setLevel(0);
        ops.setLevel(0);
        log.resetMessage();
        ops.resetMessage();
        xLog.debug(4, "debug {0}", new Object[]{"debug"});
        TestXLog.assertTrue((boolean)log.getMessage().endsWith("debug debug"));
        TestXLog.assertTrue((boolean)ops.getMessage().endsWith("debug debug"));
        TestXLog.assertNull((Object)XLog.getCause((Object[])new Object[]{"a", "b"}));
        TestXLog.assertNotNull((Object)XLog.getCause((Object[])new Object[]{"a", "b", new Exception()}));
    }

    public class LogPrinter {
        XLog LOG = XLog.getLog(LogPrinter.class);

        public void setMsgPrefix(String prefix) {
            this.LOG.setMsgPrefix(prefix);
        }

        public String getLogMsgPrefix() {
            return this.LOG.getMsgPrefix();
        }

        public String getThreadLocalPrefix() {
            return XLog.Info.get().getPrefix();
        }

        public String getLogPrefix() {
            return this.LOG.getMsgPrefix() != null ? this.LOG.getMsgPrefix() : XLog.Info.get().getPrefix();
        }
    }

    public static class TestLog
    extends SimpleLog {
        private String message;

        public TestLog() {
            super("");
        }

        protected void write(StringBuffer stringBuffer) {
            this.message = stringBuffer.toString();
        }

        public void resetMessage() {
            this.message = null;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

