/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import junit.framework.Assert;
import org.apache.oozie.util.XmlUtils;
import org.jdom.input.JDOMParseException;
import org.junit.Test;

public class TestXmlUtils {
    private static String EXTERNAL_ENTITY_XML = "<!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:///etc/passwd\">]>\n<foo>&xxe;</foo>";

    @Test
    public void testExternalEntity() throws Exception {
        try {
            XmlUtils.parseXml((String)EXTERNAL_ENTITY_XML);
            Assert.fail((String)"DOCTYPE should not be allowed");
        }
        catch (JDOMParseException e) {
            Assert.assertTrue((String)"Exception has different message.", (boolean)e.getMessage().contains("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true"));
        }
    }

    @Test
    public void testRemoveComments() throws Exception {
        String xmlStr = "<test1> <!-- Comment1 -->1234 <test2> ABCD <!-- Comment2 --> </test2> <!-- Comment3 --> <test3> <!-- Comment4 -->EFGH  </test3> <!-- Comment5 --></test1>";
        String result = XmlUtils.removeComments((String)xmlStr);
        System.out.println("Result After Comments removal :\n" + result);
    }
}

