/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.ConfigUtils;

public class TestZKUtils
extends ZKXTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegisterAdvertiseUnadvertiseUnregister() throws Exception {
        CuratorFramework client = this.getClient();
        ServiceDiscovery<Map> sDiscovery = this.getServiceDiscovery();
        TestZKUtils.assertNull((Object)client.checkExists().forPath("/services"));
        TestZKUtils.assertEquals((int)0, (int)sDiscovery.queryForInstances("servers").size());
        TestZKUtils.assertNull((Object)sDiscovery.queryForInstance("servers", "1234"));
        ZKXTestCase.DummyUser du = new ZKXTestCase.DummyUser(this);
        ZKXTestCase.DummyUser du2 = new ZKXTestCase.DummyUser(this);
        try {
            du.register();
            TestZKUtils.assertNotNull((Object)client.checkExists().forPath("/services"));
            TestZKUtils.assertEquals((int)1, (int)sDiscovery.queryForInstances("servers").size());
            TestZKUtils.assertNotNull((Object)sDiscovery.queryForInstance("servers", "1234"));
            du2.register();
            TestZKUtils.assertNotNull((Object)client.checkExists().forPath("/services"));
            TestZKUtils.assertEquals((int)1, (int)sDiscovery.queryForInstances("servers").size());
            TestZKUtils.assertNotNull((Object)sDiscovery.queryForInstance("servers", "1234"));
            du.unregister();
            TestZKUtils.assertNotNull((Object)client.checkExists().forPath("/services"));
            TestZKUtils.assertEquals((int)1, (int)sDiscovery.queryForInstances("servers").size());
            TestZKUtils.assertNotNull((Object)sDiscovery.queryForInstance("servers", "1234"));
            du2.unregister();
            TestZKUtils.assertNotNull((Object)client.checkExists().forPath("/services"));
            TestZKUtils.assertEquals((int)0, (int)sDiscovery.queryForInstances("servers").size());
            TestZKUtils.assertNull((Object)sDiscovery.queryForInstance("servers", "1234"));
        }
        finally {
            du.unregister();
            du2.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMetaData() throws Exception {
        ServiceDiscovery<Map> sDiscovery = this.getServiceDiscovery();
        TestZKUtils.assertNull((Object)sDiscovery.queryForInstance("servers", "1234"));
        ZKXTestCase.DummyUser du = new ZKXTestCase.DummyUser(this);
        try {
            du.register();
            TestZKUtils.assertNotNull((Object)sDiscovery.queryForInstance("servers", "1234"));
            List allMetaData = du.getZKUtils().getAllMetaData();
            TestZKUtils.assertEquals((int)1, (int)allMetaData.size());
            ServiceInstance meta = (ServiceInstance)allMetaData.get(0);
            TestZKUtils.assertEquals((String)"1234", (String)meta.getId());
            TestZKUtils.assertEquals((String)"servers", (String)meta.getName());
            Map data = (Map)meta.getPayload();
            TestZKUtils.assertEquals((int)2, (int)data.size());
            TestZKUtils.assertEquals((String)"1234", (String)((String)data.get("OOZIE_ID")));
            String url = ConfigUtils.getOozieURL((boolean)false);
            TestZKUtils.assertEquals((String)url, (String)((String)data.get("OOZIE_URL")));
        }
        finally {
            du.unregister();
        }
    }

    public void testGetZKId() throws Exception {
        ZKXTestCase.DummyUser du = new ZKXTestCase.DummyUser(this);
        try {
            du.register();
            TestZKUtils.assertEquals((String)"1234", (String)du.getZKUtils().getZKId());
        }
        finally {
            du.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetZKIdIndex() throws Exception {
        ZKXTestCase.DummyUser du = new ZKXTestCase.DummyUser(this);
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        ZKXTestCase.DummyZKOozie dummyOozie2 = null;
        try {
            dummyOozie = new ZKXTestCase.DummyZKOozie(this, "a", "http://blah");
            du.register();
            TestZKUtils.assertEquals((int)1, (int)du.getZKUtils().getZKIdIndex(du.getZKUtils().getAllMetaData()));
            dummyOozie2 = new ZKXTestCase.DummyZKOozie(this, "b", "http://blah");
            TestZKUtils.assertEquals((int)1, (int)du.getZKUtils().getZKIdIndex(du.getZKUtils().getAllMetaData()));
            dummyOozie.teardown();
            TestZKUtils.assertEquals((int)0, (int)du.getZKUtils().getZKIdIndex(du.getZKUtils().getAllMetaData()));
        }
        finally {
            du.unregister();
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            if (dummyOozie2 != null) {
                dummyOozie2.teardown();
            }
        }
    }
}

