/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import org.apache.oozie.util.db.FailingConnectionWrapper;
import org.junit.Assert;
import org.junit.Test;

public class TestOozieDmlStatementPredicate {
    private final FailingConnectionWrapper.OozieDmlStatementPredicate statementPredicate = new FailingConnectionWrapper.OozieDmlStatementPredicate();

    @Test
    public void testDmlNotOozieTableDoesNotApply() {
        Assert.assertFalse((String)"DML statement but not of an Oozie table", (boolean)this.statementPredicate.apply("SELECT * FROM wellhello"));
    }

    @Test
    public void testNotDmlOozieTableDoesNotApply() {
        Assert.assertFalse((String)"not a DML statement but of an Oozie table", (boolean)this.statementPredicate.apply("CREATE TABLE WF_JOBS"));
    }

    @Test
    public void testNotDmlNotOozieTableDoesNotApply() {
        Assert.assertFalse((String)"not a DML statement and not of an Oozie table", (boolean)this.statementPredicate.apply("CREATE TABLE wellhello"));
    }

    @Test
    public void testDmlAndOozieTableAppliesIgnoreCase() {
        Assert.assertTrue((String)"a DML statement and of an Oozie table", (boolean)this.statementPredicate.apply("SELECT * FROM wf_jobs"));
        Assert.assertTrue((String)"a DML statement and of an Oozie table", (boolean)this.statementPredicate.apply("insert into WF_JOBS"));
        Assert.assertTrue((String)"a DML statement and of an Oozie table", (boolean)this.statementPredicate.apply("update wf_jobs"));
        Assert.assertTrue((String)"a DML statement and of an Oozie table", (boolean)this.statementPredicate.apply("DELETE FROM WF_JOBS"));
    }
}

