/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import com.google.common.base.Predicate;
import java.util.concurrent.Callable;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.oozie.util.db.OperationRetryHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestOperationRetryHandler {
    private final Predicate<Throwable> testRetryPredicate = new Predicate<Throwable>(){

        public boolean apply(Throwable input) {
            return input.getClass() == RuntimeException.class;
        }
    };
    private final OperationRetryHandler retryHandler = new OperationRetryHandler(3, 1L, 1L, this.testRetryPredicate);

    @Test
    public void testWhenConfiguredNotToRetryThenTriesOnce() throws Exception {
        this.tryOnceAndAssert(new OperationRetryHandler(0, 1L, 100L, this.testRetryPredicate));
        this.tryOnceAndAssert(new OperationRetryHandler(10, 1L, 0L, this.testRetryPredicate));
        this.tryOnceAndAssert(new OperationRetryHandler(0, 1L, 0L, this.testRetryPredicate));
    }

    private void tryOnceAndAssert(OperationRetryHandler tryingOnceRetryHandler) throws Exception {
        Callable operation = (Callable)Mockito.mock(Callable.class);
        final MutableInt callCount = new MutableInt(0);
        ((Callable)BDDMockito.willAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                callCount.increment();
                return null;
            }
        }).given((Object)operation)).call();
        tryingOnceRetryHandler.executeWithRetry(operation);
        this.assertCallCount(1, callCount);
        this.assertNoRetryAttemptsAreInProgressOrExhausted();
    }

    @Test
    public void testNoRetry() throws Exception {
        Callable operation = (Callable)Mockito.mock(Callable.class);
        BDDMockito.given(operation.call()).willReturn((Object)"dummy");
        this.retryHandler.executeWithRetry(operation);
    }

    @Test
    public void testRetriesOnFailure() throws Exception {
        Callable operation = (Callable)Mockito.mock(Callable.class);
        final MutableInt callCount = new MutableInt(0);
        ((Callable)BDDMockito.willAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                callCount.increment();
                throw new RuntimeException();
            }
        }).given((Object)operation)).call();
        boolean exceptionThrown = false;
        try {
            this.retryHandler.executeWithRetry(operation);
        }
        catch (RuntimeException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Exception was not thrown", (boolean)exceptionThrown);
        this.assertCallCount(3, callCount);
        this.assertNoRetryAttemptsAreInProgressOrExhausted();
    }

    @Test
    public void testRetriesOnFailureRecovery() throws Exception {
        Callable operation = (Callable)Mockito.mock(Callable.class);
        final MutableInt callCount = new MutableInt(0);
        ((Callable)BDDMockito.willAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                callCount.increment();
                if (callCount.intValue() < 2) {
                    throw new RuntimeException();
                }
                return null;
            }
        }).given((Object)operation)).call();
        this.retryHandler.executeWithRetry(operation);
        this.assertCallCount(2, callCount);
        this.assertNoRetryAttemptsAreInProgressOrExhausted();
    }

    @Test
    public void testNoRetriesOnNonSQLError() throws Exception {
        Callable operation = (Callable)Mockito.mock(Callable.class);
        final MutableInt callCount = new MutableInt(0);
        ((Callable)BDDMockito.willAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                callCount.increment();
                throw new IllegalStateException();
            }
        }).given((Object)operation)).call();
        boolean exceptionThrown = false;
        try {
            this.retryHandler.executeWithRetry(operation);
        }
        catch (IllegalStateException e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Exception was not thrown", (boolean)exceptionThrown);
        this.assertCallCount(1, callCount);
        this.assertNoRetryAttemptsAreInProgressOrExhausted();
    }

    @Test
    public void testEmbeddedRetryHandlersWhenInnerHandlerThrowsSQLError() throws Exception {
        final Callable innerOperation = (Callable)Mockito.mock(Callable.class);
        final MutableInt callCount = new MutableInt(0);
        ((Callable)BDDMockito.willAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                callCount.increment();
                throw new RuntimeException();
            }
        }).given((Object)innerOperation)).call();
        Callable outerOperation = (Callable)Mockito.mock(Callable.class);
        ((Callable)BDDMockito.willAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                try {
                    TestOperationRetryHandler.this.retryHandler.executeWithRetry(innerOperation);
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
                return null;
            }
        }).given((Object)outerOperation)).call();
        boolean exceptionThrown = false;
        try {
            this.retryHandler.executeWithRetry(outerOperation);
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        Assert.assertTrue((String)"Exception was not thrown", (boolean)exceptionThrown);
        this.assertCallCount(3, callCount);
        this.assertNoRetryAttemptsAreInProgressOrExhausted();
    }

    private void assertCallCount(int expected, MutableInt callCount) {
        Assert.assertEquals((String)"Number of retries", (long)expected, (long)callCount.intValue());
    }

    private void assertNoRetryAttemptsAreInProgressOrExhausted() {
        Assert.assertEquals((String)"Nesting level", (long)0L, (long)OperationRetryHandler.RETRY_ATTEMPT_STATE.getInProgressCount());
        Assert.assertEquals((String)"Retries performed", (Object)false, (Object)OperationRetryHandler.RETRY_ATTEMPT_STATE.isExhausted());
    }
}

