/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.QueryTimeoutException;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.db.PersistenceExceptionSubclassFilterRetryPredicate;
import org.junit.Assert;
import org.junit.Test;

public class TestPersistenceExceptionSubclassFilterRetryPredicate {
    private final PersistenceExceptionSubclassFilterRetryPredicate predicate = new PersistenceExceptionSubclassFilterRetryPredicate();

    @Test
    public void testFilteredJPAExceptions() {
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new EntityExistsException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new EntityNotFoundException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new LockTimeoutException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new NoResultException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new NonUniqueResultException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new OptimisticLockException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new PessimisticLockException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new QueryTimeoutException()));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)new TransactionRequiredException()));
    }

    @Test
    public void testNotFilteredJPAExceptions() {
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)new RollbackException()));
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)new PersistenceException()));
    }

    @Test
    public void testNonJPAExceptions() {
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)new IllegalStateException()));
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)new Exception()));
    }

    @Test
    public void testNestedFilteredJPAExceptions() {
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new EntityExistsException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new EntityNotFoundException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new LockTimeoutException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new NoResultException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new NonUniqueResultException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new OptimisticLockException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new PessimisticLockException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new QueryTimeoutException())));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new TransactionRequiredException())));
    }

    @Test
    public void testNestedNotFilteredJPAExceptions() {
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new RollbackException())));
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)this.wrapCause((Throwable)new PersistenceException())));
    }

    @Test
    public void testNestedNonJPAExceptions() {
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)this.wrapCause(new RuntimeException())));
        Assert.assertTrue((boolean)this.predicate.apply((Throwable)this.wrapCause(new Exception())));
    }

    @Test
    public void testPlainJPAExecutorExceptionWithMessage() {
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapMessage("No WorkflowJobBean found in database")));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapMessage("Some other message")));
        Assert.assertFalse((boolean)this.predicate.apply((Throwable)this.wrapMessageRuntime("Some runtime problem")));
    }

    private JPAExecutorException wrapCause(Throwable cause) {
        return new JPAExecutorException(new XException(ErrorCode.E0603, new Object[]{new PersistenceException(cause)}));
    }

    private JPAExecutorException wrapMessage(String message) {
        return new JPAExecutorException(ErrorCode.E0603, new Object[]{message});
    }

    private RuntimeException wrapMessageRuntime(String message) {
        return new RuntimeException(message);
    }
}

