/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import org.apache.oozie.util.db.RetryAttemptState;
import org.junit.Assert;
import org.junit.Test;

public class TestRetryAttemptState {
    private final RetryAttemptState state = new RetryAttemptState();

    @Test
    public void testOneAttemptIsInProgressAndAttemptsAreNotExhausted() {
        this.state.signalStart();
        Assert.assertFalse((String)"retry attempts exhausted", (boolean)this.state.isExhausted());
        Assert.assertEquals((String)"retry attempt count", (long)1L, (long)this.state.getInProgressCount());
    }

    @Test
    public void testNoAttemptIsInProgressAndAttemptsAreNotExhausted() {
        this.state.signalStart();
        this.state.signalEnd();
        Assert.assertFalse((String)"retry attempts exhausted", (boolean)this.state.isExhausted());
        Assert.assertEquals((String)"retry attempt count", (long)0L, (long)this.state.getInProgressCount());
    }

    @Test
    public void testExhaustedFromOneThreadRemainsNotStartedFromAnotherThread() throws InterruptedException {
        ExhaustingAttempt exhaustingAttempt = new ExhaustingAttempt();
        Thread exhaustingThread = new Thread(exhaustingAttempt);
        exhaustingThread.start();
        exhaustingThread.join();
        Assert.assertFalse((String)"retry attempts exhausted", (boolean)this.state.isExhausted());
        Assert.assertEquals((String)"retry attempt count", (long)0L, (long)this.state.getInProgressCount());
    }

    @Test
    public void testNestedAttemptsFinishSuccessfullyWhenNotExhausted() throws InterruptedException {
        NestedAttempt inner = new NestedAttempt(false);
        NestedAttempt outer = new NestedAttempt(inner, false);
        outer.run();
        Assert.assertFalse((String)"retry attempts exhausted", (boolean)this.state.isExhausted());
        Assert.assertEquals((String)"retry attempt count", (long)0L, (long)this.state.getInProgressCount());
    }

    @Test
    public void testOuterAttemptRemainsUnfinishedWhenInnerExhausted() throws InterruptedException {
        NestedAttempt inner = new NestedAttempt(true);
        NestedAttempt outer = new NestedAttempt(inner, false);
        outer.run();
        Assert.assertTrue((String)"retry attempts exhausted", (boolean)this.state.isExhausted());
        Assert.assertEquals((String)"retry attempt count", (long)1L, (long)this.state.getInProgressCount());
    }

    @Test
    public void testInnerAttemptRemainsUnfinishedWhenOuterExhausted() throws InterruptedException {
        NestedAttempt inner = new NestedAttempt(false);
        NestedAttempt outer = new NestedAttempt(inner, true);
        outer.run();
        Assert.assertTrue((String)"retry attempts exhausted", (boolean)this.state.isExhausted());
        Assert.assertEquals((String)"retry attempt count", (long)1L, (long)this.state.getInProgressCount());
    }

    private class NestedAttempt
    implements Runnable {
        private final NestedAttempt nestedAttempt;
        private final boolean shouldExhaust;

        NestedAttempt(boolean shouldExhaust) {
            this(null, shouldExhaust);
        }

        NestedAttempt(NestedAttempt nestedAttempt, boolean shouldExhaust) {
            this.nestedAttempt = nestedAttempt;
            this.shouldExhaust = shouldExhaust;
        }

        @Override
        public void run() {
            TestRetryAttemptState.this.state.signalStart();
            if (this.nestedAttempt != null) {
                this.nestedAttempt.run();
            }
            if (this.shouldExhaust) {
                TestRetryAttemptState.this.state.signalExhausted();
            } else {
                TestRetryAttemptState.this.state.signalEnd();
            }
        }
    }

    private class ExhaustingAttempt
    implements Runnable {
        private ExhaustingAttempt() {
        }

        @Override
        public void run() {
            TestRetryAttemptState.this.state.signalStart();
            TestRetryAttemptState.this.state.signalExhausted();
        }
    }
}

