/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.graph;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.graph.GraphGenerator;
import org.apache.oozie.util.graph.GraphRenderer;
import org.apache.oozie.util.graph.GraphvizRenderer;
import org.apache.oozie.util.graph.OutputFormat;
import org.junit.Assert;

public class TestGraphGenerator
extends XTestCase {
    private static final String GRAPH_WORKFLOW_DECISION_FORK_JOIN_XML = "graph-workflow-decision-fork-join.xml";
    private static final String GRAPH_WORKFLOW_MANY_ACTIONS_XML = "graph-workflow-many-actions.xml";
    private static final String GRAPH_WORKFLOW_SIMPLE_XML = "graph-workflow-simple.xml";
    private static final String GRAPH_WORKFLOW_INVALID_XML = "graph-workflow-invalid.xml";
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSimpleGraphPng() {
        WorkflowJobBean jsonWFJob = this.createSimpleWorkflow();
        this.generateAndAssertPng(jsonWFJob, GRAPH_WORKFLOW_SIMPLE_XML, false);
        this.generateAndAssertPng(jsonWFJob, GRAPH_WORKFLOW_SIMPLE_XML, true);
        try {
            String content = IOUtils.getResourceAsString((String)GRAPH_WORKFLOW_INVALID_XML, (int)-1);
            GraphGenerator g = new GraphGenerator(content, (WorkflowJob)jsonWFJob, true, (GraphRenderer)new GraphvizRenderer());
            g.write((OutputStream)new NullOutputStream(), OutputFormat.PNG);
        }
        catch (Exception e) {
            Assert.fail((String)("Write PNG shouldn't have failed for graph-workflow-invalid.xml call: " + e.getMessage()));
        }
    }

    private WorkflowJobBean createSimpleWorkflow() {
        WorkflowJobBean jsonWFJob = new WorkflowJobBean();
        jsonWFJob.setAppName("My Test App");
        jsonWFJob.setId("My Test ID");
        return jsonWFJob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAndAssertPng(WorkflowJobBean workflowJob, String path, boolean showKill) {
        File outputPng = null;
        try {
            outputPng = File.createTempFile("graph-output", path + ".png");
            String content = IOUtils.getResourceAsString((String)path, (int)-1);
            GraphGenerator g = new GraphGenerator(content, (WorkflowJob)workflowJob, showKill, (GraphRenderer)new GraphvizRenderer());
            g.write((OutputStream)new FileOutputStream(outputPng), OutputFormat.PNG);
            Assert.assertNotNull((String)"PNG read error", (Object)ImageIO.read(new FileInputStream(outputPng)));
        }
        catch (Exception e) {
            Assert.fail((String)String.format("Render and write PNG failed for %s: %s", path, e.getMessage()));
        }
        finally {
            if (outputPng != null) {
                outputPng.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleGraphDot() {
        WorkflowJobBean jsonWFJob = this.createSimpleWorkflow();
        File outputDot = null;
        try {
            outputDot = File.createTempFile("graph-output", "graph-workflow-simple.dot");
            String content = IOUtils.getResourceAsString((String)GRAPH_WORKFLOW_SIMPLE_XML, (int)-1);
            GraphGenerator g = new GraphGenerator(content, (WorkflowJob)jsonWFJob, true, (GraphRenderer)new GraphvizRenderer());
            g.write((OutputStream)new FileOutputStream(outputDot), OutputFormat.DOT);
            BufferedReader dotReader = new BufferedReader(new FileReader(outputDot));
            Assert.assertTrue((String)"Rendered and written graph output file is not a DOT file", (boolean)dotReader.readLine().equals("digraph {"));
        }
        catch (Exception e) {
            Assert.fail((String)("Render and write DOT failed: " + e.getMessage()));
        }
        finally {
            if (outputDot != null) {
                outputDot.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleGraphSvg() {
        WorkflowJobBean jsonWFJob = this.createSimpleWorkflow();
        File outputDot = null;
        try {
            outputDot = File.createTempFile("graph-output", "graph-workflow-simple.svg");
            String content = IOUtils.getResourceAsString((String)GRAPH_WORKFLOW_SIMPLE_XML, (int)-1);
            GraphGenerator g = new GraphGenerator(content, (WorkflowJob)jsonWFJob, true, (GraphRenderer)new GraphvizRenderer());
            g.write((OutputStream)new FileOutputStream(outputDot), OutputFormat.SVG);
            BufferedReader svgReader = new BufferedReader(new FileReader(outputDot));
            Assert.assertTrue((String)"Rendered and written graph output file is not an SVG file", (boolean)svgReader.readLine().startsWith("<svg "));
        }
        catch (Exception e) {
            Assert.fail((String)("Render and write SVG failed: " + e.getMessage()));
        }
        finally {
            if (outputDot != null) {
                outputDot.delete();
            }
        }
    }

    public void testGraphWithManyNodes() throws Exception {
        new GraphGenerator(this.readXmlFromClasspath(GRAPH_WORKFLOW_MANY_ACTIONS_XML), (WorkflowJob)this.createWorkflowInProgress(25), true, (GraphRenderer)new GraphvizRenderer()).write((OutputStream)new NullOutputStream(), OutputFormat.PNG);
    }

    private String readXmlFromClasspath(String classpathLocation) throws IOException {
        return IOUtils.getResourceAsString((String)classpathLocation, (int)-1);
    }

    public void testGraphWithDecisionForkJoin() throws Exception {
        new GraphGenerator(this.readXmlFromClasspath(GRAPH_WORKFLOW_DECISION_FORK_JOIN_XML), (WorkflowJob)this.createWorkflowWithDecisionForkJoin(), true, (GraphRenderer)new GraphvizRenderer()).write((OutputStream)new NullOutputStream(), OutputFormat.PNG);
    }

    private WorkflowJobBean createWorkflowInProgress(int actionNodeCount) {
        WorkflowJobBean workflowJobBean = this.createSimpleWorkflow();
        workflowJobBean.getActions().add(this.createAction("start", "start", WorkflowAction.Status.DONE));
        int ixRunning = (int)Math.floor(Math.random() * (double)actionNodeCount);
        for (int ixNode = 0; ixNode < actionNodeCount; ++ixNode) {
            WorkflowAction.Status status = ixNode < ixRunning ? WorkflowAction.Status.DONE : (ixNode == ixRunning ? WorkflowAction.Status.RUNNING : WorkflowAction.Status.PREP);
            workflowJobBean.getActions().add(this.createAction(String.format("pig-%d", ixNode), "pig", status));
        }
        workflowJobBean.getActions().add(this.createAction("kill", "kill", WorkflowAction.Status.PREP));
        workflowJobBean.getActions().add(this.createAction("end", "end", WorkflowAction.Status.PREP));
        return workflowJobBean;
    }

    private WorkflowJobBean createWorkflowWithDecisionForkJoin() {
        WorkflowJobBean workflowJobBean = this.createSimpleWorkflow();
        workflowJobBean.getActions().add(this.createAction("start", "start", WorkflowAction.Status.DONE));
        workflowJobBean.getActions().add(this.createAction("decision", "decision", WorkflowAction.Status.DONE));
        workflowJobBean.getActions().add(this.createAction("pig-0", "pig", WorkflowAction.Status.PREP));
        workflowJobBean.getActions().add(this.createAction("fork", "fork", WorkflowAction.Status.DONE));
        workflowJobBean.getActions().add(this.createAction("pig-1", "pig", WorkflowAction.Status.DONE));
        workflowJobBean.getActions().add(this.createAction("pig-2", "pig", WorkflowAction.Status.RUNNING));
        workflowJobBean.getActions().add(this.createAction("join", "join", WorkflowAction.Status.PREP));
        workflowJobBean.getActions().add(this.createAction("kill", "kill", WorkflowAction.Status.PREP));
        workflowJobBean.getActions().add(this.createAction("end", "end", WorkflowAction.Status.PREP));
        return workflowJobBean;
    }

    private WorkflowAction createAction(String name, String type, WorkflowAction.Status status) {
        WorkflowActionBean workflowActionBean = new WorkflowActionBean();
        workflowActionBean.setName(name);
        workflowActionBean.setType(type);
        workflowActionBean.setStatus(status);
        return workflowActionBean;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

