/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.junit.Test;

public class TestLiteWorkflowApp
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testReadWrite() throws Exception {
        String definition = "test" + RandomStringUtils.random((int)102400);
        LiteWorkflowApp app = new LiteWorkflowApp("name", definition, new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "foo"));
        app.addNode((NodeDef)new EndNodeDef("foo", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        app.write((DataOutput)out);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream in = new DataInputStream(bais);
        LiteWorkflowApp app2 = new LiteWorkflowApp();
        app2.readFields((DataInput)in);
        TestLiteWorkflowApp.assertTrue((boolean)app.equals(app2));
    }

    @Test
    public void testOldFormatRead() throws Exception {
        String definition = Strings.repeat((String)"abcdefghijk", (int)6234);
        LiteWorkflowApp app = new LiteWorkflowApp("name", definition, new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "foo"));
        app.addNode((NodeDef)new EndNodeDef("foo", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        DataInputStream in = new DataInputStream(IOUtils.getResourceAsStream((String)"oldWorkFlowApp.serialized", (int)-1));
        LiteWorkflowApp app2 = new LiteWorkflowApp();
        app2.readFields((DataInput)in);
        TestLiteWorkflowApp.assertTrue((boolean)app.equals(app2));
    }
}

