/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.WritableUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.ControlNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestLiteWorkflowLib
extends XTestCase {
    static Map<String, Integer> enters = new HashMap<String, Integer>();
    static Map<String, Integer> exits = new HashMap<String, Integer>();
    static Map<String, Integer> kills = new HashMap<String, Integer>();
    static Map<String, Integer> fails = new HashMap<String, Integer>();
    static int enterCounter = 0;
    static int exitCounter = 0;
    static int killCounter = 0;
    static int failCounter = 0;
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        enters.clear();
        exits.clear();
        kills.clear();
        fails.clear();
        enterCounter = 0;
        exitCounter = 0;
        killCounter = 0;
        failCounter = 0;
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testEmptyWorkflow() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        final LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        job.start();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return job.getStatus() == WorkflowInstance.Status.SUCCEEDED;
            }
        });
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
    }

    public void testKillWorkflow() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "kill")).addNode((NodeDef)new KillNodeDef("kill", "killed", TestControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.KILLED, (Object)job.getStatus());
    }

    public void testWorkflowStates() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, AsynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        job.kill();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.KILLED, (Object)job.getStatus());
        job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.fail("one");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)job.getStatus());
        job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        try {
            job.suspend();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.resume();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        try {
            job.resume();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.start();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        job.suspend();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUSPENDED, (Object)job.getStatus());
        try {
            job.suspend();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.start();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        job.resume();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        try {
            job.resume();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.start();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        job.kill();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.KILLED, (Object)job.getStatus());
        try {
            job.kill();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.suspend();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.resume();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        try {
            job.start();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
    }

    public void testSynchSimple() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)1, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testNodeContext() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, TestRootContextHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.setVar("a", "A");
        job.setTransientVar("ta", (Object)"AA");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((String)"B", (String)job.getVar("b"));
        TestLiteWorkflowLib.assertEquals((Object)"BB", (Object)job.getTransientVar("tb"));
        TestLiteWorkflowLib.assertEquals((int)1, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testSynchDouble() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("two"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)2, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testAsynchSimple() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, AsynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)1, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testInvalidExecutionPath() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, AsynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/a/", "");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)job.getStatus());
    }

    public void testSimpleFork() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("f"))).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("two", "three"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("three", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "four")).addNode(new NodeDef("four", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)4, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)4, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
        TestLiteWorkflowLib.assertTrue((enters.get("one") < enters.get("two") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("one") < enters.get("three") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("three") < enters.get("four") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("two") < enters.get("four") ? 1 : 0) != 0);
    }

    public void testForkedContext() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("a", "b"))).addNode(new NodeDef("a", null, TestForkedContextHandler.class, Arrays.asList("j"))).addNode(new NodeDef("b", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
    }

    public void testNestedFork() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("testWf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("f"))).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("two", "three"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("f2"))).addNode(new NodeDef("three", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new ForkNodeDef("f2", TestControlNodeHandler.class, Arrays.asList("four", "five", "six"))).addNode(new NodeDef("four", null, SynchNodeHandler.class, Arrays.asList("j2"))).addNode(new NodeDef("five", null, SynchNodeHandler.class, Arrays.asList("j2"))).addNode(new NodeDef("six", null, SynchNodeHandler.class, Arrays.asList("j2"))).addNode((NodeDef)new JoinNodeDef("j2", TestControlNodeHandler.class, "seven")).addNode(new NodeDef("seven", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "abcde");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)7, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)7, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
        TestLiteWorkflowLib.assertTrue((enters.get("one") < enters.get("two") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("one") < enters.get("three") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("two") < enters.get("four") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("four") < enters.get("seven") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("five") < enters.get("seven") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((enters.get("six") < enters.get("seven") ? 1 : 0) != 0);
    }

    public void testKillWithRunningNodes() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("a", "b"))).addNode(new NodeDef("a", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("b", null, AsynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.kill();
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testFailWithRunningNodes() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("a", "b"))).addNode(new NodeDef("a", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("b", null, AsynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.fail("b");
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)fails.size());
    }

    public void testDoneWithRunningNodes() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("a", "b"))).addNode(new NodeDef("a", null, AsynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("b", null, AsynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/b/", "");
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testWFKillWithRunningNodes() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("a", "b"))).addNode(new NodeDef("a", null, AsynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("b", null, AsynchNodeHandler.class, Arrays.asList("kill"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new KillNodeDef("kill", "killed", TestControlNodeHandler.class)).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/b/", "");
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testWfFailWithRunningNodes() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "f")).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("a", "b"))).addNode(new NodeDef("a", null, AsynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("b", null, AsynchNodeHandler.class, Arrays.asList("x"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        try {
            job.start();
            job.signal("/b/", "");
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)fails.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)1, (int)fails.size());
    }

    public void testDecision() throws WorkflowException {
        ArrayList<String> decTrans = new ArrayList<String>();
        decTrans.add("one");
        decTrans.add("two");
        decTrans.add("three");
        LiteWorkflowApp def = new LiteWorkflowApp("testWf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "d")).addNode((NodeDef)new DecisionNodeDef("d", "", TestDecisionNodeHandler.class, decTrans)).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode(new NodeDef("three", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "abcde");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "one");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)2, (int)exits.size());
        TestLiteWorkflowLib.assertTrue((boolean)enters.containsKey("one"));
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("two") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("three") ? 1 : 0) != 0);
        enters.clear();
        job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "abcde");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "two");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("one") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((boolean)enters.containsKey("two"));
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("three") ? 1 : 0) != 0);
        enters.clear();
        job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "abcde");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "three");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("one") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("two") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((boolean)enters.containsKey("three"));
        enters.clear();
        job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "abcde");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        try {
            job.signal("/", "bla");
            TestLiteWorkflowLib.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)job.getStatus());
    }

    public void testActionOKError() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "a")).addNode((NodeDef)new ActionNodeDef("a", "", TestActionNodeHandler.class, "b", "c")).addNode(new NodeDef("b", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode(new NodeDef("c", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "OK");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertTrue((boolean)enters.containsKey("b"));
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("c") ? 1 : 0) != 0);
        enters.clear();
        job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "ERROR");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
        TestLiteWorkflowLib.assertTrue((!enters.containsKey("b") ? 1 : 0) != 0);
        TestLiteWorkflowLib.assertTrue((boolean)enters.containsKey("c"));
    }

    public void testJobPersistance() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, AsynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        job.setVar("a", "A");
        job.setTransientVar("b", (Object)"B");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((String)"A", (String)job.getVar("a"));
        TestLiteWorkflowLib.assertEquals((Object)"B", (Object)job.getTransientVar("b"));
        TestLiteWorkflowLib.assertEquals((String)"1", (String)job.getId());
        byte[] array = WritableUtils.toByteArray((Writable)job);
        job = (LiteWorkflowInstance)WritableUtils.fromByteArray((byte[])array, LiteWorkflowInstance.class);
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((String)"A", (String)job.getVar("a"));
        TestLiteWorkflowLib.assertEquals(null, (Object)job.getTransientVar("b"));
        TestLiteWorkflowLib.assertEquals((String)"1", (String)job.getId());
        job.start();
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        array = WritableUtils.toByteArray((Writable)job);
        job = (LiteWorkflowInstance)WritableUtils.fromByteArray((byte[])array, LiteWorkflowInstance.class);
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.RUNNING, (Object)job.getStatus());
        job.signal("/", "");
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.SUCCEEDED, (Object)job.getStatus());
    }

    public void testJobPersistanceMoreThan64K() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, AsynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        String value = RandomStringUtils.randomAlphanumeric((int)102400);
        job.setVar("a", value);
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((String)value, (String)job.getVar("a"));
        byte[] array = WritableUtils.toByteArray((Writable)job);
        job = (LiteWorkflowInstance)WritableUtils.fromByteArray((byte[])array, LiteWorkflowInstance.class);
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.PREP, (Object)job.getStatus());
        TestLiteWorkflowLib.assertEquals((String)value, (String)job.getVar("a"));
    }

    public void testImmediateError() throws WorkflowException {
        LiteWorkflowApp workflowDef = new LiteWorkflowApp("testWf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("two"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("four"))).addNode(new NodeDef("three", null, SynchNodeHandler.class, Arrays.asList("end"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance workflowJob = new LiteWorkflowInstance(workflowDef, (Configuration)new XConfiguration(), "abcde");
        try {
            workflowJob.start();
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)workflowJob.getStatus());
        TestLiteWorkflowLib.assertEquals((int)2, (int)enters.size());
        TestLiteWorkflowLib.assertEquals((int)2, (int)exits.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)kills.size());
        TestLiteWorkflowLib.assertEquals((int)0, (int)fails.size());
    }

    public void testSelfTransition() throws WorkflowException {
        try {
            new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("one"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowLib.assertEquals((Object)ErrorCode.E0706, (Object)ex.getErrorCode());
        }
    }

    public void testLoopSimple() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("two"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("one"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        try {
            job.start();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowLib.assertEquals((Object)ErrorCode.E0709, (Object)ex.getErrorCode());
        }
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)job.getStatus());
    }

    public void testLoopFork() throws WorkflowException {
        LiteWorkflowApp def = new LiteWorkflowApp("wf", "<worklfow-app/>", new StartNodeDef(TestControlNodeHandler.class, "one")).addNode(new NodeDef("one", null, SynchNodeHandler.class, Arrays.asList("f"))).addNode((NodeDef)new ForkNodeDef("f", TestControlNodeHandler.class, Arrays.asList("two", "three"))).addNode(new NodeDef("two", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode(new NodeDef("three", null, SynchNodeHandler.class, Arrays.asList("j"))).addNode((NodeDef)new JoinNodeDef("j", TestControlNodeHandler.class, "four")).addNode(new NodeDef("four", null, SynchNodeHandler.class, Arrays.asList("f"))).addNode((NodeDef)new EndNodeDef("end", TestControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)new XConfiguration(), "1");
        try {
            job.start();
            TestLiteWorkflowLib.fail();
        }
        catch (WorkflowException ex) {
            TestLiteWorkflowLib.assertEquals((Object)ErrorCode.E0709, (Object)ex.getErrorCode());
        }
        TestLiteWorkflowLib.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)job.getStatus());
    }

    public static class TestForkedContextHandler
    extends SynchNodeHandler {
        @Override
        public boolean enter(NodeHandler.Context context) {
            TestCase.assertNotNull((Object)context.getNodeDef());
            TestCase.assertNotNull((Object)context.getSignalValue());
            TestCase.assertNotNull((Object)context.getProcessInstance());
            TestCase.assertEquals((String)"/a/", (String)context.getExecutionPath());
            TestCase.assertEquals((String)"/", (String)context.getParentExecutionPath("/a/"));
            return super.enter(context);
        }
    }

    public static class TestRootContextHandler
    extends SynchNodeHandler {
        @Override
        public boolean enter(NodeHandler.Context context) {
            TestCase.assertNotNull((Object)context.getNodeDef());
            TestCase.assertNotNull((Object)context.getSignalValue());
            TestCase.assertNotNull((Object)context.getProcessInstance());
            TestCase.assertEquals((String)"/", (String)context.getExecutionPath());
            TestCase.assertEquals(null, (String)context.getParentExecutionPath("/"));
            TestCase.assertEquals((String)"A", (String)context.getVar("a"));
            TestCase.assertEquals((Object)"AA", (Object)context.getTransientVar("ta"));
            context.setVar("b", "B");
            context.setTransientVar("tb", (Object)"BB");
            return super.enter(context);
        }

        @Override
        public String exit(NodeHandler.Context context) {
            TestCase.assertEquals((String)"A", (String)context.getVar("a"));
            TestCase.assertEquals((Object)"AA", (Object)context.getTransientVar("ta"));
            context.setVar("b", "B");
            context.setTransientVar("tb", (Object)"BB");
            return super.exit(context);
        }
    }

    public static class TestControlNodeHandler
    extends ControlNodeHandler {
        public boolean enter(NodeHandler.Context context) throws WorkflowException {
            boolean done = true;
            super.enter(context);
            Class<?> nodeClass = context.getNodeDef().getClass();
            if (nodeClass.equals(JoinNodeDef.class)) {
                String parentExecutionPath = context.getExecutionPath();
                String forkCount = context.getVar("workflow.fork." + parentExecutionPath);
                done = forkCount == null;
            }
            return done;
        }

        public void touch(NodeHandler.Context context) throws WorkflowException {
        }
    }

    public static class TestDecisionNodeHandler
    extends DecisionNodeHandler {
        public void start(NodeHandler.Context context) {
            enters.put(context.getNodeDef().getName(), enterCounter++);
        }

        public void end(NodeHandler.Context context) {
            exits.put(context.getNodeDef().getName(), exitCounter++);
        }
    }

    public static class TestActionNodeHandler
    extends ActionNodeHandler {
        public void start(NodeHandler.Context context) {
        }

        public void end(NodeHandler.Context context) {
        }
    }

    public static class SynchNodeHandler
    extends BaseNodeHandler {
        public SynchNodeHandler() {
            super(true);
        }
    }

    public static class AsynchNodeHandler
    extends BaseNodeHandler {
        public AsynchNodeHandler() {
            super(false);
        }
    }

    public static abstract class BaseNodeHandler
    extends NodeHandler {
        private boolean synch;

        protected BaseNodeHandler(Boolean synch) {
            this.synch = synch;
        }

        public boolean enter(NodeHandler.Context context) {
            enters.put(context.getNodeDef().getName(), enterCounter++);
            return this.synch;
        }

        public String exit(NodeHandler.Context context) {
            exits.put(context.getNodeDef().getName(), exitCounter++);
            return (String)context.getNodeDef().getTransitions().get(0);
        }

        public void kill(NodeHandler.Context context) {
            kills.put(context.getNodeDef().getName(), killCounter++);
        }

        public void fail(NodeHandler.Context context) {
            fails.put(context.getNodeDef().getName(), failCounter++);
        }
    }
}

