/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.TezJobMonitor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.tez.client.TezClient;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.mapreduce.hadoop.MRHelpers;

public class TezSessionState {
    private static final Log LOG = LogFactory.getLog((String)TezSessionState.class.getName());
    private static final String TEZ_DIR = "_tez_session_dir";
    private HiveConf conf;
    private Path tezScratchDir;
    private LocalResource appJarLr;
    private TezClient session;
    private String sessionId;
    private final DagUtils utils;
    private String queueName;
    private boolean defaultQueue = false;
    private String user;
    private final Set<String> additionalFilesNotFromConf = new HashSet<String>();
    private final Set<LocalResource> localizedResources = new HashSet<LocalResource>();
    private boolean doAsEnabled;
    private static List<TezSessionState> openSessions = Collections.synchronizedList(new LinkedList());

    public TezSessionState(DagUtils utils) {
        this.utils = utils;
    }

    public TezSessionState(String sessionId) {
        this(DagUtils.getInstance());
        this.sessionId = sessionId;
    }

    public boolean isOpen() {
        return this.session != null;
    }

    public static List<TezSessionState> getOpenSessions() {
        return openSessions;
    }

    public static String makeSessionId() {
        return UUID.randomUUID().toString();
    }

    public void open(HiveConf conf) throws IOException, LoginException, URISyntaxException, TezException {
        this.open(conf, null);
    }

    public void open(HiveConf conf, String[] additionalFiles) throws IOException, LoginException, IllegalArgumentException, URISyntaxException, TezException {
        this.conf = conf;
        this.queueName = conf.get("tez.queue.name");
        this.doAsEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        UserGroupInformation ugi = Utils.getUGI();
        this.user = ugi.getShortUserName();
        LOG.info((Object)("User of session id " + this.sessionId + " is " + this.user));
        this.tezScratchDir = this.createTezDir(this.sessionId);
        this.additionalFilesNotFromConf.clear();
        if (additionalFiles != null) {
            for (String originalFile : additionalFiles) {
                this.additionalFilesNotFromConf.add(originalFile);
            }
        }
        this.refreshLocalResourcesFromConf(conf);
        this.appJarLr = this.createJarLocalResource(this.utils.getExecJarPathLocal());
        HashMap<String, LocalResource> commonLocalResources = new HashMap<String, LocalResource>();
        commonLocalResources.put(this.utils.getBaseName(this.appJarLr), this.appJarLr);
        for (LocalResource lr : this.localizedResources) {
            commonLocalResources.put(this.utils.getBaseName(lr), lr);
        }
        HashMap amEnv = new HashMap();
        MRHelpers.updateEnvBasedOnMRAMEnv((Configuration)conf, amEnv);
        TezConfiguration tezConfig = new TezConfiguration((Configuration)conf);
        tezConfig.set("tez.staging-dir", this.tezScratchDir.toUri().toString());
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_ENABLED)) {
            int n = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS);
            n = Math.max(tezConfig.getInt("tez.am.session.min.held-containers", 0), n);
            tezConfig.setInt("tez.am.session.min.held-containers", n);
        }
        this.session = TezClient.create((String)("HIVE-" + this.sessionId), (TezConfiguration)tezConfig, (boolean)true, commonLocalResources, null);
        LOG.info((Object)("Opening new Tez Session (id: " + this.sessionId + ", scratch dir: " + this.tezScratchDir + ")"));
        TezJobMonitor.initShutdownHook();
        this.session.start();
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_ENABLED)) {
            int n = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS);
            LOG.info((Object)("Prewarming " + n + " containers  (id: " + this.sessionId + ", scratch dir: " + this.tezScratchDir + ")"));
            PreWarmVertex prewarmVertex = this.utils.createPreWarmVertex(tezConfig, n, commonLocalResources);
            try {
                this.session.preWarm(prewarmVertex);
            }
            catch (IOException ie) {
                if (ie.getMessage().contains("Interrupted while waiting")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Hive Prewarm threw an exception ", (Throwable)ie);
                    }
                }
                throw ie;
            }
        }
        try {
            this.session.waitTillReady();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        openSessions.add(this);
    }

    public void refreshLocalResourcesFromConf(HiveConf conf) throws IOException, LoginException, IllegalArgumentException, URISyntaxException, TezException {
        List<LocalResource> handlerLr;
        String dir = this.tezScratchDir.toString();
        this.localizedResources.clear();
        List<LocalResource> lrs = this.utils.localizeTempFilesFromConf(dir, (Configuration)conf);
        if (lrs != null) {
            this.localizedResources.addAll(lrs);
        }
        if ((handlerLr = this.utils.localizeTempFiles(dir, (Configuration)conf, this.additionalFilesNotFromConf.toArray(new String[this.additionalFilesNotFromConf.size()]))) != null) {
            this.localizedResources.addAll(handlerLr);
        }
    }

    public boolean hasResources(String[] localAmResources) {
        if (localAmResources == null || localAmResources.length == 0) {
            return true;
        }
        if (this.additionalFilesNotFromConf.isEmpty()) {
            return false;
        }
        for (String s : localAmResources) {
            if (this.additionalFilesNotFromConf.contains(s)) continue;
            return false;
        }
        return true;
    }

    public void close(boolean keepTmpDir) throws TezException, IOException {
        if (!this.isOpen()) {
            return;
        }
        LOG.info((Object)"Closing Tez Session");
        try {
            this.session.stop();
            openSessions.remove(this);
        }
        catch (SessionNotRunning sessionNotRunning) {
            // empty catch block
        }
        if (!keepTmpDir) {
            this.cleanupScratchDir();
        }
        this.session = null;
        this.tezScratchDir = null;
        this.conf = null;
        this.appJarLr = null;
        this.additionalFilesNotFromConf.clear();
        this.localizedResources.clear();
    }

    public void cleanupScratchDir() throws IOException {
        FileSystem fs = this.tezScratchDir.getFileSystem((Configuration)this.conf);
        fs.delete(this.tezScratchDir, true);
        this.tezScratchDir = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public TezClient getSession() {
        return this.session;
    }

    public Path getTezScratchDir() {
        return this.tezScratchDir;
    }

    public LocalResource getAppJarLr() {
        return this.appJarLr;
    }

    private Path createTezDir(String sessionId) throws IOException {
        Path tezDir = new Path(SessionState.get().getHdfsScratchDirURIString(), TEZ_DIR);
        tezDir = new Path(tezDir, sessionId);
        FileSystem fs = tezDir.getFileSystem((Configuration)this.conf);
        FsPermission fsPermission = new FsPermission(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIRPERMISSION));
        fs.mkdirs(tezDir, fsPermission);
        tezDir = DagUtils.validateTargetDir(tezDir, (Configuration)this.conf).getPath();
        fs.deleteOnExit(tezDir);
        return tezDir;
    }

    private LocalResource createJarLocalResource(String localJarPath) throws IOException, LoginException, IllegalArgumentException, FileNotFoundException {
        FileStatus destDirStatus = this.utils.getHiveJarDirectory((Configuration)this.conf);
        assert (destDirStatus != null);
        Path destDirPath = destDirStatus.getPath();
        Path localFile = new Path(localJarPath);
        String sha = this.getSha(localFile);
        String destFileName = localFile.getName();
        destFileName = FilenameUtils.removeExtension((String)destFileName) + "-" + sha + '.' + FilenameUtils.getExtension((String)destFileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The destination file name for [" + localJarPath + "] is " + destFileName));
        }
        Path destFile = new Path(destDirPath.toString() + "/" + destFileName);
        return this.utils.localizeResource(localFile, destFile, LocalResourceType.FILE, (Configuration)this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSha(Path localFile) throws IOException, IllegalArgumentException {
        try (InputStream is = null;){
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
            is = localFs.open(localFile);
            String string = DigestUtils.sha256Hex((InputStream)is);
            return string;
        }
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setDefault() {
        this.defaultQueue = true;
    }

    public boolean isDefault() {
        return this.defaultQueue;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public List<LocalResource> getLocalizedResources() {
        return new ArrayList<LocalResource>(this.localizedResources);
    }

    public String getUser() {
        return this.user;
    }

    public boolean getDoAsEnabled() {
        return this.doAsEnabled;
    }
}

