/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.orc.BinaryColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.BooleanColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DateColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DecimalColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.DoubleColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.IntegerColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.StringColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.TimestampColumnStatistics;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

class ColumnStatisticsImpl
implements ColumnStatistics {
    private long count = 0L;
    private boolean hasNull = false;

    ColumnStatisticsImpl(OrcProto.ColumnStatistics stats) {
        if (stats.hasNumberOfValues()) {
            this.count = stats.getNumberOfValues();
        }
        this.hasNull = stats.hasHasNull() ? stats.getHasNull() : true;
    }

    ColumnStatisticsImpl() {
    }

    void increment() {
        ++this.count;
    }

    void setNull() {
        this.hasNull = true;
    }

    void updateBoolean(boolean value) {
        throw new UnsupportedOperationException("Can't update boolean");
    }

    void updateInteger(long value) {
        throw new UnsupportedOperationException("Can't update integer");
    }

    void updateDouble(double value) {
        throw new UnsupportedOperationException("Can't update double");
    }

    void updateString(Text value) {
        throw new UnsupportedOperationException("Can't update string");
    }

    void updateBinary(BytesWritable value) {
        throw new UnsupportedOperationException("Can't update binary");
    }

    void updateDecimal(HiveDecimal value) {
        throw new UnsupportedOperationException("Can't update decimal");
    }

    void updateDate(DateWritable value) {
        throw new UnsupportedOperationException("Can't update date");
    }

    void updateTimestamp(Timestamp value) {
        throw new UnsupportedOperationException("Can't update timestamp");
    }

    void merge(ColumnStatisticsImpl stats) {
        this.count += stats.count;
        this.hasNull |= stats.hasNull;
    }

    void reset() {
        this.count = 0L;
        this.hasNull = false;
    }

    @Override
    public long getNumberOfValues() {
        return this.count;
    }

    @Override
    public boolean hasNull() {
        return this.hasNull;
    }

    public String toString() {
        return "count: " + this.count + " hasNull: " + this.hasNull;
    }

    OrcProto.ColumnStatistics.Builder serialize() {
        OrcProto.ColumnStatistics.Builder builder = OrcProto.ColumnStatistics.newBuilder();
        builder.setNumberOfValues(this.count);
        builder.setHasNull(this.hasNull);
        return builder;
    }

    static ColumnStatisticsImpl create(ObjectInspector inspector) {
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                switch (((PrimitiveObjectInspector)inspector).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return new BooleanStatisticsImpl();
                    }
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case LONG: {
                        return new IntegerStatisticsImpl();
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new DoubleStatisticsImpl();
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        return new StringStatisticsImpl();
                    }
                    case DECIMAL: {
                        return new DecimalStatisticsImpl();
                    }
                    case DATE: {
                        return new DateStatisticsImpl();
                    }
                    case TIMESTAMP: {
                        return new TimestampStatisticsImpl();
                    }
                    case BINARY: {
                        return new BinaryStatisticsImpl();
                    }
                }
                return new ColumnStatisticsImpl();
            }
        }
        return new ColumnStatisticsImpl();
    }

    static ColumnStatisticsImpl deserialize(OrcProto.ColumnStatistics stats) {
        if (stats.hasBucketStatistics()) {
            return new BooleanStatisticsImpl(stats);
        }
        if (stats.hasIntStatistics()) {
            return new IntegerStatisticsImpl(stats);
        }
        if (stats.hasDoubleStatistics()) {
            return new DoubleStatisticsImpl(stats);
        }
        if (stats.hasStringStatistics()) {
            return new StringStatisticsImpl(stats);
        }
        if (stats.hasDecimalStatistics()) {
            return new DecimalStatisticsImpl(stats);
        }
        if (stats.hasDateStatistics()) {
            return new DateStatisticsImpl(stats);
        }
        if (stats.hasTimestampStatistics()) {
            return new TimestampStatisticsImpl(stats);
        }
        if (stats.hasBinaryStatistics()) {
            return new BinaryStatisticsImpl(stats);
        }
        return new ColumnStatisticsImpl(stats);
    }

    private static final class TimestampStatisticsImpl
    extends ColumnStatisticsImpl
    implements TimestampColumnStatistics {
        private Long minimum = null;
        private Long maximum = null;

        TimestampStatisticsImpl() {
        }

        TimestampStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.TimestampStatistics timestampStats = stats.getTimestampStatistics();
            if (timestampStats.hasMaximum()) {
                this.maximum = timestampStats.getMaximum();
            }
            if (timestampStats.hasMinimum()) {
                this.minimum = timestampStats.getMinimum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.minimum = null;
            this.maximum = null;
        }

        @Override
        void updateTimestamp(Timestamp value) {
            if (this.minimum == null) {
                this.minimum = value.getTime();
                this.maximum = value.getTime();
            } else if (this.minimum > value.getTime()) {
                this.minimum = value.getTime();
            } else if (this.maximum < value.getTime()) {
                this.maximum = value.getTime();
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            TimestampStatisticsImpl timestampStats = (TimestampStatisticsImpl)other;
            if (this.minimum == null) {
                this.minimum = timestampStats.minimum;
                this.maximum = timestampStats.maximum;
            } else if (timestampStats.minimum != null) {
                if (this.minimum > timestampStats.minimum) {
                    this.minimum = timestampStats.minimum;
                }
                if (this.maximum < timestampStats.maximum) {
                    this.maximum = timestampStats.maximum;
                }
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.TimestampStatistics.Builder timestampStats = OrcProto.TimestampStatistics.newBuilder();
            if (this.getNumberOfValues() != 0L) {
                timestampStats.setMinimum(this.minimum);
                timestampStats.setMaximum(this.maximum);
            }
            result.setTimestampStatistics(timestampStats);
            return result;
        }

        @Override
        public Timestamp getMinimum() {
            Timestamp minTimestamp = new Timestamp(this.minimum);
            return minTimestamp;
        }

        @Override
        public Timestamp getMaximum() {
            Timestamp maxTimestamp = new Timestamp(this.maximum);
            return maxTimestamp;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
            }
            return buf.toString();
        }
    }

    private static final class DateStatisticsImpl
    extends ColumnStatisticsImpl
    implements DateColumnStatistics {
        private Integer minimum = null;
        private Integer maximum = null;
        private final transient DateWritable minDate = new DateWritable();
        private final transient DateWritable maxDate = new DateWritable();

        DateStatisticsImpl() {
        }

        DateStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.DateStatistics dateStats = stats.getDateStatistics();
            if (dateStats.hasMaximum()) {
                this.maximum = dateStats.getMaximum();
            }
            if (dateStats.hasMinimum()) {
                this.minimum = dateStats.getMinimum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.minimum = null;
            this.maximum = null;
        }

        @Override
        void updateDate(DateWritable value) {
            if (this.minimum == null) {
                this.minimum = value.getDays();
                this.maximum = value.getDays();
            } else if (this.minimum > value.getDays()) {
                this.minimum = value.getDays();
            } else if (this.maximum < value.getDays()) {
                this.maximum = value.getDays();
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            DateStatisticsImpl dateStats = (DateStatisticsImpl)other;
            if (this.minimum == null) {
                this.minimum = dateStats.minimum;
                this.maximum = dateStats.maximum;
            } else if (dateStats.minimum != null) {
                if (this.minimum > dateStats.minimum) {
                    this.minimum = dateStats.minimum;
                }
                if (this.maximum < dateStats.maximum) {
                    this.maximum = dateStats.maximum;
                }
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.DateStatistics.Builder dateStats = OrcProto.DateStatistics.newBuilder();
            if (this.getNumberOfValues() != 0L) {
                dateStats.setMinimum(this.minimum);
                dateStats.setMaximum(this.maximum);
            }
            result.setDateStatistics(dateStats);
            return result;
        }

        @Override
        public Date getMinimum() {
            this.minDate.set(this.minimum.intValue());
            return this.minDate.get();
        }

        @Override
        public Date getMaximum() {
            this.maxDate.set(this.maximum.intValue());
            return this.maxDate.get();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" min: ");
                buf.append(this.getMinimum());
                buf.append(" max: ");
                buf.append(this.getMaximum());
            }
            return buf.toString();
        }
    }

    private static final class DecimalStatisticsImpl
    extends ColumnStatisticsImpl
    implements DecimalColumnStatistics {
        private HiveDecimal minimum = null;
        private HiveDecimal maximum = null;
        private HiveDecimal sum = HiveDecimal.ZERO;

        DecimalStatisticsImpl() {
        }

        DecimalStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.DecimalStatistics dec = stats.getDecimalStatistics();
            if (dec.hasMaximum()) {
                this.maximum = HiveDecimal.create((String)dec.getMaximum());
            }
            if (dec.hasMinimum()) {
                this.minimum = HiveDecimal.create((String)dec.getMinimum());
            }
            this.sum = dec.hasSum() ? HiveDecimal.create((String)dec.getSum()) : null;
        }

        @Override
        void reset() {
            super.reset();
            this.minimum = null;
            this.maximum = null;
            this.sum = HiveDecimal.ZERO;
        }

        @Override
        void updateDecimal(HiveDecimal value) {
            if (this.minimum == null) {
                this.minimum = value;
                this.maximum = value;
            } else if (this.minimum.compareTo(value) > 0) {
                this.minimum = value;
            } else if (this.maximum.compareTo(value) < 0) {
                this.maximum = value;
            }
            if (this.sum != null) {
                this.sum = this.sum.add(value);
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            DecimalStatisticsImpl dec = (DecimalStatisticsImpl)other;
            if (this.minimum == null) {
                this.minimum = dec.minimum;
                this.maximum = dec.maximum;
                this.sum = dec.sum;
            } else if (dec.minimum != null) {
                if (this.minimum.compareTo(dec.minimum) > 0) {
                    this.minimum = dec.minimum;
                }
                if (this.maximum.compareTo(dec.maximum) < 0) {
                    this.maximum = dec.maximum;
                }
                this.sum = this.sum == null || dec.sum == null ? null : this.sum.add(dec.sum);
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.DecimalStatistics.Builder dec = OrcProto.DecimalStatistics.newBuilder();
            if (this.getNumberOfValues() != 0L) {
                dec.setMinimum(this.minimum.toString());
                dec.setMaximum(this.maximum.toString());
            }
            if (this.sum != null) {
                dec.setSum(this.sum.toString());
            }
            result.setDecimalStatistics(dec);
            return result;
        }

        @Override
        public HiveDecimal getMinimum() {
            return this.minimum;
        }

        @Override
        public HiveDecimal getMaximum() {
            return this.maximum;
        }

        @Override
        public HiveDecimal getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
                if (this.sum != null) {
                    buf.append(" sum: ");
                    buf.append(this.sum);
                }
            }
            return buf.toString();
        }
    }

    protected static final class BinaryStatisticsImpl
    extends ColumnStatisticsImpl
    implements BinaryColumnStatistics {
        private long sum = 0L;

        BinaryStatisticsImpl() {
        }

        BinaryStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.BinaryStatistics binStats = stats.getBinaryStatistics();
            if (binStats.hasSum()) {
                this.sum = binStats.getSum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.sum = 0L;
        }

        @Override
        void updateBinary(BytesWritable value) {
            this.sum += (long)value.getLength();
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            BinaryStatisticsImpl bin = (BinaryStatisticsImpl)other;
            this.sum += bin.sum;
        }

        @Override
        public long getSum() {
            return this.sum;
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.BinaryStatistics.Builder bin = OrcProto.BinaryStatistics.newBuilder();
            bin.setSum(this.sum);
            result.setBinaryStatistics(bin);
            return result;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" sum: ");
                buf.append(this.sum);
            }
            return buf.toString();
        }
    }

    protected static final class StringStatisticsImpl
    extends ColumnStatisticsImpl
    implements StringColumnStatistics {
        private Text minimum = null;
        private Text maximum = null;
        private long sum = 0L;

        StringStatisticsImpl() {
        }

        StringStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.StringStatistics str = stats.getStringStatistics();
            if (str.hasMaximum()) {
                this.maximum = new Text(str.getMaximum());
            }
            if (str.hasMinimum()) {
                this.minimum = new Text(str.getMinimum());
            }
            if (str.hasSum()) {
                this.sum = str.getSum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.minimum = null;
            this.maximum = null;
            this.sum = 0L;
        }

        @Override
        void updateString(Text value) {
            if (this.minimum == null) {
                this.maximum = this.minimum = new Text(value);
            } else if (this.minimum.compareTo((BinaryComparable)value) > 0) {
                this.minimum = new Text(value);
            } else if (this.maximum.compareTo((BinaryComparable)value) < 0) {
                this.maximum = new Text(value);
            }
            this.sum += (long)value.getLength();
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            StringStatisticsImpl str = (StringStatisticsImpl)other;
            if (this.minimum == null) {
                if (str.minimum != null) {
                    this.maximum = new Text(str.getMaximum());
                    this.minimum = new Text(str.getMinimum());
                } else {
                    this.minimum = null;
                    this.maximum = null;
                }
            } else if (str.minimum != null) {
                if (this.minimum.compareTo((BinaryComparable)str.minimum) > 0) {
                    this.minimum = new Text(str.getMinimum());
                }
                if (this.maximum.compareTo((BinaryComparable)str.maximum) < 0) {
                    this.maximum = new Text(str.getMaximum());
                }
            }
            this.sum += str.sum;
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder result = super.serialize();
            OrcProto.StringStatistics.Builder str = OrcProto.StringStatistics.newBuilder();
            if (this.getNumberOfValues() != 0L) {
                str.setMinimum(this.getMinimum());
                str.setMaximum(this.getMaximum());
                str.setSum(this.sum);
            }
            result.setStringStatistics(str);
            return result;
        }

        @Override
        public String getMinimum() {
            return this.minimum == null ? null : this.minimum.toString();
        }

        @Override
        public String getMaximum() {
            return this.maximum == null ? null : this.maximum.toString();
        }

        @Override
        public long getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.getNumberOfValues() != 0L) {
                buf.append(" min: ");
                buf.append(this.getMinimum());
                buf.append(" max: ");
                buf.append(this.getMaximum());
                buf.append(" sum: ");
                buf.append(this.sum);
            }
            return buf.toString();
        }
    }

    private static final class DoubleStatisticsImpl
    extends ColumnStatisticsImpl
    implements DoubleColumnStatistics {
        private boolean hasMinimum = false;
        private double minimum = Double.MAX_VALUE;
        private double maximum = Double.MIN_VALUE;
        private double sum = 0.0;

        DoubleStatisticsImpl() {
        }

        DoubleStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.DoubleStatistics dbl = stats.getDoubleStatistics();
            if (dbl.hasMinimum()) {
                this.hasMinimum = true;
                this.minimum = dbl.getMinimum();
            }
            if (dbl.hasMaximum()) {
                this.maximum = dbl.getMaximum();
            }
            if (dbl.hasSum()) {
                this.sum = dbl.getSum();
            }
        }

        @Override
        void reset() {
            super.reset();
            this.hasMinimum = false;
            this.minimum = Double.MAX_VALUE;
            this.maximum = Double.MIN_VALUE;
            this.sum = 0.0;
        }

        @Override
        void updateDouble(double value) {
            if (!this.hasMinimum) {
                this.hasMinimum = true;
                this.minimum = value;
                this.maximum = value;
            } else if (value < this.minimum) {
                this.minimum = value;
            } else if (value > this.maximum) {
                this.maximum = value;
            }
            this.sum += value;
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            DoubleStatisticsImpl dbl = (DoubleStatisticsImpl)other;
            if (!this.hasMinimum) {
                this.hasMinimum = dbl.hasMinimum;
                this.minimum = dbl.minimum;
                this.maximum = dbl.maximum;
            } else if (dbl.hasMinimum) {
                if (dbl.minimum < this.minimum) {
                    this.minimum = dbl.minimum;
                }
                if (dbl.maximum > this.maximum) {
                    this.maximum = dbl.maximum;
                }
            }
            this.sum += dbl.sum;
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder builder = super.serialize();
            OrcProto.DoubleStatistics.Builder dbl = OrcProto.DoubleStatistics.newBuilder();
            if (this.hasMinimum) {
                dbl.setMinimum(this.minimum);
                dbl.setMaximum(this.maximum);
            }
            dbl.setSum(this.sum);
            builder.setDoubleStatistics(dbl);
            return builder;
        }

        @Override
        public double getMinimum() {
            return this.minimum;
        }

        @Override
        public double getMaximum() {
            return this.maximum;
        }

        @Override
        public double getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.hasMinimum) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
            }
            buf.append(" sum: ");
            buf.append(this.sum);
            return buf.toString();
        }
    }

    private static final class IntegerStatisticsImpl
    extends ColumnStatisticsImpl
    implements IntegerColumnStatistics {
        private long minimum = Long.MAX_VALUE;
        private long maximum = Long.MIN_VALUE;
        private long sum = 0L;
        private boolean hasMinimum = false;
        private boolean overflow = false;

        IntegerStatisticsImpl() {
        }

        IntegerStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.IntegerStatistics intStat = stats.getIntStatistics();
            if (intStat.hasMinimum()) {
                this.hasMinimum = true;
                this.minimum = intStat.getMinimum();
            }
            if (intStat.hasMaximum()) {
                this.maximum = intStat.getMaximum();
            }
            if (intStat.hasSum()) {
                this.sum = intStat.getSum();
            } else {
                this.overflow = true;
            }
        }

        @Override
        void reset() {
            super.reset();
            this.hasMinimum = false;
            this.minimum = Long.MAX_VALUE;
            this.maximum = Long.MIN_VALUE;
            this.sum = 0L;
            this.overflow = false;
        }

        @Override
        void updateInteger(long value) {
            if (!this.hasMinimum) {
                this.hasMinimum = true;
                this.minimum = value;
                this.maximum = value;
            } else if (value < this.minimum) {
                this.minimum = value;
            } else if (value > this.maximum) {
                this.maximum = value;
            }
            if (!this.overflow) {
                boolean wasPositive = this.sum >= 0L;
                this.sum += value;
                if (value >= 0L == wasPositive) {
                    this.overflow = this.sum >= 0L != wasPositive;
                }
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            IntegerStatisticsImpl otherInt = (IntegerStatisticsImpl)other;
            if (!this.hasMinimum) {
                this.hasMinimum = otherInt.hasMinimum;
                this.minimum = otherInt.minimum;
                this.maximum = otherInt.maximum;
            } else if (otherInt.hasMinimum) {
                if (otherInt.minimum < this.minimum) {
                    this.minimum = otherInt.minimum;
                }
                if (otherInt.maximum > this.maximum) {
                    this.maximum = otherInt.maximum;
                }
            }
            super.merge(other);
            this.overflow |= otherInt.overflow;
            if (!this.overflow) {
                boolean wasPositive = this.sum >= 0L;
                this.sum += otherInt.sum;
                if (otherInt.sum >= 0L == wasPositive) {
                    this.overflow = this.sum >= 0L != wasPositive;
                }
            }
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder builder = super.serialize();
            OrcProto.IntegerStatistics.Builder intb = OrcProto.IntegerStatistics.newBuilder();
            if (this.hasMinimum) {
                intb.setMinimum(this.minimum);
                intb.setMaximum(this.maximum);
            }
            if (!this.overflow) {
                intb.setSum(this.sum);
            }
            builder.setIntStatistics(intb);
            return builder;
        }

        @Override
        public long getMinimum() {
            return this.minimum;
        }

        @Override
        public long getMaximum() {
            return this.maximum;
        }

        @Override
        public boolean isSumDefined() {
            return !this.overflow;
        }

        @Override
        public long getSum() {
            return this.sum;
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(super.toString());
            if (this.hasMinimum) {
                buf.append(" min: ");
                buf.append(this.minimum);
                buf.append(" max: ");
                buf.append(this.maximum);
            }
            if (!this.overflow) {
                buf.append(" sum: ");
                buf.append(this.sum);
            }
            return buf.toString();
        }
    }

    private static final class BooleanStatisticsImpl
    extends ColumnStatisticsImpl
    implements BooleanColumnStatistics {
        private long trueCount = 0L;

        BooleanStatisticsImpl(OrcProto.ColumnStatistics stats) {
            super(stats);
            OrcProto.BucketStatistics bkt = stats.getBucketStatistics();
            this.trueCount = bkt.getCount(0);
        }

        BooleanStatisticsImpl() {
        }

        @Override
        void reset() {
            super.reset();
            this.trueCount = 0L;
        }

        @Override
        void updateBoolean(boolean value) {
            if (value) {
                ++this.trueCount;
            }
        }

        @Override
        void merge(ColumnStatisticsImpl other) {
            super.merge(other);
            BooleanStatisticsImpl bkt = (BooleanStatisticsImpl)other;
            this.trueCount += bkt.trueCount;
        }

        @Override
        OrcProto.ColumnStatistics.Builder serialize() {
            OrcProto.ColumnStatistics.Builder builder = super.serialize();
            OrcProto.BucketStatistics.Builder bucket = OrcProto.BucketStatistics.newBuilder();
            bucket.addCount(this.trueCount);
            builder.setBucketStatistics(bucket);
            return builder;
        }

        @Override
        public long getFalseCount() {
            return this.getNumberOfValues() - this.trueCount;
        }

        @Override
        public long getTrueCount() {
            return this.trueCount;
        }

        @Override
        public String toString() {
            return super.toString() + " true: " + this.trueCount;
        }
    }
}

