/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;

public class OrcUtils {
    private static final Log LOG = LogFactory.getLog(OrcUtils.class);

    public static boolean[] includeColumns(String selectedColumns, String allColumns, ObjectInspector inspector) {
        int numFlattenedCols = OrcUtils.getFlattenedColumnsCount(inspector);
        boolean[] results = new boolean[numFlattenedCols];
        if (selectedColumns != null && !selectedColumns.isEmpty()) {
            OrcUtils.includeColumnsImpl(results, selectedColumns, allColumns, inspector);
        }
        return results;
    }

    private static void includeColumnsImpl(boolean[] includeColumns, String selectedColumns, String allColumns, ObjectInspector inspector) {
        String[] selCols;
        Map<String, List<Integer>> columnSpanMap = OrcUtils.getColumnSpan(allColumns, inspector);
        LOG.info((Object)("columnSpanMap: " + columnSpanMap));
        for (String sc : selCols = selectedColumns.split(",")) {
            if (!columnSpanMap.containsKey(sc)) continue;
            List<Integer> colSpan = columnSpanMap.get(sc);
            int start = colSpan.get(0);
            int end = colSpan.get(1);
            for (int i = start; i <= end; ++i) {
                includeColumns[i] = true;
            }
        }
        LOG.info((Object)("includeColumns: " + Arrays.toString(includeColumns)));
    }

    private static Map<String, List<Integer>> getColumnSpan(String allColumns, ObjectInspector inspector) {
        HashMap<String, List<Integer>> columnSpanMap = new HashMap<String, List<Integer>>();
        if (allColumns != null) {
            String[] columns = allColumns.split(",");
            int startIdx = 0;
            int endIdx = 0;
            if (inspector instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)inspector;
                List fields = soi.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    StructField sf = (StructField)fields.get(i);
                    ObjectInspector sfOI = sf.getFieldObjectInspector();
                    String colName = columns[i];
                    startIdx = endIdx + 1;
                    switch (sfOI.getCategory()) {
                        case PRIMITIVE: {
                            ++endIdx;
                            break;
                        }
                        case STRUCT: {
                            ++endIdx;
                            StructObjectInspector structInsp = (StructObjectInspector)sfOI;
                            List structFields = structInsp.getAllStructFieldRefs();
                            for (int j = 0; j < structFields.size(); ++j) {
                                endIdx += OrcUtils.getFlattenedColumnsCount(((StructField)structFields.get(j)).getFieldObjectInspector());
                            }
                            break;
                        }
                        case MAP: {
                            ++endIdx;
                            MapObjectInspector mapInsp = (MapObjectInspector)sfOI;
                            endIdx += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapKeyObjectInspector());
                            endIdx += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapValueObjectInspector());
                            break;
                        }
                        case LIST: {
                            ++endIdx;
                            ListObjectInspector listInsp = (ListObjectInspector)sfOI;
                            endIdx += OrcUtils.getFlattenedColumnsCount(listInsp.getListElementObjectInspector());
                            break;
                        }
                        case UNION: {
                            ++endIdx;
                            UnionObjectInspector unionInsp = (UnionObjectInspector)sfOI;
                            List choices = unionInsp.getObjectInspectors();
                            for (int j = 0; j < choices.size(); ++j) {
                                endIdx += OrcUtils.getFlattenedColumnsCount((ObjectInspector)choices.get(j));
                            }
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Bad category: " + inspector.getCategory());
                        }
                    }
                    columnSpanMap.put(colName, Lists.newArrayList((Object[])new Integer[]{startIdx, endIdx}));
                }
            }
        }
        return columnSpanMap;
    }

    public static int getFlattenedColumnsCount(ObjectInspector inspector) {
        int numWriters = 0;
        switch (inspector.getCategory()) {
            case PRIMITIVE: {
                ++numWriters;
                break;
            }
            case STRUCT: {
                ++numWriters;
                StructObjectInspector structInsp = (StructObjectInspector)inspector;
                List fields = structInsp.getAllStructFieldRefs();
                for (int i = 0; i < fields.size(); ++i) {
                    numWriters += OrcUtils.getFlattenedColumnsCount(((StructField)fields.get(i)).getFieldObjectInspector());
                }
                break;
            }
            case MAP: {
                ++numWriters;
                MapObjectInspector mapInsp = (MapObjectInspector)inspector;
                numWriters += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapKeyObjectInspector());
                numWriters += OrcUtils.getFlattenedColumnsCount(mapInsp.getMapValueObjectInspector());
                break;
            }
            case LIST: {
                ++numWriters;
                ListObjectInspector listInsp = (ListObjectInspector)inspector;
                numWriters += OrcUtils.getFlattenedColumnsCount(listInsp.getListElementObjectInspector());
                break;
            }
            case UNION: {
                ++numWriters;
                UnionObjectInspector unionInsp = (UnionObjectInspector)inspector;
                List choices = unionInsp.getObjectInspectors();
                for (int i = 0; i < choices.size(); ++i) {
                    numWriters += OrcUtils.getFlattenedColumnsCount((ObjectInspector)choices.get(i));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad category: " + inspector.getCategory());
            }
        }
        return numWriters;
    }
}

