/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.ReflectionUtils;

public final class HiveUtils {
    public static final char QUOTE = '\"';
    public static final char COLON = ':';
    public static final String LBRACKET = "[";
    public static final String RBRACKET = "]";
    public static final String LBRACE = "{";
    public static final String RBRACE = "}";
    public static final String LINE_SEP = System.getProperty("line.separator");
    static final byte[] escapeEscapeBytes = "\\\\".getBytes();
    static final byte[] escapeUnescapeBytes = "\\".getBytes();
    static final byte[] newLineEscapeBytes = "\\n".getBytes();
    static final byte[] newLineUnescapeBytes = "\n".getBytes();
    static final byte[] carriageReturnEscapeBytes = "\\r".getBytes();
    static final byte[] carriageReturnUnescapeBytes = "\r".getBytes();
    static final byte[] tabEscapeBytes = "\\t".getBytes();
    static final byte[] tabUnescapeBytes = "\t".getBytes();
    static final byte[] ctrlABytes = "\u0001".getBytes();
    public static final Log LOG = LogFactory.getLog(HiveUtils.class);

    public static String escapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static Text escapeText(Text text) {
        int length = text.getLength();
        byte[] textBytes = text.getBytes();
        Text escape = new Text(text);
        escape.clear();
        for (int i = 0; i < length; ++i) {
            int len;
            int start;
            byte[] escaped;
            int c = text.charAt(i);
            switch (c) {
                case 92: {
                    escaped = escapeEscapeBytes;
                    start = 0;
                    len = escaped.length;
                    break;
                }
                case 10: {
                    escaped = newLineEscapeBytes;
                    start = 0;
                    len = escaped.length;
                    break;
                }
                case 13: {
                    escaped = carriageReturnEscapeBytes;
                    start = 0;
                    len = escaped.length;
                    break;
                }
                case 9: {
                    escaped = tabEscapeBytes;
                    start = 0;
                    len = escaped.length;
                    break;
                }
                case 1: {
                    escaped = tabUnescapeBytes;
                    start = 0;
                    len = escaped.length;
                    break;
                }
                default: {
                    escaped = textBytes;
                    start = i;
                    len = 1;
                }
            }
            escape.append(escaped, start, len);
        }
        return escape;
    }

    public static int unescapeText(Text text) {
        Text escape = new Text(text);
        text.clear();
        int length = escape.getLength();
        byte[] textBytes = escape.getBytes();
        boolean hadSlash = false;
        block7: for (int i = 0; i < length; ++i) {
            int c = escape.charAt(i);
            switch (c) {
                case 92: {
                    if (hadSlash) {
                        text.append(textBytes, i, 1);
                        hadSlash = false;
                        continue block7;
                    }
                    hadSlash = true;
                    continue block7;
                }
                case 110: {
                    if (hadSlash) {
                        byte[] newLine = newLineUnescapeBytes;
                        text.append(newLine, 0, newLine.length);
                    } else {
                        text.append(textBytes, i, 1);
                    }
                    hadSlash = false;
                    continue block7;
                }
                case 114: {
                    if (hadSlash) {
                        byte[] carriageReturn = carriageReturnUnescapeBytes;
                        text.append(carriageReturn, 0, carriageReturn.length);
                    } else {
                        text.append(textBytes, i, 1);
                    }
                    hadSlash = false;
                    continue block7;
                }
                case 116: {
                    if (hadSlash) {
                        byte[] tab = tabUnescapeBytes;
                        text.append(tab, 0, tab.length);
                    } else {
                        text.append(textBytes, i, 1);
                    }
                    hadSlash = false;
                    continue block7;
                }
                case 9: {
                    if (hadSlash) {
                        text.append(textBytes, i - 1, 1);
                        hadSlash = false;
                    }
                    byte[] ctrlA = ctrlABytes;
                    text.append(ctrlA, 0, ctrlA.length);
                    continue block7;
                }
                default: {
                    if (hadSlash) {
                        text.append(textBytes, i - 1, 1);
                        hadSlash = false;
                    }
                    text.append(textBytes, i, 1);
                }
            }
        }
        return text.getLength();
    }

    public static String lightEscapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block5;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block5;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block5;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String unparseIdentifier(String identifier) {
        return HiveUtils.unparseIdentifier(identifier, null);
    }

    public static String unparseIdentifier(String identifier, Configuration conf) {
        String qIdSupport;
        String string = qIdSupport = conf == null ? null : HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT);
        if (qIdSupport != null && !"none".equals(qIdSupport)) {
            identifier = identifier.replaceAll("`", "``");
        }
        return "`" + identifier + "`";
    }

    public static HiveStorageHandler getStorageHandler(Configuration conf, String className) throws HiveException {
        if (className == null) {
            return null;
        }
        try {
            Class<?> handlerClass = Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
            HiveStorageHandler storageHandler = (HiveStorageHandler)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return storageHandler;
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Error in loading storage handler." + e.getMessage(), e);
        }
    }

    private HiveUtils() {
    }

    public static HiveIndexHandler getIndexHandler(HiveConf conf, String indexHandlerClass) throws HiveException {
        if (indexHandlerClass == null) {
            return null;
        }
        try {
            Class<?> handlerClass = Class.forName(indexHandlerClass, true, Utilities.getSessionSpecifiedClassLoader());
            HiveIndexHandler indexHandler = (HiveIndexHandler)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return indexHandler;
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Error in loading index handler." + e.getMessage(), e);
        }
    }

    public static List<HiveMetastoreAuthorizationProvider> getMetaStoreAuthorizeProviderManagers(Configuration conf, HiveConf.ConfVars authorizationProviderConfKey, HiveAuthenticationProvider authenticator) throws HiveException {
        String clsStrs = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)authorizationProviderConfKey);
        if (clsStrs == null) {
            return null;
        }
        ArrayList<HiveMetastoreAuthorizationProvider> authProviders = new ArrayList<HiveMetastoreAuthorizationProvider>();
        for (String clsStr : clsStrs.trim().split(",")) {
            LOG.info((Object)("Adding metastore authorization provider: " + clsStr));
            authProviders.add((HiveMetastoreAuthorizationProvider)HiveUtils.getAuthorizeProviderManager(conf, clsStr, authenticator, false));
        }
        return authProviders;
    }

    public static HiveAuthorizationProvider getAuthorizeProviderManager(Configuration conf, String authzClassName, HiveAuthenticationProvider authenticator, boolean nullIfOtherClass) throws HiveException {
        HiveAuthorizationProvider ret = null;
        try {
            Class cls = null;
            if (authzClassName == null || authzClassName.trim().equals("")) {
                cls = DefaultHiveAuthorizationProvider.class;
            } else {
                Class<?> configClass = Class.forName(authzClassName, true, JavaUtils.getClassLoader());
                if (nullIfOtherClass && !HiveAuthorizationProvider.class.isAssignableFrom(configClass)) {
                    return null;
                }
                cls = configClass;
            }
            if (cls != null) {
                ret = (HiveAuthorizationProvider)ReflectionUtils.newInstance(cls, (Configuration)conf);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        ret.setAuthenticator(authenticator);
        return ret;
    }

    public static HiveAuthorizerFactory getAuthorizerFactory(Configuration conf, HiveConf.ConfVars authorizationProviderConfKey) throws HiveException {
        Class cls = conf.getClass(authorizationProviderConfKey.varname, SQLStdHiveAuthorizerFactory.class, HiveAuthorizerFactory.class);
        if (cls == null) {
            throw new HiveException("Configuration value " + authorizationProviderConfKey.varname + " is not set to valid HiveAuthorizerFactory subclass");
        }
        HiveAuthorizerFactory authFactory = (HiveAuthorizerFactory)ReflectionUtils.newInstance((Class)cls, (Configuration)conf);
        return authFactory;
    }

    public static HiveAuthenticationProvider getAuthenticator(Configuration conf, HiveConf.ConfVars authenticatorConfKey) throws HiveException {
        String clsStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)authenticatorConfKey);
        HiveAuthenticationProvider ret = null;
        try {
            Class cls = null;
            cls = clsStr == null || clsStr.trim().equals("") ? HadoopDefaultAuthenticator.class : Class.forName(clsStr, true, JavaUtils.getClassLoader());
            if (cls != null) {
                ret = (HiveAuthenticationProvider)ReflectionUtils.newInstance(cls, (Configuration)conf);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
        return ret;
    }

    public static String getUnparsedColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(HiveUtils.unparseIdentifier(fieldSchemas.get(i).getName()));
        }
        return sb.toString();
    }
}

