/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

class HadoopUriFinder {
    HadoopUriFinder() {
    }

    static String getJarVersion(File jarFile) throws IOException {
        try (JarFile openedJarFile = new JarFile(jarFile);){
            Manifest manifest = openedJarFile.getManifest();
            String string = manifest.getMainAttributes().getValue("Specification-Version");
            return string;
        }
    }

    static URI getFixedUri(URI fileUri) throws URISyntaxException, IOException {
        FileSystem fs = FileSystem.get((Configuration)new Configuration(true));
        return HadoopUriFinder.getFixedUri(fs, fileUri);
    }

    static URI getFixedUri(FileSystem fs, URI fileUri) throws URISyntaxException {
        if (fs.getUri().getScheme().equals(fileUri.getScheme()) && (fs.getUri().getHost().equals(fileUri.getHost()) || fileUri.getHost() == null) && (fs.getUri().getPort() == -1 || fileUri.getPort() == -1 || fs.getUri().getPort() == fileUri.getPort())) {
            return new URI(fs.getUri().getScheme(), fileUri.getUserInfo(), fs.getUri().getHost(), fs.getUri().getPort(), fileUri.getPath(), fileUri.getQuery(), fileUri.getFragment());
        }
        return fileUri;
    }
}

