/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.HadoopUriFinder;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;
import org.apache.oozie.action.hadoop.SparkMain;

class JarFilter {
    private String sparkVersion = "1.X.X";
    private String sparkYarnJar;
    private String applicationJar;
    private Collection<URI> listUris = null;

    JarFilter(Collection<URI> listUris, String jarPath) throws URISyntaxException, IOException {
        this.listUris = listUris;
        this.applicationJar = jarPath;
        Path p = new Path(jarPath);
        if (p.isAbsolute()) {
            this.applicationJar = HadoopUriFinder.getFixedUri(p.toUri()).toString();
        }
    }

    void filter() throws OozieActionConfiguratorException {
        Iterator<URI> iterator = this.listUris.iterator();
        File matchedFile = null;
        Path applJarPath = new Path(this.applicationJar);
        while (iterator.hasNext()) {
            URI uri = iterator.next();
            Path p = new Path(uri);
            if (SparkMain.SPARK_YARN_JAR_PATTERN.matcher(p.getName()).find()) {
                matchedFile = SparkMain.getMatchingFile(SparkMain.SPARK_YARN_JAR_PATTERN);
            } else if (SparkMain.SPARK_ASSEMBLY_JAR_PATTERN.matcher(p.getName()).find()) {
                matchedFile = SparkMain.getMatchingFile(SparkMain.SPARK_ASSEMBLY_JAR_PATTERN);
            }
            if (matchedFile != null) {
                this.sparkYarnJar = uri.toString();
                try {
                    this.sparkVersion = HadoopUriFinder.getJarVersion(matchedFile);
                    System.out.println("Spark Version " + this.sparkVersion);
                }
                catch (IOException io) {
                    System.out.println("Unable to open " + matchedFile.getPath() + ". Default Spark Version " + this.sparkVersion);
                }
                iterator.remove();
                matchedFile = null;
            }
            if (!this.isApplicationJar(p.getName(), uri, applJarPath)) continue;
            String fragment = uri.getFragment();
            this.applicationJar = fragment != null && fragment.length() > 0 ? fragment : uri.toString();
            iterator.remove();
        }
    }

    private boolean isApplicationJar(String fileName, URI fileUri, Path applJarPath) {
        return fileName.equals(this.applicationJar) || fileUri.toString().equals(this.applicationJar) || applJarPath.getName().equals(fileName) || this.applicationJar.equals(fileUri.getFragment());
    }

    String getApplicationJar() {
        return this.applicationJar;
    }

    String getSparkYarnJar() {
        return this.sparkYarnJar;
    }

    String getSparkVersion() {
        return this.sparkVersion;
    }
}

