/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.JarFilter;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;
import org.apache.oozie.action.hadoop.SparkMain;
import org.apache.oozie.action.hadoop.SparkOptionsSplitter;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Properties file should be specified by user")
class SparkArgsExtractor {
    private static final Pattern SPARK_DEFAULTS_FILE_PATTERN = Pattern.compile("spark-defaults.conf");
    private static final String FILES_OPTION = "--files";
    private static final String ARCHIVES_OPTION = "--archives";
    private static final String LOG4J_CONFIGURATION_JAVA_OPTION = "-Dlog4j.configuration=";
    private static final String SECURITY_TOKENS_HADOOPFS = "spark.yarn.security.tokens.hadoopfs.enabled";
    private static final String SECURITY_TOKENS_HIVE = "spark.yarn.security.tokens.hive.enabled";
    private static final String SECURITY_TOKENS_HBASE = "spark.yarn.security.tokens.hbase.enabled";
    private static final String SECURITY_CREDENTIALS_HADOOPFS = "spark.yarn.security.credentials.hadoopfs.enabled";
    private static final String SECURITY_CREDENTIALS_HIVE = "spark.yarn.security.credentials.hive.enabled";
    private static final String SECURITY_CREDENTIALS_HBASE = "spark.yarn.security.credentials.hbase.enabled";
    private static final String PWD = "$PWD" + File.separator + "*";
    private static final String MASTER_OPTION = "--master";
    private static final String MODE_OPTION = "--deploy-mode";
    private static final String JOB_NAME_OPTION = "--name";
    private static final String CLASS_NAME_OPTION = "--class";
    private static final String VERBOSE_OPTION = "--verbose";
    private static final String DRIVER_CLASSPATH_OPTION = "--driver-class-path";
    private static final String EXECUTOR_CLASSPATH = "spark.executor.extraClassPath=";
    private static final String DRIVER_CLASSPATH = "spark.driver.extraClassPath=";
    private static final String EXECUTOR_EXTRA_JAVA_OPTIONS = "spark.executor.extraJavaOptions=";
    private static final String DRIVER_EXTRA_JAVA_OPTIONS = "spark.driver.extraJavaOptions=";
    private static final Pattern SPARK_VERSION_1 = Pattern.compile("^1.*");
    private static final String SPARK_YARN_JAR = "spark.yarn.jar";
    private static final String SPARK_YARN_JARS = "spark.yarn.jars";
    private static final String OPT_SEPARATOR = "=";
    private static final String OPT_VALUE_SEPARATOR = ",";
    private static final String CONF_OPTION = "--conf";
    private static final String MASTER_OPTION_YARN_CLUSTER = "yarn-cluster";
    private static final String MASTER_OPTION_YARN_CLIENT = "yarn-client";
    private static final String MASTER_OPTION_YARN = "yarn";
    private static final String DEPLOY_MODE_CLUSTER = "cluster";
    private static final String DEPLOY_MODE_CLIENT = "client";
    private static final String SPARK_YARN_TAGS = "spark.yarn.tags";
    private static final String OPT_PROPERTIES_FILE = "--properties-file";
    public static final String SPARK_DEFAULTS_GENERATED_PROPERTIES = "spark-defaults-oozie-generated.properties";
    private boolean pySpark = false;
    private final Configuration actionConf;

    SparkArgsExtractor(Configuration actionConf) {
        this.actionConf = actionConf;
    }

    boolean isPySpark() {
        return this.pySpark;
    }

    List<String> extract(String[] mainArgs) throws OozieActionConfiguratorException, IOException, URISyntaxException {
        ArrayList<String> sparkArgs = new ArrayList<String>();
        sparkArgs.add(MASTER_OPTION);
        String master = this.actionConf.get("oozie.spark.master");
        sparkArgs.add(master);
        String sparkDeployMode = this.actionConf.get("oozie.spark.mode");
        if (sparkDeployMode != null) {
            sparkArgs.add(MODE_OPTION);
            sparkArgs.add(sparkDeployMode);
        }
        boolean yarnClusterMode = master.equals(MASTER_OPTION_YARN_CLUSTER) || master.equals(MASTER_OPTION_YARN) && sparkDeployMode != null && sparkDeployMode.equals(DEPLOY_MODE_CLUSTER);
        boolean yarnClientMode = master.equals(MASTER_OPTION_YARN_CLIENT) || master.equals(MASTER_OPTION_YARN) && sparkDeployMode != null && sparkDeployMode.equals(DEPLOY_MODE_CLIENT);
        sparkArgs.add(JOB_NAME_OPTION);
        sparkArgs.add(this.actionConf.get("oozie.spark.name"));
        String className = this.actionConf.get("oozie.spark.class");
        if (className != null) {
            sparkArgs.add(CLASS_NAME_OPTION);
            sparkArgs.add(className);
        }
        this.appendOoziePropertiesToSparkConf(sparkArgs);
        String jarPath = this.actionConf.get("oozie.spark.jar");
        if (jarPath != null && jarPath.endsWith(".py")) {
            this.pySpark = true;
        }
        boolean addedSecurityTokensHadoopFS = false;
        boolean addedSecurityTokensHive = false;
        boolean addedSecurityTokensHBase = false;
        boolean addedSecurityCredentialsHadoopFS = false;
        boolean addedSecurityCredentialsHive = false;
        boolean addedSecurityCredentialsHBase = false;
        boolean addedLog4jDriverSettings = false;
        boolean addedLog4jExecutorSettings = false;
        StringBuilder driverClassPath = new StringBuilder();
        StringBuilder executorClassPath = new StringBuilder();
        StringBuilder userFiles = new StringBuilder();
        StringBuilder userArchives = new StringBuilder();
        String sparkOpts = this.actionConf.get("oozie.spark.spark-opts");
        String propertiesFile = null;
        if (StringUtils.isNotEmpty((String)sparkOpts)) {
            List<String> sparkOptions = SparkOptionsSplitter.splitSparkOpts(sparkOpts);
            for (int i = 0; i < sparkOptions.size(); ++i) {
                String opt = sparkOptions.get(i);
                boolean addToSparkArgs = true;
                if (yarnClusterMode || yarnClientMode) {
                    if (opt.startsWith(EXECUTOR_CLASSPATH)) {
                        this.appendWithPathSeparator(opt.substring(EXECUTOR_CLASSPATH.length()), executorClassPath);
                        addToSparkArgs = false;
                    }
                    if (opt.startsWith(DRIVER_CLASSPATH)) {
                        this.appendWithPathSeparator(opt.substring(DRIVER_CLASSPATH.length()), driverClassPath);
                        addToSparkArgs = false;
                    }
                    if (opt.equals(DRIVER_CLASSPATH_OPTION)) {
                        this.appendWithPathSeparator(sparkOptions.get(i + 1), driverClassPath);
                        ++i;
                        addToSparkArgs = false;
                    }
                }
                if (opt.startsWith(SECURITY_TOKENS_HADOOPFS)) {
                    addedSecurityTokensHadoopFS = true;
                }
                if (opt.startsWith(SECURITY_TOKENS_HIVE)) {
                    addedSecurityTokensHive = true;
                }
                if (opt.startsWith(SECURITY_TOKENS_HBASE)) {
                    addedSecurityTokensHBase = true;
                }
                if (opt.startsWith(SECURITY_CREDENTIALS_HADOOPFS)) {
                    addedSecurityCredentialsHadoopFS = true;
                }
                if (opt.startsWith(SECURITY_CREDENTIALS_HIVE)) {
                    addedSecurityCredentialsHive = true;
                }
                if (opt.startsWith(SECURITY_CREDENTIALS_HBASE)) {
                    addedSecurityCredentialsHBase = true;
                }
                if (opt.startsWith(OPT_PROPERTIES_FILE)) {
                    propertiesFile = sparkOptions.get(++i);
                    addToSparkArgs = false;
                }
                if (opt.startsWith(EXECUTOR_EXTRA_JAVA_OPTIONS) || opt.startsWith(DRIVER_EXTRA_JAVA_OPTIONS)) {
                    if (!opt.contains(LOG4J_CONFIGURATION_JAVA_OPTION)) {
                        opt = opt + " -Dlog4j.configuration=spark-log4j.properties";
                    } else {
                        System.out.println("Warning: Spark Log4J settings are overwritten. Child job IDs may not be available");
                    }
                    if (opt.startsWith(EXECUTOR_EXTRA_JAVA_OPTIONS)) {
                        addedLog4jExecutorSettings = true;
                    } else {
                        addedLog4jDriverSettings = true;
                    }
                }
                if (opt.startsWith(FILES_OPTION)) {
                    String userFile;
                    if (opt.contains(OPT_SEPARATOR)) {
                        userFile = opt.substring(opt.indexOf(OPT_SEPARATOR) + OPT_SEPARATOR.length());
                    } else {
                        userFile = sparkOptions.get(i + 1);
                        ++i;
                    }
                    if (userFiles.length() > 0) {
                        userFiles.append(OPT_VALUE_SEPARATOR);
                    }
                    userFiles.append(userFile);
                    addToSparkArgs = false;
                }
                if (opt.startsWith(ARCHIVES_OPTION)) {
                    String userArchive;
                    if (opt.contains(OPT_SEPARATOR)) {
                        userArchive = opt.substring(opt.indexOf(OPT_SEPARATOR) + OPT_SEPARATOR.length());
                    } else {
                        userArchive = sparkOptions.get(i + 1);
                        ++i;
                    }
                    if (userArchives.length() > 0) {
                        userArchives.append(OPT_VALUE_SEPARATOR);
                    }
                    userArchives.append(userArchive);
                    addToSparkArgs = false;
                }
                if (addToSparkArgs) {
                    sparkArgs.add(opt);
                    continue;
                }
                if (!((String)sparkArgs.get(sparkArgs.size() - 1)).equals(CONF_OPTION)) continue;
                sparkArgs.remove(sparkArgs.size() - 1);
            }
        }
        if (yarnClusterMode || yarnClientMode) {
            this.appendWithPathSeparator(PWD, executorClassPath);
            this.appendWithPathSeparator(PWD, driverClassPath);
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add(EXECUTOR_CLASSPATH + executorClassPath.toString());
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add(DRIVER_CLASSPATH + driverClassPath.toString());
        }
        if (this.actionConf.get("mapreduce.job.tags") != null) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.tags=" + this.actionConf.get("mapreduce.job.tags"));
        }
        if (!addedSecurityTokensHadoopFS) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.security.tokens.hadoopfs.enabled=" + Boolean.toString(false));
        }
        if (!addedSecurityTokensHive) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.security.tokens.hive.enabled=" + Boolean.toString(false));
        }
        if (!addedSecurityTokensHBase) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.security.tokens.hbase.enabled=" + Boolean.toString(false));
        }
        if (!addedSecurityCredentialsHadoopFS) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.security.credentials.hadoopfs.enabled=" + Boolean.toString(false));
        }
        if (!addedSecurityCredentialsHive) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.security.credentials.hive.enabled=" + Boolean.toString(false));
        }
        if (!addedSecurityCredentialsHBase) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.security.credentials.hbase.enabled=" + Boolean.toString(false));
        }
        if (!addedLog4jExecutorSettings) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.executor.extraJavaOptions=-Dlog4j.configuration=spark-log4j.properties");
        }
        if (!addedLog4jDriverSettings) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.driver.extraJavaOptions=-Dlog4j.configuration=spark-log4j.properties");
        }
        this.mergeAndAddPropertiesFile(sparkArgs, propertiesFile);
        if (yarnClusterMode || yarnClientMode) {
            Map<String, URI> fixedFileUrisMap = SparkMain.fixFsDefaultUrisAndFilterDuplicates(DistributedCache.getCacheFiles((Configuration)this.actionConf));
            fixedFileUrisMap.put("spark-log4j.properties", new Path("spark-log4j.properties").toUri());
            fixedFileUrisMap.put("hive-site.xml", new Path("hive-site.xml").toUri());
            this.addUserDefined(userFiles.toString(), fixedFileUrisMap);
            Collection<URI> fixedFileUris = fixedFileUrisMap.values();
            JarFilter jarFilter = new JarFilter(fixedFileUris, jarPath);
            jarFilter.filter();
            jarPath = jarFilter.getApplicationJar();
            String cachedFiles = StringUtils.join(fixedFileUris, (String)OPT_VALUE_SEPARATOR);
            if (cachedFiles != null && !cachedFiles.isEmpty()) {
                sparkArgs.add(FILES_OPTION);
                sparkArgs.add(cachedFiles);
            }
            Map<String, URI> fixedArchiveUrisMap = SparkMain.fixFsDefaultUrisAndFilterDuplicates(DistributedCache.getCacheArchives((Configuration)this.actionConf));
            this.addUserDefined(userArchives.toString(), fixedArchiveUrisMap);
            String cachedArchives = StringUtils.join(fixedArchiveUrisMap.values(), (String)OPT_VALUE_SEPARATOR);
            if (cachedArchives != null && !cachedArchives.isEmpty()) {
                sparkArgs.add(ARCHIVES_OPTION);
                sparkArgs.add(cachedArchives);
            }
            this.setSparkYarnJarsConf(sparkArgs, jarFilter.getSparkYarnJar(), jarFilter.getSparkVersion());
        }
        if (!sparkArgs.contains(VERBOSE_OPTION)) {
            sparkArgs.add(VERBOSE_OPTION);
        }
        sparkArgs.add(jarPath);
        sparkArgs.addAll(Arrays.asList(mainArgs));
        return sparkArgs;
    }

    private void mergeAndAddPropertiesFile(List<String> sparkArgs, String userDefinedPropertiesFile) throws IOException {
        Properties properties = new Properties();
        this.loadServerDefaultProperties(properties);
        this.loadLocalizedDefaultPropertiesFile(properties);
        this.loadUserDefinedPropertiesFile(userDefinedPropertiesFile, properties);
        boolean persisted = this.persistMergedProperties(properties);
        if (persisted) {
            sparkArgs.add(OPT_PROPERTIES_FILE);
            sparkArgs.add(SPARK_DEFAULTS_GENERATED_PROPERTIES);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean persistMergedProperties(Properties properties) throws IOException {
        if (properties.isEmpty()) return false;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(SPARK_DEFAULTS_GENERATED_PROPERTIES)), StandardCharsets.UTF_8.name());){
            properties.store(writer, "Properties file generated by Oozie");
            System.out.println(String.format("Persisted merged Spark configs in file %s. Merged properties are: %s", SPARK_DEFAULTS_GENERATED_PROPERTIES, Arrays.toString(properties.stringPropertyNames().toArray())));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.err.println(String.format("Could not persist derived Spark config file. Reason: %s", e.getMessage()));
            throw e;
        }
    }

    private void loadUserDefinedPropertiesFile(String userDefinedPropertiesFile, Properties properties) {
        if (userDefinedPropertiesFile != null) {
            System.out.println(String.format("Reading Spark config from %s %s...", OPT_PROPERTIES_FILE, userDefinedPropertiesFile));
            this.loadProperties(new File(userDefinedPropertiesFile), properties);
        }
    }

    private void loadLocalizedDefaultPropertiesFile(Properties properties) {
        File localizedDefaultConfFile = SparkMain.getMatchingFile(SPARK_DEFAULTS_FILE_PATTERN);
        if (localizedDefaultConfFile != null) {
            System.out.println(String.format("Reading Spark config from file %s...", localizedDefaultConfFile.getName()));
            this.loadProperties(localizedDefaultConfFile, properties);
        }
    }

    private void loadServerDefaultProperties(Properties properties) {
        String sparkDefaultsFromServer = this.actionConf.get("oozie.spark.spark-default-opts", "");
        if (!sparkDefaultsFromServer.isEmpty()) {
            System.out.println("Reading Spark config propagated from Oozie server...");
            try (StringReader reader = new StringReader(sparkDefaultsFromServer);){
                properties.load(reader);
            }
            catch (IOException e) {
                System.err.println(String.format("Could not read propagated Spark config! Reason: %s", e.getMessage()));
            }
        }
    }

    private void loadProperties(File file, Properties target) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8.name());){
            Properties properties = new Properties();
            properties.load(reader);
            for (String key : properties.stringPropertyNames()) {
                Object prevProperty = target.setProperty(key, properties.getProperty(key));
                if (prevProperty == null) continue;
                System.out.println(String.format("Value of %s was overwritten from %s", key, file.getName()));
            }
        }
        catch (IOException e) {
            System.err.println(String.format("Could not read Spark configs from file %s. Reason: %s", file.getName(), e.getMessage()));
        }
    }

    private void appendWithPathSeparator(String what, StringBuilder to) {
        if (to.length() > 0) {
            to.append(File.pathSeparator);
        }
        to.append(what);
    }

    private void addUserDefined(String userList, Map<String, URI> urisMap) {
        if (userList != null) {
            for (String file : userList.split(OPT_VALUE_SEPARATOR)) {
                if (Strings.isNullOrEmpty((String)file)) continue;
                Path p = new Path(file);
                urisMap.put(p.getName(), p.toUri());
            }
        }
    }

    @VisibleForTesting
    void appendOoziePropertiesToSparkConf(List<String> sparkArgs) {
        for (Map.Entry oozieConfig : this.actionConf.getValByRegex("^oozie\\.(?!launcher|spark).+").entrySet()) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add(String.format("spark.%s=%s", oozieConfig.getKey(), oozieConfig.getValue()));
        }
    }

    private void setSparkYarnJarsConf(List<String> sparkArgs, String sparkYarnJar, String sparkVersion) {
        if (SPARK_VERSION_1.matcher(sparkVersion).find()) {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.jar=" + sparkYarnJar);
        } else {
            sparkArgs.add(CONF_OPTION);
            sparkArgs.add("spark.yarn.jars=" + sparkYarnJar);
        }
    }
}

