/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.PropertyConfigurator;
import org.apache.oozie.action.hadoop.HadoopUriFinder;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.OozieActionConfiguratorException;
import org.apache.oozie.action.hadoop.PasswordMasker;
import org.apache.oozie.action.hadoop.SparkArgsExtractor;
import org.apache.spark.deploy.SparkSubmit;

public class SparkMain
extends LauncherMain {
    @VisibleForTesting
    static final Pattern[] SPARK_JOB_IDS_PATTERNS = new Pattern[]{Pattern.compile("Submitted application (application[0-9_]*)")};
    @VisibleForTesting
    static final Pattern SPARK_ASSEMBLY_JAR_PATTERN = Pattern.compile("^spark-assembly((?:(-|_|(\\d+\\.))\\d+(?:\\.\\d+)*))*\\.jar$");
    @VisibleForTesting
    static final Pattern SPARK_YARN_JAR_PATTERN = Pattern.compile("^spark-yarn((?:(-|_|(\\d+\\.))\\d+(?:\\.\\d+)*))*\\.jar$");
    static final String HIVE_SITE_CONF = "hive-site.xml";
    static final String SPARK_LOG4J_PROPS = "spark-log4j.properties";
    private static final String CONF_OOZIE_SPARK_SETUP_HADOOP_CONF_DIR = "oozie.action.spark.setup.hadoop.conf.dir";
    private static final Pattern[] PYSPARK_DEP_FILE_PATTERN = new Pattern[]{Pattern.compile("py4\\S*src.zip"), Pattern.compile("pyspark.zip")};

    public static void main(String[] args) throws Exception {
        SparkMain.run(SparkMain.class, (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) throws Exception {
        Configuration actionConf = SparkMain.loadActionConf();
        this.prepareHadoopConfig(actionConf);
        SparkMain.setYarnTag((Configuration)actionConf);
        LauncherMain.killChildYarnJobs((Configuration)actionConf);
        String logFile = this.setUpSparkLog4J(actionConf);
        this.setHiveSite(actionConf);
        SparkArgsExtractor sparkArgsExtractor = new SparkArgsExtractor(actionConf);
        List<String> sparkArgs = sparkArgsExtractor.extract(args);
        if (sparkArgsExtractor.isPySpark()) {
            this.createPySparkLibFolder();
        }
        System.out.println("Spark Action Main class        : " + SparkSubmit.class.getName());
        System.out.println();
        System.out.println("Oozie Spark action configuration");
        System.out.println("=================================================================");
        System.out.println();
        PasswordMasker passwordMasker = new PasswordMasker();
        for (String arg : sparkArgs) {
            System.out.println("                    " + passwordMasker.maskPasswordsIfNecessary(arg));
        }
        System.out.println();
        try {
            this.runSpark(sparkArgs.toArray(new String[sparkArgs.size()]));
        }
        finally {
            System.out.println("\n<<< Invocation of Spark command completed <<<\n");
            SparkMain.writeExternalChildIDs((String)logFile, (Pattern[])SPARK_JOB_IDS_PATTERNS, (String)"Spark");
        }
    }

    private void prepareHadoopConfig(Configuration actionConf) throws IOException {
        String actionXml;
        if (actionConf.getBoolean(CONF_OOZIE_SPARK_SETUP_HADOOP_CONF_DIR, false) && (actionXml = System.getProperty("oozie.action.conf.xml")) != null) {
            File currentDir = new File(actionXml).getParentFile();
            this.writeHadoopConfig(actionXml, currentDir);
        }
    }

    private void createPySparkLibFolder() throws OozieActionConfiguratorException, IOException {
        File pythonLibDir = new File("python/lib");
        if (!pythonLibDir.exists()) {
            pythonLibDir.mkdirs();
            System.out.println("PySpark lib folder " + pythonLibDir.getAbsolutePath() + " folder created.");
        }
        for (Pattern fileNamePattern : PYSPARK_DEP_FILE_PATTERN) {
            File file = this.getMatchingPyFile(fileNamePattern);
            File destination = new File(pythonLibDir, file.getName());
            FileUtils.copyFile((File)file, (File)destination);
            System.out.println("Copied " + file + " to " + destination.getAbsolutePath());
        }
    }

    private File getMatchingPyFile(Pattern fileNamePattern) throws OozieActionConfiguratorException {
        File f = SparkMain.getMatchingFile(fileNamePattern);
        if (f != null) {
            return f;
        }
        throw new OozieActionConfiguratorException("Missing py4j and/or pyspark zip files. Please add them to the lib folder or to the Spark sharelib.");
    }

    static File getMatchingFile(Pattern fileNamePattern) {
        File localDir = new File(".");
        String[] localFileNames = localDir.list();
        if (localFileNames == null) {
            return null;
        }
        for (String fileName : localFileNames) {
            if (!fileNamePattern.matcher(fileName).find()) continue;
            return new File(fileName);
        }
        return null;
    }

    private void runSpark(String[] args) throws Exception {
        System.out.println("=================================================================");
        System.out.println();
        System.out.println(">>> Invoking Spark class now >>>");
        System.out.println();
        System.out.flush();
        SparkSubmit.main((String[])args);
    }

    private String setUpSparkLog4J(Configuration actionConf) throws IOException {
        String hadoopJobId = System.getProperty("oozie.launcher.job.id");
        if (hadoopJobId == null) {
            throw new RuntimeException("Launcher Hadoop Job ID system,property not set");
        }
        String logFile = new File("spark-oozie-" + hadoopJobId + ".log").getAbsolutePath();
        String logLevel = actionConf.get("oozie.spark.log.level", "INFO");
        String rootLogLevel = actionConf.get("oozie.action.rootlogger.log.level", "INFO");
        this.log4jProperties.setProperty("log4j.rootLogger", rootLogLevel + ", A");
        this.log4jProperties.setProperty("log4j.logger.org.apache.spark", logLevel + ", A, jobid");
        this.log4jProperties.setProperty("log4j.additivity.org.apache.spark", "false");
        this.log4jProperties.setProperty("log4j.appender.A", "org.apache.log4j.ConsoleAppender");
        this.log4jProperties.setProperty("log4j.appender.A.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.A.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.appender.jobid", "org.apache.log4j.FileAppender");
        this.log4jProperties.setProperty("log4j.appender.jobid.file", logFile);
        this.log4jProperties.setProperty("log4j.appender.jobid.layout", "org.apache.log4j.PatternLayout");
        this.log4jProperties.setProperty("log4j.appender.jobid.layout.ConversionPattern", "%d [%t] %-5p %c %x - %m%n");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.mapred", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.mapreduce.Job", "INFO, jobid");
        this.log4jProperties.setProperty("log4j.logger.org.apache.hadoop.yarn.client.api.impl.YarnClientImpl", "INFO, jobid");
        String localProps = new File(SPARK_LOG4J_PROPS).getAbsolutePath();
        SparkMain.createFileWithContentIfNotExists((String)localProps, (Properties)this.log4jProperties);
        PropertyConfigurator.configure((String)SPARK_LOG4J_PROPS);
        return logFile;
    }

    static Map<String, URI> fixFsDefaultUrisAndFilterDuplicates(URI[] files) throws IOException, URISyntaxException {
        LinkedHashMap<String, URI> map = new LinkedHashMap<String, URI>();
        if (files == null) {
            return map;
        }
        FileSystem fs = FileSystem.get((Configuration)new Configuration(true));
        for (int i = 0; i < files.length; ++i) {
            URI fileUri = files[i];
            Path p = new Path(fileUri);
            map.put(p.getName(), HadoopUriFinder.getFixedUri(fs, fileUri));
        }
        return map;
    }

    private void setHiveSite(Configuration hiveConf) throws IOException {
        hiveConf.set("datanucleus.plugin.pluginRegistryBundleCheck", "LOG");
        hiveConf.unset("hive.querylog.location");
        hiveConf.unset("hive.exec.local.scratchdir");
        SparkMain.createFileWithContentIfNotExists((String)HIVE_SITE_CONF, (Configuration)hiveConf);
    }
}

