/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

class SparkOptionsSplitter {
    private static final Pattern OPTION_KEY_PREFIX = Pattern.compile("\\s*--[a-zA-Z0-9.]+[\\-a-zA-Z0-9.]*[=]?");
    private static final String VALUE_HAS_QUOTES_AT_ENDS_REGEX = "[a-zA-Z0-9.]+=\".+\"";
    private static final String VALUE_HAS_QUOTES_IN_BETWEEN_REGEX = "[a-zA-Z0-9.]+=.*(\\w\\s+\"\\w+[\\s+\\w]*\"|\"\\w+[\\s+\\w]*\"\\s+\\w)+.*";

    SparkOptionsSplitter() {
    }

    static List<String> splitSparkOpts(String sparkOpts) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = OPTION_KEY_PREFIX.matcher(sparkOpts);
        int start = 0;
        while (matcher.find()) {
            String sparkOpt;
            String maybeQuotedValue;
            int end = matcher.start();
            if (start > 0 && StringUtils.isNotEmpty((String)(maybeQuotedValue = sparkOpts.substring(start, end).trim()))) {
                result.add(SparkOptionsSplitter.unquoteEntirelyQuotedValue(maybeQuotedValue));
            }
            if ((sparkOpt = SparkOptionsSplitter.matchSparkOpt(sparkOpts, matcher)).endsWith("=")) {
                sparkOpt = sparkOpt.replaceAll("=", "");
            }
            result.add(sparkOpt);
            start = matcher.end();
        }
        String maybeEntirelyQuotedValue = sparkOpts.substring(start).trim();
        if (StringUtils.isNotEmpty((String)maybeEntirelyQuotedValue)) {
            result.add(SparkOptionsSplitter.unquoteEntirelyQuotedValue(maybeEntirelyQuotedValue));
        }
        return result;
    }

    private static String matchSparkOpt(String sparkOpts, Matcher matcher) {
        return sparkOpts.substring(matcher.start(), matcher.end()).trim();
    }

    private static String unquoteEntirelyQuotedValue(String maybeEntirelyQuotedValue) {
        boolean isEntirelyQuoted;
        boolean hasQuotesAtEnds = maybeEntirelyQuotedValue.matches(VALUE_HAS_QUOTES_AT_ENDS_REGEX);
        boolean hasQuotesInBetween = maybeEntirelyQuotedValue.matches(VALUE_HAS_QUOTES_IN_BETWEEN_REGEX);
        boolean bl = isEntirelyQuoted = hasQuotesAtEnds && !hasQuotesInBetween;
        if (isEntirelyQuoted) {
            return maybeEntirelyQuotedValue.replaceAll("\"", "");
        }
        return maybeEntirelyQuotedValue;
    }
}

