/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.OozieClientOperationHandler;
import org.apache.oozie.client.BulkResponse;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.JMSConnectionInfo;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONObject;

abstract class BaseLocalOozieClient
extends OozieClient {
    private final BaseEngine engine;

    BaseLocalOozieClient(BaseEngine engine) {
        Preconditions.checkNotNull((Object)engine);
        this.engine = engine;
    }

    public String getOozieUrl() {
        return "localoozie";
    }

    public String getProtocolUrl() throws OozieClientException {
        return "localoozie";
    }

    public synchronized void validateWSVersion() throws OozieClientException {
    }

    public Properties createConfiguration() {
        Properties conf = new Properties();
        if (this.engine != null) {
            conf.setProperty("user.name", this.engine.getUser());
        }
        conf.setProperty("group.name", "users");
        return conf;
    }

    public void setHeader(String name, String value) {
    }

    public String getHeader(String name) {
        return "";
    }

    public void removeHeader(String name) {
    }

    public Iterator<String> getHeaderNames() {
        return Collections.emptySet().iterator();
    }

    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    public String submit(final Properties conf) throws OozieClientException {
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<String>(){

            @Override
            public String callOrThrow() throws BaseEngineException {
                return BaseLocalOozieClient.this.engine.submitJob(new XConfiguration(conf), false);
            }
        });
    }

    public void start(final String jobId) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.start(jobId);
                return null;
            }
        });
    }

    public String run(final Properties conf) throws OozieClientException {
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<String>(){

            @Override
            public String callOrThrow() throws BaseEngineException {
                return BaseLocalOozieClient.this.engine.submitJob(new XConfiguration(conf), true);
            }
        });
    }

    public void reRun(final String jobId, final Properties conf) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.reRun(jobId, new XConfiguration(conf));
                return null;
            }
        });
    }

    public void suspend(final String jobId) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.suspend(jobId);
                return null;
            }
        });
    }

    public void resume(final String jobId) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.resume(jobId);
                return null;
            }
        });
    }

    public void kill(final String jobId) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.kill(jobId);
                return null;
            }
        });
    }

    public String dryrun(final Properties conf) throws OozieClientException {
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<String>(){

            @Override
            public String callOrThrow() throws BaseEngineException {
                return BaseLocalOozieClient.this.engine.dryRunSubmit(new XConfiguration(conf));
            }
        });
    }

    public String getStatus(final String jobId) throws OozieClientException {
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<String>(){

            @Override
            public String callOrThrow() throws BaseEngineException {
                return BaseLocalOozieClient.this.engine.getJobStatus(jobId);
            }
        });
    }

    public String getJobDefinition(final String jobId) throws OozieClientException {
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<String>(){

            @Override
            public String callOrThrow() throws BaseEngineException {
                return BaseLocalOozieClient.this.engine.getDefinition(jobId);
            }
        });
    }

    public String getJobId(final String externalId) throws OozieClientException {
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<String>(){

            @Override
            public String callOrThrow() throws BaseEngineException {
                return BaseLocalOozieClient.this.engine.getJobIdForExternalId(externalId);
            }
        });
    }

    public void slaEnableAlert(final String bundleId, final String actions, final String dates, final String coords) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.enableSLAAlert(bundleId, actions, dates, coords);
                return null;
            }
        });
    }

    public void slaEnableAlert(String jobIds, String actions, String dates) throws OozieClientException {
        this.slaEnableAlert(jobIds, actions, dates, null);
    }

    public void slaDisableAlert(final String bundleId, final String actions, final String dates, final String coords) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.disableSLAAlert(bundleId, actions, dates, coords);
                return null;
            }
        });
    }

    public void slaDisableAlert(String jobIds, String actions, String dates) throws OozieClientException {
        this.slaDisableAlert(jobIds, actions, dates, null);
    }

    public void slaChange(final String bundleId, final String actions, final String dates, final String coords, final String newSlaParams) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.changeSLA(bundleId, actions, dates, coords, newSlaParams);
                return null;
            }
        });
    }

    public void slaChange(String jobIds, String actions, String dates, String newSlaParams) throws OozieClientException {
        this.slaChange(jobIds, actions, dates, null, newSlaParams);
    }

    public void slaChange(String bundleId, String actions, String dates, String coords, Map<String, String> newSlaParams) throws OozieClientException {
        this.slaChange(bundleId, actions, dates, coords, this.mapToString(newSlaParams));
    }

    public void change(final String jobId, final String changeValue) throws OozieClientException {
        BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<Void>(){

            @Override
            public Void callOrThrow() throws BaseEngineException {
                BaseLocalOozieClient.this.engine.change(jobId, changeValue);
                return null;
            }
        });
    }

    public JSONObject bulkModifyJobs(String actionType, String filter, String jobType, int start, int len) throws OozieClientException {
        JSONObject jsonObject;
        switch (actionType) {
            case "kill": {
                jsonObject = this.killJobs(filter, jobType, start, len);
                break;
            }
            case "suspend": {
                jsonObject = this.suspendJobs(filter, jobType, start, len);
                break;
            }
            case "resume": {
                jsonObject = this.resumeJobs(filter, jobType, start, len);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid actionType passed. actionType: " + actionType);
            }
        }
        return jsonObject;
    }

    public JSONObject killJobs(String filter, final String jobType, int start, int len) throws OozieClientException {
        OozieClientOperationHandler handler = new OozieClientOperationHandler(this.engine);
        final OozieClientOperationHandler.OozieOperationJob operation = handler.getOperationHandler("kill", filter, start, len);
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<JSONObject>(){

            @Override
            public JSONObject callOrThrow() throws BaseEngineException {
                return new OozieClientOperationHandler.OozieJobOperationCaller().call(jobType, operation);
            }
        });
    }

    public JSONObject suspendJobs(String filter, final String jobType, int start, int len) throws OozieClientException {
        OozieClientOperationHandler handler = new OozieClientOperationHandler(this.engine);
        final OozieClientOperationHandler.OozieOperationJob operation = handler.getOperationHandler("suspend", filter, start, len);
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<JSONObject>(){

            @Override
            public JSONObject callOrThrow() throws BaseEngineException {
                return new OozieClientOperationHandler.OozieJobOperationCaller().call(jobType, operation);
            }
        });
    }

    public JSONObject resumeJobs(String filter, final String jobType, int start, int len) throws OozieClientException {
        OozieClientOperationHandler handler = new OozieClientOperationHandler(this.engine);
        final OozieClientOperationHandler.OozieOperationJob operation = handler.getOperationHandler("resume", filter, start, len);
        return BaseEngine.callOrRethrow(new BaseEngine.BaseEngineCallable<JSONObject>(){

            @Override
            public JSONObject callOrThrow() throws BaseEngineException {
                return new OozieClientOperationHandler.OozieJobOperationCaller().call(jobType, operation);
            }
        });
    }

    public WorkflowJob getJobInfo(String jobId) throws OozieClientException {
        return (WorkflowJob)BaseEngine.throwNoOp();
    }

    public WorkflowJob getJobInfo(String jobId, int start, int len) throws OozieClientException {
        return (WorkflowJob)BaseEngine.throwNoOp();
    }

    public List<WorkflowJob> getJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public List<WorkflowJob> getJobsInfo(String filter) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public List<CoordinatorAction> kill(String jobId, String rangeType, String scope) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public List<BulkResponse> getBulkInfo(String filter, int start, int len) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public String updateCoord(String jobId, Properties conf, String dryrun, String showDiff) throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public String updateCoord(String jobId, String dryrun, String showDiff) throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public WorkflowAction getWorkflowActionInfo(String actionId) throws OozieClientException {
        return (WorkflowAction)BaseEngine.throwNoOp();
    }

    public BundleJob getBundleJobInfo(String jobId) throws OozieClientException {
        return (BundleJob)BaseEngine.throwNoOp();
    }

    public CoordinatorJob getCoordJobInfo(String jobId) throws OozieClientException {
        return (CoordinatorJob)BaseEngine.throwNoOp();
    }

    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len) throws OozieClientException {
        return (CoordinatorJob)BaseEngine.throwNoOp();
    }

    public CoordinatorJob getCoordJobInfo(String jobId, String filter, int start, int len, String order) throws OozieClientException {
        return (CoordinatorJob)BaseEngine.throwNoOp();
    }

    public List<WorkflowJob> getWfsForCoordAction(String coordActionId) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public CoordinatorAction getCoordActionInfo(String actionId) throws OozieClientException {
        return (CoordinatorAction)BaseEngine.throwNoOp();
    }

    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public List<CoordinatorAction> reRunCoord(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup, boolean failed, Properties props) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public Void reRunBundle(String jobId, String coordScope, String dateScope, boolean refresh, boolean noCleanup) throws OozieClientException {
        return (Void)BaseEngine.throwNoOp();
    }

    public List<CoordinatorJob> getCoordJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public List<BundleJob> getBundleJobsInfo(String filter, int start, int len) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    protected HttpURLConnection createRetryableConnection(URL url, String method) throws IOException {
        try {
            return (HttpURLConnection)BaseEngine.throwNoOp();
        }
        catch (OozieClientException e) {
            throw new IOException(e);
        }
    }

    protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
        return (HttpURLConnection)BaseEngine.throwNoOp();
    }

    public List<CoordinatorAction> ignore(String jobId, String scope) throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public JMSConnectionInfo getJMSConnectionInfo() throws OozieClientException {
        return (JMSConnectionInfo)BaseEngine.throwNoOp();
    }

    public String getJobLog(String jobId) throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public void getJobAuditLog(String jobId, PrintStream ps) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public void getJobLog(String jobId, String logRetrievalType, String logRetrievalScope, String logFilter, PrintStream ps) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public void getJobErrorLog(String jobId, PrintStream ps) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public void getJobLog(String jobId, String logRetrievalType, String logRetrievalScope, PrintStream ps) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public String getJMSTopicName(String jobId) throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public void getSlaInfo(int start, int len, String filter) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public void setSystemMode(OozieClient.SYSTEM_MODE status) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public OozieClient.SYSTEM_MODE getSystemMode() throws OozieClientException {
        return (OozieClient.SYSTEM_MODE)BaseEngine.throwNoOp();
    }

    public String updateShareLib() throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public String listShareLib(String sharelibKey) throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public String getServerBuildVersion() throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public String getClientBuildVersion() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    public String validateXML(String file) throws OozieClientException {
        return (String)BaseEngine.throwNoOp();
    }

    public void pollJob(String id, int timeout, int interval, boolean verbose) throws OozieClientException {
        BaseEngine.throwNoOp();
    }

    public List<String> getQueueDump() throws OozieClientException {
        return (List)BaseEngine.throwNoOp();
    }

    public Map<String, String> getAvailableOozieServers() throws OozieClientException {
        return (Map)BaseEngine.throwNoOp();
    }

    public Map<String, String> getServerConfiguration() throws OozieClientException {
        return (Map)BaseEngine.throwNoOp();
    }

    public Map<String, String> getJavaSystemProperties() throws OozieClientException {
        return (Map)BaseEngine.throwNoOp();
    }

    public Map<String, String> getOSEnv() throws OozieClientException {
        return (Map)BaseEngine.throwNoOp();
    }

    public OozieClient.Metrics getMetrics() throws OozieClientException {
        return (OozieClient.Metrics)BaseEngine.throwNoOp();
    }

    public OozieClient.Instrumentation getInstrumentation() throws OozieClientException {
        return (OozieClient.Instrumentation)BaseEngine.throwNoOp();
    }
}

