/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.wf.BulkWorkflowXCommand;
import org.apache.oozie.command.wf.CompletedActionXCommand;
import org.apache.oozie.command.wf.DefinitionXCommand;
import org.apache.oozie.command.wf.ExternalIdXCommand;
import org.apache.oozie.command.wf.JobXCommand;
import org.apache.oozie.command.wf.JobsXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.ReRunXCommand;
import org.apache.oozie.command.wf.ResumeXCommand;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitHiveXCommand;
import org.apache.oozie.command.wf.SubmitHttpXCommand;
import org.apache.oozie.command.wf.SubmitMRXCommand;
import org.apache.oozie.command.wf.SubmitPigXCommand;
import org.apache.oozie.command.wf.SubmitSqoopXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.command.wf.WorkflowActionInfoXCommand;
import org.apache.oozie.command.wf.WorkflowActionRetryInfoXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogStreamer;

public class DagEngine
extends BaseEngine {
    private static final int HIGH_PRIORITY = 2;
    private static XLog LOG = XLog.getLog(DagEngine.class);
    private static final Set<String> FILTER_NAMES = new HashSet<String>();

    public DagEngine() {
    }

    public DagEngine(String user) {
        this();
        this.user = ParamChecker.notEmpty(user, "user");
    }

    @Override
    public String submitJob(Configuration conf, boolean startJob) throws DagEngineException {
        this.validateSubmitConfiguration(conf);
        try {
            SubmitXCommand submit = new SubmitXCommand(conf);
            String jobId = (String)submit.call();
            if (startJob) {
                this.start(jobId);
            }
            return jobId;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    public String submitJobFromCoordinator(Configuration conf, String parentId) throws DagEngineException {
        this.validateSubmitConfiguration(conf);
        try {
            SubmitXCommand submit = new SubmitXCommand(conf, parentId);
            String jobId = (String)submit.call();
            this.start(jobId);
            return jobId;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    public String submitHttpJob(Configuration conf, String jobType) throws DagEngineException {
        this.validateSubmitConfiguration(conf);
        try {
            SubmitHttpXCommand submit = null;
            if (jobType.equals("pig")) {
                submit = new SubmitPigXCommand(conf);
            } else if (jobType.equals("mapreduce")) {
                submit = new SubmitMRXCommand(conf);
            } else if (jobType.equals("hive")) {
                submit = new SubmitHiveXCommand(conf);
            } else if (jobType.equals("sqoop")) {
                submit = new SubmitSqoopXCommand(conf);
            }
            String jobId = (String)submit.call();
            this.start(jobId);
            return jobId;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    private void validateSubmitConfiguration(Configuration conf) throws DagEngineException {
        if (conf.get("oozie.wf.application.path") == null) {
            throw new DagEngineException(ErrorCode.E0401, "oozie.wf.application.path");
        }
    }

    @Override
    public void start(String jobId) throws DagEngineException {
        try {
            new StartXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void resume(String jobId) throws DagEngineException {
        try {
            new ResumeXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void suspend(String jobId) throws DagEngineException {
        try {
            new SuspendXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void kill(String jobId) throws DagEngineException {
        try {
            new KillXCommand(jobId).call();
            LOG.info("User " + this.user + " killed the WF job " + jobId);
        }
        catch (CommandException e) {
            throw new DagEngineException(e);
        }
    }

    @Override
    public void change(String jobId, String changeValue) throws DagEngineException {
        throw new DagEngineException(ErrorCode.E1017, new Object[0]);
    }

    @Override
    public void reRun(String jobId, Configuration conf) throws DagEngineException {
        try {
            WorkflowJobBean wfBean = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, jobId);
            XConfiguration wfConf = new XConfiguration(new StringReader(wfBean.getConf()));
            XConfiguration.copy(conf, wfConf);
            this.validateReRunConfiguration(wfConf);
            new ReRunXCommand(jobId, wfConf).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
        catch (JPAExecutorException ex) {
            throw new DagEngineException(ex);
        }
        catch (IOException ex) {
            throw new DagEngineException(ErrorCode.E0803, ex.getMessage());
        }
    }

    private void validateReRunConfiguration(Configuration conf) throws DagEngineException {
        if (conf.get("oozie.wf.application.path") == null) {
            throw new DagEngineException(ErrorCode.E0401, "oozie.wf.application.path");
        }
        if (conf.get("oozie.wf.rerun.skip.nodes") == null && conf.get("oozie.wf.rerun.failnodes") == null) {
            throw new DagEngineException(ErrorCode.E0401, "oozie.wf.rerun.skip.nodes OR oozie.wf.rerun.failnodes");
        }
        if (conf.get("oozie.wf.rerun.skip.nodes") != null && conf.get("oozie.wf.rerun.failnodes") != null) {
            throw new DagEngineException(ErrorCode.E0404, "oozie.wf.rerun.skip.nodes OR oozie.wf.rerun.failnodes");
        }
    }

    public void processCallback(String actionId, String externalStatus, Properties actionData) throws DagEngineException {
        XLog.Info.get().clearParameter("GROUP");
        XLog.Info.get().clearParameter("USER");
        CompletedActionXCommand command = null;
        command = new CompletedActionXCommand(actionId, externalStatus, actionData, 2);
        if (!Services.get().get(CallableQueueService.class).queue(command)) {
            LOG.warn(4, "queue is full or system is in SAFEMODE, ignoring callback", new Object[0]);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId) throws DagEngineException {
        try {
            return (WorkflowJob)new JobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId, int start, int length) throws DagEngineException {
        try {
            return (WorkflowJob)new JobXCommand(jobId, start, length).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public String getDefinition(String jobId) throws DagEngineException {
        try {
            return (String)new DefinitionXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    protected void streamJobLog(XLogStreamer logStreamer, String jobId, Writer writer) throws IOException, DagEngineException {
        logStreamer.getXLogFilter().setParameter("JOB", jobId);
        WorkflowJob job = this.getJob(jobId);
        Date lastTime = job.getEndTime();
        if (lastTime == null) {
            lastTime = job.getLastModifiedTime();
        }
        Services.get().get(XLogStreamingService.class).streamLog(logStreamer, job.getCreatedTime(), lastTime, writer);
    }

    protected Map<String, List<String>> parseFilter(String filter) throws DagEngineException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new DagEngineException(ErrorCode.E0420, filter, "elements must be semicolon-separated name=value pairs");
                    }
                    pair[0] = pair[0].toLowerCase();
                    if (!FILTER_NAMES.contains(pair[0])) {
                        throw new DagEngineException(ErrorCode.E0420, filter, XLog.format("invalid name [{0}]", pair[0]));
                    }
                    if (pair[0].equals("status")) {
                        try {
                            WorkflowJob.Status.valueOf((String)pair[1]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new DagEngineException(ErrorCode.E0420, filter, XLog.format("invalid status [{0}]", pair[1]));
                        }
                    }
                    if ((list = (ArrayList<String>)map.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new DagEngineException(ErrorCode.E0420, filter, "elements must be semicolon-separated name=value pairs");
            }
        }
        return map;
    }

    public WorkflowsInfo getJobs(String filter, int start, int len) throws DagEngineException {
        Map<String, List<String>> filterList = this.parseFilter(filter);
        try {
            return (WorkflowsInfo)new JobsXCommand(filterList, start, len).call();
        }
        catch (CommandException dce) {
            throw new DagEngineException(dce);
        }
    }

    @Override
    public String getJobIdForExternalId(String externalId) throws DagEngineException {
        try {
            return (String)new ExternalIdXCommand(externalId).call();
        }
        catch (CommandException dce) {
            throw new DagEngineException(dce);
        }
    }

    @Override
    public CoordinatorJob getCoordJob(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "cannot get a coordinator job from DagEngine"));
    }

    @Override
    public CoordinatorJob getCoordJob(String jobId, String filter, int start, int length, boolean desc) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "cannot get a coordinator job from DagEngine"));
    }

    public WorkflowActionBean getWorkflowAction(String actionId) throws BaseEngineException {
        try {
            return (WorkflowActionBean)new WorkflowActionInfoXCommand(actionId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    public List<Map<String, String>> getWorkflowActionRetries(String actionId) throws BaseEngineException {
        try {
            return (List)new WorkflowActionRetryInfoXCommand(actionId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public String dryRunSubmit(Configuration conf) throws BaseEngineException {
        try {
            SubmitXCommand submit = new SubmitXCommand(true, conf);
            return (String)submit.call();
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public String getJobStatus(String jobId) throws DagEngineException {
        try {
            WorkflowJobBean wfJob = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STATUS, jobId);
            return wfJob.getStatusStr();
        }
        catch (JPAExecutorException ex) {
            throw new DagEngineException(ex);
        }
    }

    @Override
    public void enableSLAAlert(String id, String actions, String dates, String childIds) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "Not supported for workflow"));
    }

    @Override
    public void disableSLAAlert(String id, String actions, String dates, String childIds) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "Not supported for workflow"));
    }

    @Override
    public void changeSLA(String id, String actions, String dates, String childIds, String newParams) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "Not supported for workflow"));
    }

    public WorkflowsInfo killJobs(String filter, int start, int len) throws DagEngineException {
        try {
            Map<String, List<String>> filterList = this.parseFilter(filter);
            WorkflowsInfo workflowsInfo = (WorkflowsInfo)new BulkWorkflowXCommand(filterList, start, len, OperationType.Kill).call();
            if (workflowsInfo == null) {
                return new WorkflowsInfo(new ArrayList<WorkflowJobBean>(), 0, 0, 0);
            }
            return workflowsInfo;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    public WorkflowsInfo suspendJobs(String filter, int start, int len) throws DagEngineException {
        try {
            Map<String, List<String>> filterList = this.parseFilter(filter);
            WorkflowsInfo workflowsInfo = (WorkflowsInfo)new BulkWorkflowXCommand(filterList, start, len, OperationType.Suspend).call();
            if (workflowsInfo == null) {
                return new WorkflowsInfo(new ArrayList<WorkflowJobBean>(), 0, 0, 0);
            }
            return workflowsInfo;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    public WorkflowsInfo resumeJobs(String filter, int start, int len) throws DagEngineException {
        try {
            Map<String, List<String>> filterList = this.parseFilter(filter);
            WorkflowsInfo workflowsInfo = (WorkflowsInfo)new BulkWorkflowXCommand(filterList, start, len, OperationType.Resume).call();
            if (workflowsInfo == null) {
                return new WorkflowsInfo(new ArrayList<WorkflowJobBean>(), 0, 0, 0);
            }
            return workflowsInfo;
        }
        catch (CommandException ex) {
            throw new DagEngineException(ex);
        }
    }

    static {
        FILTER_NAMES.add("text");
        FILTER_NAMES.add("user");
        FILTER_NAMES.add("name");
        FILTER_NAMES.add("group");
        FILTER_NAMES.add("status");
        FILTER_NAMES.add("id");
        FILTER_NAMES.add("startcreatedtime");
        FILTER_NAMES.add("endcreatedtime");
        FILTER_NAMES.add("sortby");
    }
}

