/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;

public class FsELFunctions {
    private static FileSystem getFileSystem(URI uri) throws HadoopAccessorException {
        WorkflowJobBean workflow = DagELFunctions.getWorkflow();
        String user = workflow.getUser();
        HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
        Configuration conf = has.createConfiguration(uri.getAuthority());
        return has.createFileSystem(user, uri, conf);
    }

    private static FileStatus getFileStatus(String pathUri) throws Exception {
        Path p;
        URI uri = new URI(pathUri);
        String path = uri.getPath();
        FileSystem fs = FsELFunctions.getFileSystem(uri);
        return fs.exists(p = new Path(path)) ? fs.getFileStatus(p) : null;
    }

    public static boolean fs_exists(String pathUri) throws Exception {
        FileStatus[] pathArr;
        Path path = new Path(pathUri);
        FileSystem fs = FsELFunctions.getFileSystem(path.toUri());
        try {
            pathArr = fs.globStatus(path, (PathFilter)new FSPathFilter());
        }
        catch (ReachingGlobMaxException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "FS013", "too many globbed files/dirs to do FS operation");
        }
        return pathArr != null && pathArr.length > 0;
    }

    public static boolean fs_isDir(String pathUri) throws Exception {
        boolean isDir = false;
        FileStatus fileStatus = FsELFunctions.getFileStatus(pathUri);
        if (fileStatus != null) {
            isDir = fileStatus.isDirectory();
        }
        return isDir;
    }

    public static long fs_fileSize(String pathUri) throws Exception {
        long len = -1L;
        FileStatus fileStatus = FsELFunctions.getFileStatus(pathUri);
        if (fileStatus != null) {
            len = fileStatus.getLen();
        }
        return len;
    }

    public static long fs_dirSize(String pathUri) throws Exception {
        URI uri = new URI(pathUri);
        String path = uri.getPath();
        long size = -1L;
        try {
            FileSystem fs = FsELFunctions.getFileSystem(uri);
            Path p = new Path(path);
            if (fs.exists(p) && !fs.isFile(p)) {
                FileStatus[] stati = fs.listStatus(p);
                size = 0L;
                if (stati != null) {
                    for (FileStatus status : stati) {
                        if (status.isDirectory()) continue;
                        size += status.getLen();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return size;
    }

    public static long fs_blockSize(String pathUri) throws Exception {
        long blockSize = -1L;
        FileStatus fileStatus = FsELFunctions.getFileStatus(pathUri);
        if (fileStatus != null) {
            blockSize = fileStatus.getBlockSize();
        }
        return blockSize;
    }

    static class ReachingGlobMaxException
    extends RuntimeException {
        ReachingGlobMaxException() {
        }
    }

    static class FSPathFilter
    implements PathFilter {
        int count = 0;
        int globMax = ConfigurationService.getInt("oozie.action.fs.glob.max");

        public boolean accept(Path p) {
            ++this.count;
            if (this.count > this.globMax) {
                throw new ReachingGlobMaxException();
            }
            return true;
        }
    }
}

