/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.base.Strings;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XLog;

class LauncherConfigurationInjector {
    private static final XLog LOG = XLog.getLog(LauncherConfigurationInjector.class);
    private static final String OOZIE_LAUNCHER_PREFIX = "oozie.launcher.";
    private static final String OVERRIDE_PREFIX = "oozie.launcher.override.";
    private static final String PREPEND_PREFIX = "oozie.launcher.prepend.";
    private static final Multimap<String, String> CONFIGURED_OVERRIDE_PROPERTIES = LinkedHashMultimap.create();
    private static final Multimap<String, String> CONFIGURED_PREPEND_PROPERTIES = LinkedHashMultimap.create();
    private static final String OVERRIDE_REGEX = "^oozie\\.launcher\\.override\\.+";
    private static final String PREPEND_REGEX = "^oozie\\.launcher\\.prepend\\.+";
    private final Configuration sourceConfiguration;
    private final Map<String, String> overridesPresentInSource = Maps.newLinkedHashMap();
    private final Map<String, String> prependsPresentInSource = Maps.newLinkedHashMap();

    private static void fillConfigPropertiesByRegex(String regex, Multimap<String, String> target) {
        for (Map.Entry<String, String> overrideEntry : ConfigurationService.getValByRegex(regex).entrySet()) {
            String key = overrideEntry.getKey();
            for (String value : ConfigurationService.getStrings(key)) {
                target.put((Object)key, (Object)value);
            }
        }
    }

    LauncherConfigurationInjector(Configuration sourceConfiguration) {
        this.sourceConfiguration = sourceConfiguration;
    }

    void inject(Configuration launcherConf) {
        LOG.debug("Injecting configuration entries to launcher configuration.");
        this.copyToLauncherConf(this.sourceConfiguration, launcherConf);
        LOG.debug("Configuration entries copied to launcher configuration successfully.");
        if (ConfigurationService.getBoolean("oozie.launcher.override")) {
            LOG.debug("Overriding and prepending launcher configuration.");
            LOG.trace("Filling override and prepend configuration values.");
            this.fillOverridesOrPrepends(CONFIGURED_OVERRIDE_PROPERTIES, OVERRIDE_PREFIX, this.overridesPresentInSource);
            this.fillOverridesOrPrepends(CONFIGURED_PREPEND_PROPERTIES, PREPEND_PREFIX, this.prependsPresentInSource);
            LOG.trace("Override and prepend configuration values filled. [overridesPresentInSource={0};prependsPresentInSource={1}]", this.overridesPresentInSource, this.prependsPresentInSource);
            this.overrideAndPrependLauncherConf(launcherConf);
            LOG.debug("Launcher configuration overridden and prepended.");
            LOG.trace("Launcher configuration finalized. [launcherConf={0}]", launcherConf);
        }
        LOG.debug("Configuration entries injected to launcher configuration.");
    }

    private void fillOverridesOrPrepends(Multimap<String, String> overrideOrPrependProperties, String prefix, Map<String, String> target) {
        for (Map.Entry overrideProperty : overrideOrPrependProperties.asMap().entrySet()) {
            String launcherKey = ((String)overrideProperty.getKey()).replace(prefix, OOZIE_LAUNCHER_PREFIX);
            Collection sourceKeys = (Collection)overrideProperty.getValue();
            LOG.trace("Filling launcher override / prepend value. [sourceKeys={0};launcherKey={1}]", sourceKeys, launcherKey);
            this.fillOverrideOrPrependLauncherValue(sourceKeys, launcherKey, target);
        }
    }

    private void fillOverrideOrPrependLauncherValue(Collection<String> sourceKeys, String launcherKey, Map<String, String> target) {
        String sourceValue = this.getFirstSourceValue(sourceKeys);
        if (!Strings.isNullOrEmpty((String)sourceValue)) {
            target.put(launcherKey, sourceValue);
        }
    }

    private String getFirstSourceValue(Collection<String> propertyKeys) {
        if (propertyKeys == null) {
            return null;
        }
        for (String propertyKey : propertyKeys) {
            String propertyValue = this.sourceConfiguration.get(propertyKey);
            if (Strings.isNullOrEmpty((String)propertyValue)) continue;
            return propertyValue;
        }
        return null;
    }

    private void overrideAndPrependLauncherConf(Configuration launcherConfiguration) {
        for (String overrideKey : this.overridesPresentInSource.keySet()) {
            this.overrideSingleValue(launcherConfiguration, overrideKey);
        }
        for (String prependKey : this.prependsPresentInSource.keySet()) {
            this.prependSingleValue(launcherConfiguration, prependKey);
        }
    }

    private void overrideSingleValue(Configuration launcherConfiguration, String key) {
        String originalLauncherValue = launcherConfiguration.get(key);
        String overrideValue = this.overridesPresentInSource.get(key);
        if (Strings.isNullOrEmpty((String)originalLauncherValue) && overrideValue != null) {
            launcherConfiguration.set(key, overrideValue);
        }
    }

    private void prependSingleValue(Configuration launcherConfiguration, String key) {
        String launcherValue = launcherConfiguration.get(key);
        String prependValue = this.prependsPresentInSource.get(key);
        if (!Strings.isNullOrEmpty((String)prependValue)) {
            if (Strings.isNullOrEmpty((String)launcherValue)) {
                launcherConfiguration.set(key, prependValue);
            } else {
                launcherConfiguration.set(key, prependValue + " " + launcherValue);
            }
        }
    }

    private void copyToLauncherConf(Configuration source, Configuration target) {
        for (Map.Entry entry : source) {
            if (!((String)entry.getKey()).startsWith(OOZIE_LAUNCHER_PREFIX)) continue;
            String name = ((String)entry.getKey()).substring(OOZIE_LAUNCHER_PREFIX.length());
            String value = (String)entry.getValue();
            target.set((String)entry.getKey(), value);
            target.set(name, value);
        }
    }

    static {
        LauncherConfigurationInjector.fillConfigPropertiesByRegex(OVERRIDE_REGEX, CONFIGURED_OVERRIDE_PROPERTIES);
        LauncherConfigurationInjector.fillConfigPropertiesByRegex(PREPEND_REGEX, CONFIGURED_PREPEND_PROPERTIES);
    }
}

