/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;

public class BundleCoordSubmitXCommand
extends CoordSubmitXCommand {
    private String coordId;

    public BundleCoordSubmitXCommand(Configuration conf, String bundleId, String coordName) {
        super(conf, bundleId, coordName);
    }

    @Override
    public String getEntityKey() {
        return this.bundleId + "_" + this.coordName;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
        super.verifyPrecondition();
        if (this.coordId != null) {
            this.LOG.warn("Coord [{0}] is already submitted for bundle [{1}]", this.coordId, this.bundleId);
            throw new CommandException(ErrorCode.E1304, this.coordName);
        }
    }

    @Override
    protected void loadState() throws CommandException {
        super.loadState();
        try {
            CoordinatorJobBean coordJobs = CoordJobQueryExecutor.getInstance().getIfExist(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOBS_FOR_BUNDLE_BY_APPNAME_ID, this.coordName, this.bundleId);
            if (coordJobs != null) {
                this.coordId = coordJobs.getId();
            }
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.getEntityKey();
    }
}

