/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetForInfoJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class CoordActionInfoXCommand
extends CoordinatorXCommand<CoordinatorActionBean> {
    private final String id;

    public CoordActionInfoXCommand(String id) {
        super("action.info", "action.info", 1);
        this.id = ParamChecker.notEmpty(id, "id");
    }

    @Override
    protected CoordinatorActionBean execute() throws CommandException {
        JPAService jpaService = Services.get().get(JPAService.class);
        if (jpaService != null) {
            CoordinatorActionBean action;
            try {
                action = jpaService.execute(new CoordActionGetForInfoJPAExecutor(this.id));
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
            return action;
        }
        this.LOG.error((Object)ErrorCode.E0610);
        return null;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }
}

