/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.AppType;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.command.coord.CoordActionUpdateXCommand;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;

public abstract class WorkflowXCommand<T>
extends XCommand<T> {
    public static final String KEEP_WF_ACTION_DIR = "oozie.action.keep.action.dir";
    protected static final String INSTR_SUCCEEDED_JOBS_COUNTER_NAME = "succeeded";
    protected static final String INSTR_KILLED_JOBS_COUNTER_NAME = "killed";
    protected static final String INSTR_FAILED_JOBS_COUNTER_NAME = "failed";

    public WorkflowXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public WorkflowXCommand(String name, String type, int priority, boolean dryrun) {
        super(name, type, priority, dryrun);
    }

    protected static void generateEvent(WorkflowJobBean wfJob, String errorCode, String errorMsg) {
        if (eventService.isSupportedApptype(AppType.WORKFLOW_JOB.name())) {
            WorkflowJobEvent event = new WorkflowJobEvent(wfJob.getId(), wfJob.getParentId(), wfJob.getStatus(), wfJob.getUser(), wfJob.getAppName(), wfJob.getStartTime(), wfJob.getEndTime());
            event.setErrorCode(errorCode);
            event.setErrorMessage(errorMsg);
            eventService.queueEvent((Event)event);
        }
    }

    protected static void generateEvent(WorkflowJobBean wfJob) {
        WorkflowXCommand.generateEvent(wfJob, null, null);
    }

    protected void generateEvent(WorkflowActionBean wfAction, String wfUser) {
        if (eventService.isSupportedApptype(AppType.WORKFLOW_ACTION.name())) {
            WorkflowActionEvent event = new WorkflowActionEvent(wfAction.getId(), wfAction.getJobId(), wfAction.getStatus(), wfUser, wfAction.getName(), wfAction.getStartTime(), wfAction.getEndTime());
            event.setErrorCode(wfAction.getErrorCode());
            event.setErrorMessage(wfAction.getErrorMessage());
            eventService.queueEvent((Event)event);
        }
    }

    protected void updateParentIfNecessary(WorkflowJobBean wfjob, int maxRetries) throws CommandException {
        if (wfjob.getParentId() != null && wfjob.getParentId().contains("-C@")) {
            new CoordActionUpdateXCommand(wfjob, maxRetries).call();
        }
    }

    protected void updateParentIfNecessary(WorkflowJobBean wfjob) throws CommandException {
        if (wfjob.getParentId() != null && wfjob.getParentId().contains("-C@")) {
            new CoordActionUpdateXCommand(wfjob).call();
        }
    }
}

