/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class InputLogicParser {
    public static final String COORD_INPUT_EVENTS_DATA_IN = "data-in";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String COMBINE = "combine";

    public String parse(Element root) {
        return this.parseWithName(root, null);
    }

    public String parseWithName(Element root, String name) {
        if (root == null) {
            return "";
        }
        StringBuffer parsedString = new StringBuffer();
        List childrens = root.getChildren();
        for (int i = 0; i < childrens.size(); ++i) {
            String childName = ((Element)childrens.get(i)).getAttributeValue("name");
            String min = ((Element)childrens.get(i)).getAttributeValue("min");
            String wait = ((Element)childrens.get(i)).getAttributeValue("wait");
            if (name == null || name.equals(childName)) {
                parsedString.append(this.parse((Element)childrens.get(i), this.getOpt(((Element)childrens.get(i)).getName()), min, wait));
                continue;
            }
            parsedString.append(this.parseWithName((Element)childrens.get(i), name));
        }
        return parsedString.toString();
    }

    public String parse(Element root, String opt, String min, String wait) {
        StringBuffer parsedString = new StringBuffer();
        Namespace ns = root.getNamespace();
        if (root.getName().equals(COMBINE)) {
            parsedString.append("(");
            parsedString.append(this.processCombinedNode(root, this.getOpt(root.getName()), this.getMin(root, min), this.getWait(root, wait)));
            parsedString.append(")");
        } else if (root.getName().equals(AND) || root.getName().equals(OR)) {
            parsedString.append("(");
            parsedString.append(this.parseAllChildren(root, opt, this.getOpt(root.getName()), this.getMin(root, min), this.getWait(root, wait)));
            parsedString.append(")");
        } else if (root.getChild(COORD_INPUT_EVENTS_DATA_IN, ns) != null) {
            parsedString.append("(");
            parsedString.append(this.processChildNode(root, this.getOpt(root.getName()), this.getMin(root, min), this.getWait(root, wait)));
            parsedString.append(")");
        } else if (root.getName().equals(COORD_INPUT_EVENTS_DATA_IN)) {
            parsedString.append(this.parseDataInNode(root, min, wait));
        }
        return parsedString.toString();
    }

    private String parseAllChildren(Element root, String parentOpt, String opt, String min, String wait) {
        StringBuffer parsedString = new StringBuffer();
        List childrens = root.getChildren();
        for (int i = 0; i < childrens.size(); ++i) {
            String currentMin = min;
            String currentWait = wait;
            String childMin = ((Element)childrens.get(i)).getAttributeValue("min");
            String childWait = ((Element)childrens.get(i)).getAttributeValue("wait");
            if (!StringUtils.isEmpty((String)childMin)) {
                currentMin = childMin;
            }
            if (!StringUtils.isEmpty((String)childWait)) {
                currentWait = childWait;
            }
            parsedString.append(this.parse((Element)childrens.get(i), opt, currentMin, currentWait));
            if (i >= childrens.size() - 1 || StringUtils.isEmpty((String)opt)) continue;
            parsedString.append(" " + opt + " ");
        }
        return parsedString.toString();
    }

    private String parseDataInNode(Element root, String min, String wait) {
        StringBuffer parsedString = new StringBuffer();
        String nestedChildDataName = root.getAttributeValue("dataset");
        parsedString.append("dependencyBuilder.input(\"" + nestedChildDataName + "\")");
        this.appendMin(root, min, parsedString);
        this.appendWait(root, wait, parsedString);
        parsedString.append(".build()");
        return parsedString.toString();
    }

    private String processChildNode(Element root, String opt, String min, String wait) {
        StringBuffer parsedString = new StringBuffer();
        Namespace ns = root.getNamespace();
        List childrens = root.getChildren(COORD_INPUT_EVENTS_DATA_IN, ns);
        for (int i = 0; i < childrens.size(); ++i) {
            parsedString.append(this.parseDataInNode((Element)childrens.get(i), min, wait));
            if (i >= childrens.size() - 1) continue;
            parsedString.append(" " + opt + " ");
        }
        return parsedString.toString();
    }

    private String processCombinedNode(Element root, String opt, String min, String wait) {
        StringBuffer parsedString = new StringBuffer();
        Namespace ns = root.getNamespace();
        List childrens = root.getChildren(COORD_INPUT_EVENTS_DATA_IN, ns);
        parsedString.append("dependencyBuilder.combine(");
        for (int i = 0; i < childrens.size(); ++i) {
            String nestedChildDataName = ((Element)childrens.get(i)).getAttributeValue("dataset");
            parsedString.append("\"" + nestedChildDataName + "\"");
            if (i >= childrens.size() - 1) continue;
            parsedString.append(",");
        }
        parsedString.append(")");
        this.appendMin(root, min, parsedString);
        this.appendWait(root, wait, parsedString);
        parsedString.append(".build()");
        return parsedString.toString();
    }

    private String getOpt(String opt) {
        if (opt.equalsIgnoreCase(OR)) {
            return "||";
        }
        if (opt.equalsIgnoreCase(AND)) {
            return "&&";
        }
        return "";
    }

    private String getMin(Element root, String parentMin) {
        String min = root.getAttributeValue("min");
        if (StringUtils.isEmpty((String)min)) {
            return parentMin;
        }
        return min;
    }

    private String getWait(Element root, String parentWait) {
        String wait = root.getAttributeValue("wait");
        if (StringUtils.isEmpty((String)parentWait)) {
            return parentWait;
        }
        return wait;
    }

    private void appendWait(Element root, String wait, StringBuffer parsedString) {
        String childWait = root.getAttributeValue("wait");
        if (!StringUtils.isEmpty((String)childWait)) {
            parsedString.append(".inputWait(" + childWait + ")");
        } else if (!StringUtils.isEmpty((String)wait)) {
            parsedString.append(".inputWait(" + wait + ")");
        }
    }

    private void appendMin(Element root, String min, StringBuffer parsedString) {
        String childMin = root.getAttributeValue("min");
        if (!StringUtils.isEmpty((String)childMin)) {
            parsedString.append(".min(" + childMin + ")");
        } else if (!StringUtils.isEmpty((String)min)) {
            parsedString.append(".min(" + min + ")");
        }
    }
}

